"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSoftInputAppliedOffsetChanged = useSoftInputAppliedOffsetChanged;
exports.useSoftInputHeightChanged = useSoftInputHeightChanged;
exports.useSoftInputHidden = useSoftInputHidden;
exports.useSoftInputShown = useSoftInputShown;
exports.useSoftInputState = useSoftInputState;
var _react = require("react");
var _AvoidSoftInput = require("./AvoidSoftInput");
var _stateReducer = require("./stateReducer");
function useSoftInputAppliedOffsetChanged(callback) {
  (0, _react.useEffect)(() => {
    const unsubscribeAppliedOffsetChanged = _AvoidSoftInput.AvoidSoftInput.onSoftInputAppliedOffsetChange(callback);
    return () => {
      unsubscribeAppliedOffsetChanged.remove();
    };
  }, [callback]);
}
function useSoftInputHeightChanged(callback) {
  (0, _react.useEffect)(() => {
    const unsubscribeHeightChanged = _AvoidSoftInput.AvoidSoftInput.onSoftInputHeightChange(callback);
    return () => {
      unsubscribeHeightChanged.remove();
    };
  }, [callback]);
}
function useSoftInputHidden(callback) {
  (0, _react.useEffect)(() => {
    const unsubscribeHidden = _AvoidSoftInput.AvoidSoftInput.onSoftInputHidden(callback);
    return () => {
      unsubscribeHidden.remove();
    };
  }, [callback]);
}
function useSoftInputShown(callback) {
  (0, _react.useEffect)(() => {
    const unsubscribeShown = _AvoidSoftInput.AvoidSoftInput.onSoftInputShown(callback);
    return () => {
      unsubscribeShown.remove();
    };
  }, [callback]);
}
function useSoftInputState() {
  const [state, dispatch] = (0, _react.useReducer)(_stateReducer.reducer, _stateReducer.initialState);
  useSoftInputHeightChanged(({
    softInputHeight
  }) => {
    dispatch((0, _stateReducer.createAction)(softInputHeight));
  });
  return state;
}
//# sourceMappingURL=hooks.js.map