/**
 * @license lucide-react-native v0.541.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */

'use strict';

var react = require('react');
var NativeSvg = require('react-native-svg');
var defaultAttributes = require('./defaultAttributes.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var NativeSvg__namespace = /*#__PURE__*/_interopNamespaceDefault(NativeSvg);

const createLucideIcon = (iconName, iconNode) => {
  const Component = react.forwardRef(
    ({
      color = "currentColor",
      size = 24,
      strokeWidth = 2,
      absoluteStrokeWidth,
      children,
      "data-testid": dataTestId,
      ...rest
    }, ref) => {
      const customAttrs = {
        stroke: color,
        strokeWidth: absoluteStrokeWidth ? Number(strokeWidth) * 24 / Number(size) : strokeWidth,
        ...rest
      };
      return react.createElement(
        NativeSvg__namespace.Svg,
        {
          ref,
          ...defaultAttributes.default,
          width: size,
          height: size,
          "data-testid": dataTestId,
          ...customAttrs
        },
        [
          ...iconNode.map(([tag, attrs]) => {
            const upperCasedTag = tag.charAt(0).toUpperCase() + tag.slice(1);
            return react.createElement(
              NativeSvg__namespace[upperCasedTag],
              { ...defaultAttributes.childDefaultAttributes, ...customAttrs, ...attrs }
            );
          }),
          ...(Array.isArray(children) ? children : [children]) || []
        ]
      );
    }
  );
  Component.displayName = `${iconName}`;
  return Component;
};

module.exports = createLucideIcon;
//# sourceMappingURL=createLucideIcon.js.map
