import type { License, ScanPackageOptionsFactory } from '../../types';
export declare function getPackageJsonPath(dependency: string, root?: string): string | null;
export declare function resolvePackageJsonFromEntry(dependency: string): string | null;
export declare function findPackageRoot(entryPath: string): string | undefined;
export declare function normalizePackageName(packageName: string): string;
export declare function prepareAboutLibrariesLicenseField(license: License): string;
export declare function parseAuthorField(json: {
    author: string | {
        name: string;
    };
}): string | undefined;
export declare function parseLicenseField(json: {
    license: string | {
        type: string;
    };
}): string | undefined;
export declare function parseRepositoryFieldToUrl(json: {
    repository: string | {
        url?: string;
    };
}): string | undefined;
/**
 * Default value consistent with legacy behaviour assumptions for the scan package options factory
 * used so as not to introduce breaking API changes
 */
export declare const legacyDefaultScanPackageOptionsFactory: ScanPackageOptionsFactory;
