"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sha512 = sha512;
exports.compareObjects = compareObjects;
exports.arrayIncludesObject = arrayIncludesObject;
const crypto_1 = __importDefault(require("crypto"));
function sha512(text) {
    return crypto_1.default.createHash('sha512').update(text).digest('hex');
}
function compareObjects(a, b) {
    if (a == null || b == null || typeof a !== 'object' || typeof b !== 'object') {
        return a === b;
    }
    const entriesA = Object.entries(a);
    const entriesB = Object.entries(b);
    return (entriesA.length === entriesB.length &&
        entriesA
            .map(([keyA, valueA]) => {
            const entry = entriesB.find(([keyB]) => keyA === keyB);
            if (!entry) {
                return valueA === entry;
            }
            const [, valueB] = entry;
            return compareObjects(valueA, valueB);
        })
            .reduce((acc, curr) => acc && curr, true));
}
/**
 * Makes a deep-check between array items and provided object, returns true if array has provided object.
 */
function arrayIncludesObject(array, object) {
    if (!Array.isArray(array)) {
        return;
    }
    return array.map((item) => compareObjects(item, object)).reduce((acc, curr) => acc || curr, false);
}
