package dev.mateusznowak.demodulate

import android.content.res.Configuration
import android.os.Bundle
import com.facebook.react.ReactActivity
import com.facebook.react.ReactActivityDelegate
import com.facebook.react.defaults.DefaultNewArchitectureEntryPoint.fabricEnabled
import com.facebook.react.defaults.DefaultReactActivityDelegate

class MainActivity : ReactActivity() {
    var savedLocale = ""
    var savedRTL = 0

    override fun getMainComponentName(): String = "Demodulate"

    override fun createReactActivityDelegate(): ReactActivityDelegate =
        DefaultReactActivityDelegate(this, mainComponentName, fabricEnabled)

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        savedLocale = resources.configuration.locales[0].toString()
        savedRTL = resources.configuration.layoutDirection
    }

    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)

        val locale = newConfig.locales[0].toString()
        val rtl = newConfig.layoutDirection

        if (savedLocale != locale || savedRTL != rtl) {
            savedLocale = locale
            savedRTL = rtl

            reactInstanceManager.recreateReactContextInBackground()
        }
    }
}
