Project description can be found
[on my website](https://mateusznowak.dev/projects/demodulate-radio-app/).

---

## For developers

### Testing checklist

(This is based on bugs I've encountered so far, and may be useful when upgrading dependencies.)

- [ ] UI must be displayed correctly: margins and paddings with default font, text ellipsis in the
      player UI, colors and shadows (including dark mode), scene animations, selected item
      highlight, edge-to-edge. Scenes must NOT reset when switching between them. Tapping must work
      consistently on any of the scrollable lists. Dialogs must be possible to close with the "back"
      button/gesture.
- [ ] Artwork must be displayed in the notification area, even if the station does not send any
      track metadata (temporarily during ads or at all). App UI and the notification area must be
      updated when new metadata arrives, and be in sync all the time. Notification area buttons and
      basic hardware buttons (play, pause, next) must work as expected.
- [ ] Network errors must be handled and shown when necessary: no internet connection, server not
      available, invalid data, timeouts, certificate errors, etc. User data must load and save
      correctly.
- [ ] App must work on the oldest (minSdkVersion) and newest Android version supported, and on at
      least one real device running recent Android version. App must be compatible with 16k page
      size. App must support split screen. App must reload its UI when language or layout direction
      is changed. App does not need to support floating windows or tablet mode (but must not crash).

### Running in debug mode

Make sure `$ANDROID_HOME` environment variable points to the SDK root.

Make sure `$EDGE_PATH` environment variable points to the Chromium-like executable. It will even
work with flatpak Chromium:

```bash
export ANDROID_HOME=/home/user/Android/Sdk
export EDGE_PATH=/var/lib/flatpak/exports/bin/org.chromium.Chromium
```

Start the Metro bundler:

```
npm run start
```

Start the emulator. The fixed scale mode is useful for testing layouts:

```
$ANDROID_HOME/emulator/emulator -avd "AVD_NAME" -fixed-scale
```

Once the emulator is up and running, build and start the app:

```
npm run update-license-data
npm run run-android
```

If Metro crashes for whatever reason, you need to restart it, then build app again, then reload dev
tools if needed.

### Building in release mode

Build with cache removed:

```
rm -r android/.cxx     android/.gradle     android/.kotlin     android/build
rm -r android/app/.cxx android/app/.gradle android/app/.kotlin android/app/build
npm run build-android
```

This will generate one or more APK files in the `android/app/build/outputs/apk/release` directory.

### Test building for F-Droid

This will generate an unsigned APK.

You may need to temporarily move the entire contents of `sudo` section into `init`. Remember to do
this for all versions in a manifest file.

```
docker run --pull always --rm -v $ANDROID_HOME:/opt/android-sdk -v [path to fdroiddata repo]:/repo -e ANDROID_HOME:/opt/android-sdk --entrypoint /bin/bash -it registry.gitlab.com/fdroid/docker-executable-fdroidserver:master

. /etc/profile.d/bsenv.sh
rm -r build/dev.mateusznowak.demodulate logs tmp unsigned
GRADLE_USER_HOME=${home_vagrant}/.gradle ${fdroidserver}/fdroid build --no-refresh --verbose --latest dev.mateusznowak.demodulate
```

Unsigned APK can't be installed on a real device. It needs to be signed first (can use a debug key):

```
$ANDROID_HOME/build-tools/35.0.0/apksigner sign --ks build/dev.mateusznowak.demodulate/android/app/debug.keystore --ks-key-alias androiddebugkey --ks-pass pass:android build/dev.mateusznowak.demodulate/android/app/build/outputs/apk/release/app-arm64-v8a-release-unsigned.apk
```

Troubleshooting:

- Android licenses not accepted but worked locally on the same SDK? Probably the mounted SDK
  directory is invalid.

### Component versions and updates

All component versions are listed in these files:

- `package.json`
- `android/build.gradle`
- `android/app/build.gradle`
- `android/gradle/gradle-wrapper.properties`

JavaScript RN packages are pinned to their exact versions. AGP and Gradle versions are adjusted for
project needs (and can't be further updated because F-Droid build servers have ancient CPUs).
SDK/NDK/Kotlin/React/... versions are the ones recommended by RN.

Updated libraries need to be tested for compatibility with F-Droid build system (see "Test building
for F-Droid").

For your own sanity, always update RN one version at a time, and always remove all caches before
updating (see "Building in release mode").

Application version is specified in these places:

- `app/build.gradle` file
- `APP_VERSION` variables across the source code

F-Droid build will be triggered only when the release commit is tagged appropriately. It may take
some time for their bot to detect new tags. Should there be problems, an update to `fdroiddata` repo
may be necessary.
