"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.openAppLanguageSettings = exports.usesMetricSystem = exports.usesAutoTimeZone = exports.usesAutoDateAndTime = exports.uses24HourClock = exports.getTimeZone = exports.getTemperatureUnit = exports.findBestLanguageTag = exports.getNumberFormatSettings = exports.getLocales = exports.getCurrencies = exports.getCountry = exports.getCalendar = void 0;
const getCalendar = () => "gregorian"; // the calendar identifier you want
exports.getCalendar = getCalendar;
const getCountry = () => "US"; // the country code you want
exports.getCountry = getCountry;
const getCurrencies = () => ["USD", "EUR"]; // can be empty array
exports.getCurrencies = getCurrencies;
const getLocales = () => [
    // extend if needed, add the locales you want
    { countryCode: "US", languageTag: "en-US", languageCode: "en", isRTL: false },
    { countryCode: "FR", languageTag: "fr-FR", languageCode: "fr", isRTL: false },
];
exports.getLocales = getLocales;
const getNumberFormatSettings = () => ({
    decimalSeparator: ".",
    groupingSeparator: ",",
});
exports.getNumberFormatSettings = getNumberFormatSettings;
// use a provided translation, or return undefined to test your fallback
const findBestLanguageTag = () => ({
    languageTag: "en-US",
    isRTL: false,
});
exports.findBestLanguageTag = findBestLanguageTag;
const getTemperatureUnit = () => "celsius"; // or "fahrenheit"
exports.getTemperatureUnit = getTemperatureUnit;
const getTimeZone = () => "Europe/Paris"; // the timezone you want
exports.getTimeZone = getTimeZone;
const uses24HourClock = () => true;
exports.uses24HourClock = uses24HourClock;
const usesAutoDateAndTime = () => true;
exports.usesAutoDateAndTime = usesAutoDateAndTime;
const usesAutoTimeZone = () => true;
exports.usesAutoTimeZone = usesAutoTimeZone;
const usesMetricSystem = () => true;
exports.usesMetricSystem = usesMetricSystem;
const openAppLanguageSettings = () => __awaiter(void 0, void 0, void 0, function* () { });
exports.openAppLanguageSettings = openAppLanguageSettings;
