import { useTranslation } from "react-i18next";
import { Text } from "react-native-paper";

import { clearHistory } from "../api/LocalStorage";
import { Modal } from "../components";

export function ClearHistoryModal({ hide }) {
  const { t } = useTranslation();

  return (
    <Modal
      buttonNegative={{ label: t("dialog_no"), onPress: hide }}
      buttonPositive={{ label: t("dialog_yes"), onPress: () => clearHistory().then(hide) }}
      onDismiss={hide}
    >
      <Text>{t("settings_clear_history_confirm")}</Text>
    </Modal>
  );
}
