import i18n from "i18next";
import { initReactI18next } from "react-i18next";
import { getLocales } from "react-native-localize";

import EN from "./translations/en";
import PL from "./translations/pl";

i18n.use(initReactI18next).init({
  resources: {
    // KEEP THIS LIST SORTED ALPHABETICALLY. Use ISO 639 codes.
    en: EN,
    pl: PL,
  },
  lng: getLocales()?.[0].languageCode.toLowerCase(),
  fallbackLng: "en",
  interpolation: {
    escapeValue: false,
  },
});

export default i18n;
