import { NativeModules, Platform } from 'react-native';
const {
  DeviceCountryModule
} = NativeModules;
export const TYPE_ANY = 'any';
export const TYPE_TELEPHONY = 'telephony';
export const TYPE_CONFIGURATION = 'config';
export const getCountryCodeIOS = () => {
  return new Promise((resolve, reject) => {
    DeviceCountryModule.getCountryCode(TYPE_CONFIGURATION).then(result => {
      resolve(result);
    }).catch(e => {
      reject(e);
    });
  });
};
export const getCountryCodeAndroid = type => {
  return new Promise((resolve, reject) => {
    DeviceCountryModule.getCountryCode(type || TYPE_ANY).then(result => {
      resolve(JSON.parse(result));
    }).catch(e => {
      reject(e);
    });
  });
};
export const getCountryCode = type => {
  return Platform.OS === 'ios' ? getCountryCodeIOS() : getCountryCodeAndroid(type);
};
export default {
  getCountryCode
};
//# sourceMappingURL=index.js.map