"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.getCountryCode = exports.getCountryCodeAndroid = exports.getCountryCodeIOS = exports.TYPE_CONFIGURATION = exports.TYPE_TELEPHONY = exports.TYPE_ANY = void 0;

var _reactNative = require("react-native");

const {
  DeviceCountryModule
} = _reactNative.NativeModules;
const TYPE_ANY = 'any';
exports.TYPE_ANY = TYPE_ANY;
const TYPE_TELEPHONY = 'telephony';
exports.TYPE_TELEPHONY = TYPE_TELEPHONY;
const TYPE_CONFIGURATION = 'config';
exports.TYPE_CONFIGURATION = TYPE_CONFIGURATION;

const getCountryCodeIOS = () => {
  return new Promise((resolve, reject) => {
    DeviceCountryModule.getCountryCode(TYPE_CONFIGURATION).then(result => {
      resolve(result);
    }).catch(e => {
      reject(e);
    });
  });
};

exports.getCountryCodeIOS = getCountryCodeIOS;

const getCountryCodeAndroid = type => {
  return new Promise((resolve, reject) => {
    DeviceCountryModule.getCountryCode(type || TYPE_ANY).then(result => {
      resolve(JSON.parse(result));
    }).catch(e => {
      reject(e);
    });
  });
};

exports.getCountryCodeAndroid = getCountryCodeAndroid;

const getCountryCode = type => {
  return _reactNative.Platform.OS === 'ios' ? getCountryCodeIOS() : getCountryCodeAndroid(type);
};

exports.getCountryCode = getCountryCode;
var _default = {
  getCountryCode
};
exports.default = _default;
//# sourceMappingURL=index.js.map