import type { EmitterSubscription } from 'react-native';
import type { SoftInputAppliedOffsetEventData, SoftInputEasing, SoftInputEventData } from './types';
/**
 * Fires event with current soft input height, when soft input is shown
 */
declare function onSoftInputShown(listener: ({ softInputHeight }: SoftInputEventData) => void): EmitterSubscription;
/**
 * Fires event when soft input is hidden
 */
declare function onSoftInputHidden(listener: ({ softInputHeight }: SoftInputEventData) => void): EmitterSubscription;
/**
 * Fires event when soft input height changed
 */
declare function onSoftInputAppliedOffsetChange(listener: ({ appliedOffset }: SoftInputAppliedOffsetEventData) => void): EmitterSubscription;
/**
 * Fires event when soft input's height changes
 */
declare function onSoftInputHeightChange(listener: ({ softInputHeight }: SoftInputEventData) => void): EmitterSubscription;
/**
 * Set whether module is enabled
 */
declare function setEnabled(enabled: boolean): void;
/**
 * Set should mimic IOS ime behavior (true), or let Android OS handle (resize) window (false)
 *
 * @platform `Android`
 * @deprecated Since v7 use `react-native-edge-to-edge` to control "edge to edge" mode on Android
 */
declare function setShouldMimicIOSBehavior(shouldMimic: boolean): void;
/**
 * Sets additional offset that will be added to value applied to root view/scroll view
 *
 * Can be negative (then final value will be smaller, so that some part of focused view will be covered by soft input frame)
 */
declare function setAvoidOffset(offset: number): void;
/**
 * Sets easing function that will be applied to applied offset animation, default is `linear`
 */
declare function setEasing(easing: SoftInputEasing): void;
/**
 * Sets hide animation delay, takes value in milliseconds, if no value is provided, it will set default value which is `0` ms
 */
declare function setHideAnimationDelay(delay?: number): void;
/**
 * Sets hide animation duration, takes value in milliseconds, if no value is provided, it will set default value which is `220` ms
 */
declare function setHideAnimationDuration(duration?: number): void;
/**
 * Sets show animation delay, takes value in milliseconds, if no value is provided, it will set default value which is `300` ms on iOS and `0` ms on Android
 */
declare function setShowAnimationDelay(delay?: number): void;
/**
 * Sets show animation duration, takes value in milliseconds, if no value is provided, it will set default value which is `660` ms
 */
declare function setShowAnimationDuration(duration?: number): void;
/**
 * Sets `android:windowSoftInputMode` attribute to `adjustNothing`
 *
 * @platform `Android`
 */
declare function setAdjustNothing(): void;
/**
 * Sets `android:windowSoftInputMode` attribute to `adjustPan`
 *
 * @platform `Android`
 */
declare function setAdjustPan(): void;
/**
 * Sets `android:windowSoftInputMode` attribute to `adjustResize`
 *
 * @platform `Android`
 */
declare function setAdjustResize(): void;
/**
 * Sets `android:windowSoftInputMode` attribute to `adjustUnspecified`
 *
 * @platform `Android`
 */
declare function setAdjustUnspecified(): void;
/**
 * Sets `android:windowSoftInputMode` attribute to default value that is set in manifest
 *
 * @platform `Android`
 */
declare function setDefaultAppSoftInputMode(): void;
export declare const AvoidSoftInput: {
    onSoftInputAppliedOffsetChange: typeof onSoftInputAppliedOffsetChange;
    onSoftInputHeightChange: typeof onSoftInputHeightChange;
    onSoftInputHidden: typeof onSoftInputHidden;
    onSoftInputShown: typeof onSoftInputShown;
    setAdjustNothing: typeof setAdjustNothing;
    setAdjustPan: typeof setAdjustPan;
    setAdjustResize: typeof setAdjustResize;
    setAdjustUnspecified: typeof setAdjustUnspecified;
    setAvoidOffset: typeof setAvoidOffset;
    setDefaultAppSoftInputMode: typeof setDefaultAppSoftInputMode;
    setEasing: typeof setEasing;
    setEnabled: typeof setEnabled;
    setHideAnimationDelay: typeof setHideAnimationDelay;
    setHideAnimationDuration: typeof setHideAnimationDuration;
    setShouldMimicIOSBehavior: typeof setShouldMimicIOSBehavior;
    setShowAnimationDelay: typeof setShowAnimationDelay;
    setShowAnimationDuration: typeof setShowAnimationDuration;
};
export {};
//# sourceMappingURL=AvoidSoftInput.d.ts.map