import type { AggregatedLicensesMapping } from '../types';
import type { LicenseAnalysisResult } from '../types/LicenseAnalysisResult';
import { LicenseCategory } from './LicenseCategory';
/**
 * Categorizes a license based on its copyleft characteristics.
 * @param licenseType the license type
 * @returns the license category
 */
export declare function categorizeLicense(licenseType?: string): LicenseCategory;
/**
 * Analyzes license data and returns comprehensive statistics.
 * @param report the licenses report data
 * @returns the license analysis result
 */
export declare function analyzeLicenses(report: AggregatedLicensesMapping): LicenseAnalysisResult;
