package dev.mateusznowak.demodulate

import android.content.Intent
import android.media.audiofx.AudioEffect
import com.facebook.react.ReactPackage
import com.facebook.react.bridge.NativeModule
import com.facebook.react.bridge.ReactApplicationContext
import com.facebook.react.bridge.ReactContextBaseJavaModule
import com.facebook.react.bridge.ReactMethod
import com.facebook.react.uimanager.ViewManager

class AudioEffectsModule(reactContext: ReactApplicationContext) :
    ReactContextBaseJavaModule(reactContext) {

    override fun getName(): String {
        return "AudioEffects"
    }

    @ReactMethod
    fun openAudioEffects() {
        val activity = reactApplicationContext.currentActivity ?: return

        val intent = Intent(AudioEffect.ACTION_DISPLAY_AUDIO_EFFECT_CONTROL_PANEL)
        intent.putExtra(AudioEffect.EXTRA_AUDIO_SESSION, 0)
        intent.putExtra(AudioEffect.EXTRA_PACKAGE_NAME, activity.packageName)

        activity.startActivity(intent)
    }
}

class AudioEffectsPackage : ReactPackage {
    override fun createNativeModules(reactContext: ReactApplicationContext): List<NativeModule> {
        return listOf(AudioEffectsModule(reactContext))
    }

    override fun createViewManagers(reactContext: ReactApplicationContext): List<ViewManager<*, *>> {
        return emptyList()
    }
}
