import i18next from "../i18n";
import { BookmarksScene } from "./BookmarksScene";
import { HistoryScene } from "./HistoryScene";
import { SearchScene } from "./SearchScene";
import { SettingsScene } from "./SettingsScene";

const t = i18next.t;

export const sceneMap = {
  search: SearchScene,
  bookmarks: BookmarksScene,
  history: HistoryScene,
  settings: SettingsScene,
};

export const sceneRoutes = [
  { key: "search", title: t("menu_search"), focusedIcon: "Search" },
  { key: "bookmarks", title: t("menu_bookmarks"), focusedIcon: "Star" },
  { key: "history", title: t("menu_history"), focusedIcon: "History" },
  { key: "settings", title: t("menu_settings"), focusedIcon: "Settings" },
];
