/**
 * @license lucide-react-native v0.541.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */

import { forwardRef, createElement } from 'react';
import * as NativeSvg from 'react-native-svg';
import defaultAttributes, { childDefaultAttributes } from './defaultAttributes.js';

const Icon = forwardRef(
  ({
    color = "currentColor",
    size = 24,
    strokeWidth = 2,
    absoluteStrokeWidth,
    children,
    iconNode,
    ...rest
  }, ref) => {
    const customAttrs = {
      stroke: color,
      strokeWidth: absoluteStrokeWidth ? Number(strokeWidth) * 24 / Number(size) : strokeWidth,
      ...rest
    };
    return createElement(
      NativeSvg.Svg,
      {
        ref,
        ...defaultAttributes,
        width: size,
        height: size,
        ...customAttrs
      },
      [
        ...iconNode.map(([tag, attrs]) => {
          const upperCasedTag = tag.charAt(0).toUpperCase() + tag.slice(1);
          return createElement(
            NativeSvg[upperCasedTag],
            { ...childDefaultAttributes, ...customAttrs, ...attrs }
          );
        }),
        ...(Array.isArray(children) ? children : [children]) || []
      ]
    );
  }
);

export { Icon as default };
//# sourceMappingURL=Icon.js.map
