"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getGraphStateInfo = getGraphStateInfo;
exports.getLicenseCategoryDescription = getLicenseCategoryDescription;
const LicenseCategory_1 = require("./LicenseCategory");
function getGraphStateInfo(stats) {
    const hasAnyUnknown = stats[LicenseCategory_1.LicenseCategory.UNKNOWN] > 0;
    const hasAnyWeakCopyleft = stats[LicenseCategory_1.LicenseCategory.WEAK_COPYLEFT] > 0;
    const hasAnyStrongCopyleft = stats[LicenseCategory_1.LicenseCategory.STRONG_COPYLEFT] > 0;
    const hasAllPermissive = !hasAnyUnknown && !hasAnyStrongCopyleft && !hasAnyWeakCopyleft;
    let description = '';
    if (hasAnyWeakCopyleft || hasAnyStrongCopyleft) {
        description = `Some detected licenses are ${[
            hasAnyWeakCopyleft ? 'weak' : null,
            hasAnyStrongCopyleft ? 'strong' : null,
        ]
            .filter((x) => !!x)
            .map((x) => `${x}-`)
            .join(' and ')}copyleft`;
    }
    else {
        description = `${hasAllPermissive ? 'All' : stats[LicenseCategory_1.LicenseCategory.PERMISSIVE]} detected licenses are permissive`;
    }
    if (hasAnyUnknown) {
        description += `, ${hasAllPermissive ? 'but ' : ''}${stats[LicenseCategory_1.LicenseCategory.UNKNOWN]} are unknown.`;
    }
    return {
        description,
        categoriesPresence: {
            hasAnyUnknown,
            hasAnyWeakCopyleft,
            hasAnyStrongCopyleft,
            hasAllPermissive,
        },
    };
}
/**
 * Gets a human-readable description of the license category
 * @param category the license category
 * @returns the human-readable description of the license category
 */
function getLicenseCategoryDescription(category) {
    switch (category) {
        case LicenseCategory_1.LicenseCategory.STRONG_COPYLEFT:
            return 'Strong Copyleft';
        case LicenseCategory_1.LicenseCategory.WEAK_COPYLEFT:
            return 'Weak Copyleft';
        case LicenseCategory_1.LicenseCategory.PERMISSIVE:
            return 'Permissive';
        case LicenseCategory_1.LicenseCategory.UNKNOWN:
            return 'Unknown';
    }
}
