import { LicenseCategory } from './LicenseCategory';
export declare function getGraphStateInfo(stats: Record<LicenseCategory, number>): {
    description: string;
    categoriesPresence: {
        hasAnyUnknown: boolean;
        hasAnyWeakCopyleft: boolean;
        hasAnyStrongCopyleft: boolean;
        hasAllPermissive: boolean;
    };
};
/**
 * Gets a human-readable description of the license category
 * @param category the license category
 * @returns the human-readable description of the license category
 */
export declare function getLicenseCategoryDescription(category: LicenseCategory): string;
