import { useState } from "react";
import { ScrollView, useColorScheme } from "react-native";
import { useSoftInputHeightChanged } from "react-native-avoid-softinput";
import { Button, Dialog } from "react-native-paper";

function getBackdropColor(colorScheme) {
  return colorScheme === "dark" ? "#000000aa" : "#00000077";
}

export function Modal({ title, children, buttonPositive, buttonNegative, onDismiss }) {
  const colorScheme = useColorScheme();

  const [keyboardHeight, setKeyboardHeight] = useState(0);

  useSoftInputHeightChanged(({ softInputHeight }) => {
    setKeyboardHeight(softInputHeight);
  });

  return (
    <Dialog
      onDismiss={onDismiss}
      style={{ marginBottom: 80 + keyboardHeight, marginHorizontal: 16, marginTop: 80 }}
      theme={{ colors: { backdrop: getBackdropColor(colorScheme) } }}
      visible
    >
      {title && <Dialog.Title>{title}</Dialog.Title>}
      <Dialog.ScrollArea style={{ borderBottomWidth: 0, borderTopWidth: 0 }}>
        <ScrollView>{children}</ScrollView>
      </Dialog.ScrollArea>
      <Dialog.Actions>
        {buttonNegative && <Button onPress={buttonNegative.onPress}>{buttonNegative.label}</Button>}
        {buttonPositive && <Button onPress={buttonPositive.onPress}>{buttonPositive.label}</Button>}
      </Dialog.Actions>
    </Dialog>
  );
}
