import { create } from "zustand";

import { API_SERVERS } from "./const";

export const useStore = create(() => ({
  ready: false,

  player: {
    id: null,
    name: null,
    url: null,
    title: null,
    artist: null,
    artwork: null,
    status: "none",
    playing: false,
    error: null,
    hls: false,
    valid: true,
  },

  bookmarks: [],
  history: [],

  customCountry: null,
  stats: null,

  serverList: [...API_SERVERS],
  serverCurrent: null,

  bookmarksNextUpdate: +new Date(),
  historyNextUpdate: +new Date(),
  serversNextUpdate: +new Date(),
}));
