import { OctagonAlert, Plus } from "lucide-react-native";
import { useTranslation } from "react-i18next";
import { View } from "react-native";
import { Divider, List, useTheme } from "react-native-paper";

import { addBookmark } from "../api/LocalStorage";
import { StationList } from "../components";
import { MAX_ENTRIES } from "../const";
import { useStore } from "../store";
import { styles } from "../styles";

function BookmarksSceneSuggest({ bookmarks }) {
  const theme = useTheme();
  const { t } = useTranslation();

  const player = useStore((state) => state.player);

  const isBookmark = bookmarks.map((b) => b.id).includes(player.id);

  if (isBookmark || !player.id) {
    return null;
  }

  if (bookmarks.length >= MAX_ENTRIES) {
    return (
      <>
        <List.Item
          left={() => (
            <OctagonAlert size={24} style={{ color: theme.colors.primary, margin: 12 }} />
          )}
          style={{ margin: 0, paddingHorizontal: 16 }}
          title={t("bookmarks_full")}
          titleNumberOfLines={2}
        />
        <Divider />
      </>
    );
  }

  return (
    <>
      <List.Item
        left={() => <Plus size={24} style={{ color: theme.colors.primary, margin: 12 }} />}
        onPress={() => addBookmark(player)}
        style={{ margin: 0, paddingHorizontal: 16 }}
        title={t("bookmarks_suggest", { name: player.name })}
      />
      <Divider />
    </>
  );
}

export function BookmarksScene() {
  const { t } = useTranslation();

  const bookmarks = useStore((state) => state.bookmarks);

  return (
    <View style={{ flexGrow: 1, flexShrink: 1 }}>
      <BookmarksSceneSuggest bookmarks={bookmarks} />
      <StationList
        data={bookmarks}
        emptyIcon="Star"
        emptyText={t("bookmarks_empty")}
        role="bookmarks"
        style={{ marginBottom: styles.scene.marginBottom }}
      />
    </View>
  );
}
