import { useTranslation } from "react-i18next";
import { Text } from "react-native-paper";

import { setStats } from "../api/LocalStorage";
import { Modal } from "../components";

export function StatsModal({ hide }) {
  const { t } = useTranslation();

  return (
    <Modal
      buttonNegative={{ label: t("dialog_no"), onPress: () => setStats(false).then(hide) }}
      buttonPositive={{ label: t("dialog_yes"), onPress: () => setStats(true).then(hide) }}
      onDismiss={hide}
      title={t("settings_send_usage_stats")}
    >
      <Text dataDetectorType="link">{t("settings_send_usage_stats_description")}</Text>
    </Modal>
  );
}
