import DeviceCountry, { TYPE_TELEPHONY } from "react-native-device-country";

import { useStore } from "../store";

export async function getCountryCode() {
  const customCountry = useStore.getState().customCountry;
  if (customCountry) {
    return customCountry;
  }

  const data = await DeviceCountry.getCountryCode(TYPE_TELEPHONY);
  if (data?.code) {
    return data.code;
  }

  return "us";
}
