// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Russian (`ru`).
class AppLocalizationsRu extends AppLocalizations {
  AppLocalizationsRu([String locale = 'ru']) : super(locale);

  @override
  String get dashboard => 'Панель';

  @override
  String get translate => 'Перевести';

  @override
  String get calendar => 'Календарь';

  @override
  String get resources => 'Ресурсы';

  @override
  String get users => 'Пользователи';

  @override
  String get user => 'Пользователь';

  @override
  String get sources => 'Источники';

  @override
  String get settings => 'Настройки';

  @override
  String get create => 'Создать';

  @override
  String get information => 'Информация';

  @override
  String get source => 'Источник';

  @override
  String get license => 'Лицензия';

  @override
  String get thirdPartyLicenses => 'Сторонние лицензии';

  @override
  String get documentation => 'Документация';

  @override
  String get privacyPolicy => 'Политика конфиденциальности';

  @override
  String get imprint => 'Отпечаток';

  @override
  String get releaseNotes => 'Примечания к выпуску';

  @override
  String get changelog => 'Список изменений';

  @override
  String get legal => 'Юридическая информация';

  @override
  String get personalization => 'Персонализация';

  @override
  String get design => 'Дизайн';

  @override
  String get language => 'Язык';

  @override
  String get theme => 'Тема';

  @override
  String get classic => 'Классика';

  @override
  String get systemDefault => 'Система по умолчанию';

  @override
  String get light => 'Светлая';

  @override
  String get dark => 'Тёмная';

  @override
  String get createResource => 'Создать ресурс';

  @override
  String get cancel => 'Отмена';

  @override
  String get name => 'Наименование';

  @override
  String get description => 'Описание';

  @override
  String get start => 'Начать';

  @override
  String get next => 'Следующий';

  @override
  String get skip => 'Пропустить';

  @override
  String get back => 'Назад';

  @override
  String get today => 'Сегодня';

  @override
  String get groups => 'Группы';

  @override
  String get createGroup => 'Создать группу';

  @override
  String get editGroup => 'Изменить группу';

  @override
  String get list => 'Список';

  @override
  String get day => 'День';

  @override
  String get week => 'Неделя';

  @override
  String get month => 'Месяц';

  @override
  String get version => 'Версии';

  @override
  String get intro => 'Введение';

  @override
  String get caldavDescription =>
      'Интерфейс CalDAV позволяет получить доступ к данным с любого сервера CalDAV. Он имеет ограниченную поддержку и поддерживается только основные функции. Вы можете использовать его для синхронизации ваших данных с другими устройствами или службами.';

  @override
  String get webdavDescription =>
      'Интерфейс WebDAV позволяет получить доступ к вашим данным с любого сервера WebDAV. Файлы и каталоги для хранения данных. Вы можете использовать их для синхронизации данных с другими устройствами или службами.';

  @override
  String get server => 'Сервер';

  @override
  String get serverDescription =>
      'Синхронизируйте ваши данные с родным сервером Linwood Flow. Это рекомендуется для пользователей, которые хотят самостоятельно размещать свои данные.';

  @override
  String get googleDescription =>
      'Синхронизация данных с Google. Рекомендуется пользователям, которые хотят использовать их аккаунт Google для доступа к своим данным. Не все функции доступны с этой опцией.';

  @override
  String get microsoftDescription =>
      'Синхронизируйте ваши данные с Microsoft. Рекомендуется пользователям, которые хотят использовать их учетную запись Майкрософт для доступа к своим данным. Не все функции доступны с этой опцией.';

  @override
  String get addSource => 'Добавить источник';

  @override
  String get local => 'Локальный';

  @override
  String get close => 'Закрыть';

  @override
  String get unknown => 'Неизвестен';

  @override
  String get loading => 'Загрузка';

  @override
  String get export => 'Экспорт';

  @override
  String get createEvent => 'Создать событие';

  @override
  String get save => 'Сохранить';

  @override
  String get allSources => 'Все источники';

  @override
  String get editEvent => 'Редактировать событие';

  @override
  String get end => 'Конец';

  @override
  String get location => 'Местоположение';

  @override
  String get status => 'Статус';

  @override
  String get confirmed => 'Подтверждено';

  @override
  String get draft => 'Черновик';

  @override
  String get cancelled => 'Отменено';

  @override
  String get general => 'Общие положения';

  @override
  String get notes => 'Примечания';

  @override
  String get createNote => 'Создать заметку';

  @override
  String get editNote => 'Изменить заметку';

  @override
  String get indicatorEmpty => 'Элементов не найдено';

  @override
  String get indicatorEmptyDescription => 'Список в настоящее время пуст.';

  @override
  String get indicatorLoading => 'Загрузка';

  @override
  String get indicatorError => 'Произошла ошибка';

  @override
  String get indicatorErrorDescription =>
      'Произошла ошибка при загрузке данных.';

  @override
  String get tryAgain => 'Попробовать еще раз';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event на $date в $time в $location ($status)';
  }

  @override
  String get filter => 'Фильтр';

  @override
  String get done => 'Готово';

  @override
  String get inProgress => 'В процессе';

  @override
  String get note => 'Примечание';

  @override
  String get delete => 'Удалить';

  @override
  String get edit => 'Редактирование';

  @override
  String deleteGroup(String name) {
    return 'Удалить группу $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Вы уверены, что хотите удалить группу $name?';
  }

  @override
  String groupName(String name) {
    return 'Группа $name';
  }

  @override
  String get noData => 'Нет данных для отображения.';

  @override
  String get noEvents => 'Нет событий для отображения.';

  @override
  String get group => 'Группа';

  @override
  String get search => 'Искать';

  @override
  String get events => 'События';

  @override
  String get past => 'Прошлые';

  @override
  String get decentralized => 'Децентрализовано';

  @override
  String get decentralizedDescription =>
      'Децентрализованный интерфейс позволяет получить доступ к вашим данным с любого децентрализованного сервера. Вы можете использовать его для синхронизации данных с другими устройствами или службами.';

  @override
  String get importFile => 'Импорт файла';

  @override
  String get importFileDescription =>
      'Импорт файла с вашего устройства. Вы можете импортировать файл базы данных из другого экземпляра Linwood Flow или из обычного файла календаря.';

  @override
  String get icalDescription =>
      'Интерфейс iCal позволяет получить доступ к вашим данным с любого сервера iCal. Он может только читать данные и не поддерживает запись. Вы можете использовать его для синхронизации данных с другими устройствами или службами, которые не поддерживают CalDAV.';

  @override
  String get resource => 'Ресурс';

  @override
  String get editResource => 'Изменить ресурс';

  @override
  String deleteResource(String name) {
    return 'Удалить ресурс $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Вы уверены, что хотите удалить ресурс $name?';
  }

  @override
  String get priority => 'Приоритет';

  @override
  String get assignEvent => 'Назначить событие';

  @override
  String get noEvent => 'Нет события';

  @override
  String get parentGroup => 'Родительская группа';

  @override
  String deleteUser(String name) {
    return 'Удалить пользователя $name';
  }

  @override
  String get createUser => 'Создать пользователя';

  @override
  String get editUser => 'Изменить пользователя';

  @override
  String deleteUserDescription(String name) {
    return 'Вы уверены, что хотите удалить пользователя $name?';
  }

  @override
  String get pending => 'В ожидании';

  @override
  String get removeEvent => 'Удалить событие';

  @override
  String get event => 'Событие';

  @override
  String get nativeTitleBar => 'Родной заголовок';

  @override
  String get blocked => 'Заблокирован';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count события',
      one: '1 событие',
      zero: 'Нет событий',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Импорт';

  @override
  String get confirmImport => 'Вы уверены, что хотите импортировать его?';

  @override
  String get welcome => 'Добро пожаловать';

  @override
  String get url => 'URL';

  @override
  String get username => 'Имя пользователя';

  @override
  String get password => 'Пароль';

  @override
  String get connect => 'Подключиться';

  @override
  String get data => 'Данные';

  @override
  String get syncing => 'Синхронизация';

  @override
  String get synced => 'Синхронизировано';

  @override
  String get error => 'Ошибка';

  @override
  String get always => 'Всегда';

  @override
  String get noMobile => 'Нет мобильных устройств';

  @override
  String get manual => 'Ручной';

  @override
  String get syncMode => 'Режим синхронизации';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Назначение';

  @override
  String get moment => 'Момент';

  @override
  String get time => 'Время';

  @override
  String deleteEvent(String name) {
    return 'Удалить событие $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Вы уверены, что хотите удалить событие $name?';
  }

  @override
  String get createAppointment => 'Создать прием';

  @override
  String get editAppointment => 'Редактировать прием';

  @override
  String get createMoment => 'Создать момент';

  @override
  String get editMoment => 'Изменить момент';

  @override
  String get convertToNote => 'Преобразовать в заметку';

  @override
  String get convertToTodo => 'Преобразовать в задачу';

  @override
  String get open => 'Открыть';

  @override
  String get limited => 'Ограниченный';

  @override
  String get notSet => 'Не задано';

  @override
  String get createPending => 'Создать ожидание';

  @override
  String get editPending => 'Редактировать ожидание';

  @override
  String get convertTo => 'Преобразовать в';

  @override
  String get comingSoon => 'Скоро появится';

  @override
  String get notSupported => 'Не поддерживается';

  @override
  String get databaseVersion => 'Версия базы данных';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Восстановить';

  @override
  String get markdownIsSupported => 'Поддержка Markdown';

  @override
  String get createLabel => 'Создать метку';

  @override
  String get editLabel => 'Изменить метку';

  @override
  String deleteLabel(String name) {
    return 'Удалить метку $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Вы уверены, что хотите удалить метку $name?';
  }

  @override
  String get label => 'Метка';

  @override
  String get startOfWeek => 'Начало недели';

  @override
  String headlineNumber(int number) {
    return 'Заголовок $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Зачёркнутый';

  @override
  String get code => 'Код';

  @override
  String get link => 'Ссылка';

  @override
  String get codeBlock => 'Блок кода';

  @override
  String get quote => 'Цитата';

  @override
  String get numberedList => 'Нумерованный список';

  @override
  String get density => 'Плотность';

  @override
  String get compact => 'Компактный';

  @override
  String get comfortable => 'Удобный';

  @override
  String get standard => 'Стандартный';

  @override
  String get highContrast => 'Высокий контраст';

  @override
  String get labels => 'Метки';

  @override
  String get systemLocale => 'Системный язык';

  @override
  String get notebooks => 'Ноутбуки';

  @override
  String get createNotebook => 'Создать блокнот';

  @override
  String get editNotebook => 'Редактировать блокнот';

  @override
  String get update => 'Обновление';

  @override
  String get currentVersion => 'Текущая версия';

  @override
  String get checkForUpdates => 'Проверить обновления';

  @override
  String get checkForUpdatesWarning =>
      'Для получения информации с помощью проверки обновлений будет подключен к сайту Flow.';

  @override
  String get usingLatestStable => 'Вы используете последнюю стабильную версию';

  @override
  String get usingLatestNightly => 'Вы используете последнюю ночную версию';

  @override
  String get updateNow => 'Обновить сейчас';

  @override
  String get stable => 'Конюшня';

  @override
  String get nightly => 'Ночной';

  @override
  String get updateAvailable => 'Доступно обновление';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count предметы',
      one: '1 предмет',
      zero: 'Нет предметов',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Системная тема';

  @override
  String get desktop => 'Рабочий стол';

  @override
  String get restoreSettingsFromFile => 'Восстановить настройки из файла';

  @override
  String get exportSettingsToFile => 'Экспорт настроек в файл';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Включено';

  @override
  String get countdown => 'Обратный отсчёт';

  @override
  String get unlink => 'Отвязать';

  @override
  String get noAlarms => 'Нет будильников для отображения.';

  @override
  String get allDay => 'Весь день';
}
