// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Romanian Moldavian Moldovan (`ro`).
class AppLocalizationsRo extends AppLocalizations {
  AppLocalizationsRo([String locale = 'ro']) : super(locale);

  @override
  String get dashboard => 'Panou';

  @override
  String get translate => 'Tradu';

  @override
  String get calendar => 'Calendar';

  @override
  String get resources => 'Resurse';

  @override
  String get users => 'Utilizatori';

  @override
  String get user => 'Utilizator';

  @override
  String get sources => 'Surse';

  @override
  String get settings => 'Setări';

  @override
  String get create => 'Crează';

  @override
  String get information => 'Informare';

  @override
  String get source => 'Sursa';

  @override
  String get license => 'Licenta';

  @override
  String get thirdPartyLicenses => 'Licențe terțe';

  @override
  String get documentation => 'Documentație';

  @override
  String get privacyPolicy => 'Politica de confidenţialitate';

  @override
  String get imprint => 'Amprentă';

  @override
  String get releaseNotes => 'Note de lansare';

  @override
  String get changelog => 'Jurnal modificări';

  @override
  String get legal => 'Juridic';

  @override
  String get personalization => 'Personalizare';

  @override
  String get design => 'Proiectare';

  @override
  String get language => 'Limba';

  @override
  String get theme => 'Tema';

  @override
  String get classic => 'Clasic';

  @override
  String get systemDefault => 'Implicit sistem';

  @override
  String get light => 'Lumină';

  @override
  String get dark => 'Întunecat';

  @override
  String get createResource => 'Creează o resursă';

  @override
  String get cancel => 'Anulează';

  @override
  String get name => 'Nume';

  @override
  String get description => 'Descriere';

  @override
  String get start => 'Pornire';

  @override
  String get next => 'Următoarea';

  @override
  String get skip => 'Omitere';

  @override
  String get back => 'Înapoi';

  @override
  String get today => 'Astăzi';

  @override
  String get groups => 'Grupuri';

  @override
  String get createGroup => 'Creare grup';

  @override
  String get editGroup => 'Editează grup';

  @override
  String get list => 'Listă';

  @override
  String get day => 'Zi';

  @override
  String get week => 'Saptamana';

  @override
  String get month => 'Lună';

  @override
  String get version => 'Versiune';

  @override
  String get intro => 'Introducere';

  @override
  String get caldavDescription =>
      'Interfaţa CalDAV vă permite să accesaţi datele de pe orice server CalDAV. Are suport limitat și sunt acceptate numai funcțiile de bază. Îl puteți folosi pentru a sincroniza datele cu alte dispozitive sau servicii.';

  @override
  String get webdavDescription =>
      'Interfaţa WebDAV vă permite să accesaţi datele de pe orice server WebDAV. Fişiere şi directoare pentru a stoca date. Îl puteţi folosi pentru a sincroniza datele cu alte dispozitive sau servicii.';

  @override
  String get server => 'Server';

  @override
  String get serverDescription =>
      'Sincronizați-vă datele cu un server nativ Linwood Flow server. Acest lucru este recomandat utilizatorilor care doresc să își găzduiască datele.';

  @override
  String get googleDescription =>
      'Sincronizați-vă datele cu Google. Acest lucru este recomandat pentru utilizatorii care doresc să utilizeze contul lor Google pentru a le accesa datele. Nu sunt disponibile toate caracteristicile cu această opțiune.';

  @override
  String get microsoftDescription =>
      'Sincronizează-ți datele cu Microsoft. Acest lucru este recomandat utilizatorilor care doresc să își folosească contul Microsoft pentru a-și accesa datele. Nu sunt disponibile toate caracteristicile cu această opțiune.';

  @override
  String get addSource => 'Adaugă sursă';

  @override
  String get local => 'Local';

  @override
  String get close => 'Inchide';

  @override
  String get unknown => 'Necunoscut';

  @override
  String get loading => 'Încărcare';

  @override
  String get export => 'Exportă';

  @override
  String get createEvent => 'Crează eveniment';

  @override
  String get save => 'Salvează';

  @override
  String get allSources => 'Toate sursele';

  @override
  String get editEvent => 'Editare eveniment';

  @override
  String get end => 'Sfârșit';

  @override
  String get location => 'Locaţie';

  @override
  String get status => 'Status';

  @override
  String get confirmed => 'Confirmare';

  @override
  String get draft => 'Schiță';

  @override
  String get cancelled => 'Anulat';

  @override
  String get general => 'Generalități';

  @override
  String get notes => 'Note';

  @override
  String get createNote => 'Creaţi o notă';

  @override
  String get editNote => 'Editare notă';

  @override
  String get indicatorEmpty => 'Niciun element găsit';

  @override
  String get indicatorEmptyDescription => 'Lista este în prezent goală.';

  @override
  String get indicatorLoading => 'Încărcare';

  @override
  String get indicatorError => 'A aparut o eroare';

  @override
  String get indicatorErrorDescription =>
      'A apărut o eroare la încărcarea datelor.';

  @override
  String get tryAgain => 'Încercați din nou';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event pe $date la $time în $location ($status)';
  }

  @override
  String get filter => 'Filtrare';

  @override
  String get done => 'Terminat';

  @override
  String get inProgress => 'În curs';

  @override
  String get note => 'Notă';

  @override
  String get delete => 'Ștergere';

  @override
  String get edit => 'Editare';

  @override
  String deleteGroup(String name) {
    return 'Șterge grupul $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Ești sigur că vrei să ștergi grupul $name?';
  }

  @override
  String groupName(String name) {
    return 'Grup $name';
  }

  @override
  String get noData => 'Nu există date de afișat.';

  @override
  String get noEvents => 'Nu sunt evenimente de afișat.';

  @override
  String get group => 'Grup';

  @override
  String get search => 'Caută';

  @override
  String get events => 'Evenimente';

  @override
  String get past => 'Trecute';

  @override
  String get decentralized => 'Descentralizat';

  @override
  String get decentralizedDescription =>
      'Interfața descentralizată îți permite să accesezi datele tale de la orice server descentralizat. Îl puteți folosi pentru a vă sincroniza datele cu alte dispozitive sau servicii.';

  @override
  String get importFile => 'Importă fișier';

  @override
  String get importFileDescription =>
      'Importă un fișier de pe dispozitivul tău. Poți importa un fișier de bază de date dintr-o altă instanță de flori Linwood sau un fișier calendar obișnuit.';

  @override
  String get icalDescription =>
      'Interfața iCal vă permite să accesați datele de pe orice server iCal. Aceasta poate doar citi datele și nu suportă scrierea. Îl puteţi folosi pentru a vă sincroniza datele cu alte dispozitive sau servicii care nu acceptă CalDAV.';

  @override
  String get resource => 'Resursă';

  @override
  String get editResource => 'Editare resursă';

  @override
  String deleteResource(String name) {
    return 'Ștergere resursă $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Sigur doriți să ștergeți resursa $name?';
  }

  @override
  String get priority => 'Prioritate';

  @override
  String get assignEvent => 'Atribuire eveniment';

  @override
  String get noEvent => 'Niciun eveniment';

  @override
  String get parentGroup => 'Grup părinte';

  @override
  String deleteUser(String name) {
    return 'Ștergere utilizator $name';
  }

  @override
  String get createUser => 'Creare utilizator';

  @override
  String get editUser => 'Editare utilizator';

  @override
  String deleteUserDescription(String name) {
    return 'Ești sigur că vrei să ștergi utilizatorul $name?';
  }

  @override
  String get pending => 'In asteptare';

  @override
  String get removeEvent => 'Elimină eveniment';

  @override
  String get event => 'Eveniment';

  @override
  String get nativeTitleBar => 'Bară titlu nativ';

  @override
  String get blocked => 'Blocat';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count evenimente',
      one: '1 eveniment',
      zero: 'Niciun eveniment',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importă';

  @override
  String get confirmImport => 'Sunteţi sigur că doriţi să importați?';

  @override
  String get welcome => 'Bun venit';

  @override
  String get url => 'URL';

  @override
  String get username => 'Nume';

  @override
  String get password => 'Parolă';

  @override
  String get connect => 'Conectează-te';

  @override
  String get data => 'Date';

  @override
  String get syncing => 'Sincronizare';

  @override
  String get synced => 'Sincronizat';

  @override
  String get error => 'Eroare';

  @override
  String get always => 'Întotdeauna';

  @override
  String get noMobile => 'Niciun mobil';

  @override
  String get manual => 'Manual';

  @override
  String get syncMode => 'Mod sincronizare';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Numire';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Timp';

  @override
  String deleteEvent(String name) {
    return 'Șterge evenimentul $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Ești sigur că vrei să ștergi evenimentul $name?';
  }

  @override
  String get createAppointment => 'Creaza intalnire';

  @override
  String get editAppointment => 'Editare programare';

  @override
  String get createMoment => 'Crează moment';

  @override
  String get editMoment => 'Editare moment';

  @override
  String get convertToNote => 'Convertește la notă';

  @override
  String get convertToTodo => 'Convertește la todo';

  @override
  String get open => 'Deschideți';

  @override
  String get limited => 'Limitat';

  @override
  String get notSet => 'Nu este setat';

  @override
  String get createPending => 'Creare în așteptare';

  @override
  String get editPending => 'Editare în așteptare';

  @override
  String get convertTo => 'Convertește în';

  @override
  String get comingSoon => 'În curând';

  @override
  String get notSupported => 'Nu este suportat';

  @override
  String get databaseVersion => 'Versiunea bazei de date';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Restaurează';

  @override
  String get markdownIsSupported => 'Markdown este suportat';

  @override
  String get createLabel => 'Creare etichetă';

  @override
  String get editLabel => 'Editare etichetă';

  @override
  String deleteLabel(String name) {
    return 'Șterge eticheta $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Sigur doriți să ștergeți eticheta $name?';
  }

  @override
  String get label => 'Etichetă';

  @override
  String get startOfWeek => 'Începutul săptămânii';

  @override
  String headlineNumber(int number) {
    return '$number Titlu';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Tăiat';

  @override
  String get code => 'Cod';

  @override
  String get link => 'Link-ul';

  @override
  String get codeBlock => 'Bloc cod';

  @override
  String get quote => 'Ofertă';

  @override
  String get numberedList => 'Listă numerotată';

  @override
  String get density => 'Densitate';

  @override
  String get compact => 'Compact';

  @override
  String get comfortable => 'Comfortable';

  @override
  String get standard => 'Standard';

  @override
  String get highContrast => 'Contrast mare';

  @override
  String get labels => 'Etichete';

  @override
  String get systemLocale => 'Localizare sistem';

  @override
  String get notebooks => 'Notebook-uri';

  @override
  String get createNotebook => 'Creare caiet';

  @override
  String get editNotebook => 'Editare caiet';

  @override
  String get update => 'Actualizare';

  @override
  String get currentVersion => 'Versiunea curentă';

  @override
  String get checkForUpdates => 'Verifică pentru actualizări';

  @override
  String get checkForUpdatesWarning =>
      'Verificarea actualizărilor se va conecta la site-ul Flow pentru a obţine informaţii.';

  @override
  String get usingLatestStable => 'Folosești cea mai recentă versiune stabilă';

  @override
  String get usingLatestNightly => 'Folosești ultima versiune nocturnă';

  @override
  String get updateNow => 'Actualizează acum';

  @override
  String get stable => 'Stabil';

  @override
  String get nightly => 'Noptez';

  @override
  String get updateAvailable => 'Actualizare disponibilă';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count articole',
      one: '1 articol',
      zero: 'Nu există articole',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Tema sistemului';

  @override
  String get desktop => 'Birou';

  @override
  String get restoreSettingsFromFile => 'Restabilește setările din fișier';

  @override
  String get exportSettingsToFile => 'Exportă setările în fișier';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Activat';

  @override
  String get countdown => 'Numărătoare inversă';

  @override
  String get unlink => 'Deconectare';

  @override
  String get noAlarms => 'Nu există alarme de afișat.';

  @override
  String get allDay => 'Toată ziua';
}
