// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Portuguese (`pt`).
class AppLocalizationsPt extends AppLocalizations {
  AppLocalizationsPt([String locale = 'pt']) : super(locale);

  @override
  String get dashboard => 'Painel';

  @override
  String get translate => 'Traduzir';

  @override
  String get calendar => 'calendário';

  @override
  String get resources => 'Recursos';

  @override
  String get users => 'Utilizadores';

  @override
  String get user => 'Usuário';

  @override
  String get sources => 'Fontes';

  @override
  String get settings => 'Confirgurações';

  @override
  String get create => 'Crio';

  @override
  String get information => 'Informacao';

  @override
  String get source => 'fonte';

  @override
  String get license => 'Tipo:';

  @override
  String get thirdPartyLicenses => 'Licenças de Terceiros';

  @override
  String get documentation => 'Documentação';

  @override
  String get privacyPolicy => 'Política de Privacidade';

  @override
  String get imprint => 'Imprimir';

  @override
  String get releaseNotes => 'Notas de Versão';

  @override
  String get changelog => 'Mudanças';

  @override
  String get legal => 'Informações';

  @override
  String get personalization => 'Personalização';

  @override
  String get design => 'Projetar';

  @override
  String get language => 'IDIOMA';

  @override
  String get theme => 'Tema';

  @override
  String get classic => 'Clássico';

  @override
  String get systemDefault => 'Padrão do Sistema';

  @override
  String get light => 'Fino';

  @override
  String get dark => 'Escuro';

  @override
  String get createResource => 'Criar recurso';

  @override
  String get cancel => 'cancelar';

  @override
  String get name => 'Nome:';

  @override
  String get description => 'Descrição:';

  @override
  String get start => 'Iniciar';

  @override
  String get next => 'Próximo';

  @override
  String get skip => 'Ignorar';

  @override
  String get back => 'Anterior';

  @override
  String get today => 'hoje';

  @override
  String get groups => 'grupos';

  @override
  String get createGroup => 'Criar grupo';

  @override
  String get editGroup => 'Editar grupo';

  @override
  String get list => 'Lista';

  @override
  String get day => 'dia';

  @override
  String get week => 'semana';

  @override
  String get month => 'Mês';

  @override
  String get version => 'Versão';

  @override
  String get intro => 'Introdução';

  @override
  String get caldavDescription =>
      'A interface CalDAV permite que você acesse seus dados de qualquer servidor CalDAV. Tem suporte limitado e apenas funções básicas são suportadas. Você pode usá-lo para sincronizar seus dados com outros dispositivos ou serviços.';

  @override
  String get webdavDescription =>
      'A interface WebDAV permite que você acesse seus dados de qualquer servidor WebDAV. Arquivos e diretórios para armazenar dados. Você pode usá-lo para sincronizar seus dados com outros dispositivos ou serviços.';

  @override
  String get server => 'Servidor';

  @override
  String get serverDescription =>
      'Sincronize seus dados com um servidor nativo do Linwood Flow. Isso é recomendado para usuários que querem auto-hospedar seus dados.';

  @override
  String get googleDescription =>
      'Sincronize seus dados com o Google. Isso é recomendado para usuários que querem usar sua conta do Google para acessar seus dados. Nem todos os recursos estão disponíveis com esta opção.';

  @override
  String get microsoftDescription =>
      'Sincronize seus dados com a Microsoft. Isso é recomendado para usuários que queiram usar sua conta da Microsoft para acessar seus dados. Nem todos os recursos estão disponíveis com esta opção.';

  @override
  String get addSource => 'Adicionar fonte';

  @override
  String get local => 'Localização';

  @override
  String get close => 'FECHAR';

  @override
  String get unknown => 'Desconhecido';

  @override
  String get loading => 'Carregando...';

  @override
  String get export => 'Exportação';

  @override
  String get createEvent => 'Criar evento';

  @override
  String get save => 'Guardar';

  @override
  String get allSources => 'Todas as fontes';

  @override
  String get editEvent => 'Editar evento';

  @override
  String get end => 'Término';

  @override
  String get location => 'Local:';

  @override
  String get status => 'SItuação';

  @override
  String get confirmed => 'Confirmado';

  @override
  String get draft => 'Rascunho';

  @override
  String get cancelled => 'Cancelado';

  @override
  String get general => 'Gerais';

  @override
  String get notes => 'Observações';

  @override
  String get createNote => 'Criar nota';

  @override
  String get editNote => 'Editar nota';

  @override
  String get indicatorEmpty => 'Nenhum item encontrado';

  @override
  String get indicatorEmptyDescription => 'A lista está atualmente vazia.';

  @override
  String get indicatorLoading => 'Carregando...';

  @override
  String get indicatorError => 'Ocorreu um erro';

  @override
  String get indicatorErrorDescription =>
      'Ocorreu um erro ao carregar os dados.';

  @override
  String get tryAgain => 'Tente novamente';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event em $date às $time em $location ($status)';
  }

  @override
  String get filter => 'filtro';

  @override
  String get done => 'Concluído';

  @override
  String get inProgress => 'Em Execução';

  @override
  String get note => 'Observação';

  @override
  String get delete => 'excluir';

  @override
  String get edit => 'Alterar';

  @override
  String deleteGroup(String name) {
    return 'Excluir grupo $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Tem certeza que deseja excluir o grupo $name?';
  }

  @override
  String groupName(String name) {
    return 'Grupo $name';
  }

  @override
  String get noData => 'Não há dados para exibir.';

  @override
  String get noEvents => 'Não há eventos para exibir.';

  @override
  String get group => 'grupo';

  @override
  String get search => 'Pesquisa';

  @override
  String get events => 'Eventos';

  @override
  String get past => 'Passado';

  @override
  String get decentralized => 'Descentralizado';

  @override
  String get decentralizedDescription =>
      'A interface descentralizada permite que você acesse seus dados a partir de qualquer servidor descentralizado. Você pode usá-lo para sincronizar seus dados com outros dispositivos ou serviços.';

  @override
  String get importFile => 'Importar arquivo';

  @override
  String get importFileDescription =>
      'Importar um arquivo do seu dispositivo. Você pode importar um arquivo de banco de dados de outra instância do Linwood Flow ou um arquivo de calendário comum.';

  @override
  String get icalDescription =>
      'A interface iCal permite que você acesse seus dados a partir de qualquer servidor iCal. Só pode ler dados e não suporta a escrita. Você pode usá-lo para sincronizar seus dados com outros dispositivos ou serviços que não suportam CalDAV.';

  @override
  String get resource => 'Recurso';

  @override
  String get editResource => 'Editar recurso';

  @override
  String deleteResource(String name) {
    return 'Excluir recurso $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Tem certeza que deseja excluir o recurso $name?';
  }

  @override
  String get priority => 'Prioridade';

  @override
  String get assignEvent => 'Atribuir evento';

  @override
  String get noEvent => 'Nenhum evento';

  @override
  String get parentGroup => 'Grupo pai';

  @override
  String deleteUser(String name) {
    return 'Excluir usuário $name';
  }

  @override
  String get createUser => 'Criar usuário';

  @override
  String get editUser => 'Atualizar usuário';

  @override
  String deleteUserDescription(String name) {
    return 'Tem certeza que deseja excluir o usuário $name?';
  }

  @override
  String get pending => 'PENDENTE';

  @override
  String get removeEvent => 'Excluir evento';

  @override
  String get event => 'Evento';

  @override
  String get nativeTitleBar => 'Barra de título nativa';

  @override
  String get blocked => 'Bloqueado';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count eventos',
      one: '1 evento',
      zero: 'Sem eventos',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importação';

  @override
  String get confirmImport => 'Você tem certeza que deseja importá-lo?';

  @override
  String get welcome => 'Boas-vindas';

  @override
  String get url => 'URL:';

  @override
  String get username => 'Usuário:';

  @override
  String get password => 'Palavra-passe';

  @override
  String get connect => 'Conectar';

  @override
  String get data => 'Dado';

  @override
  String get syncing => 'Sincronizando';

  @override
  String get synced => 'Sincronizado';

  @override
  String get error => 'ERRO';

  @override
  String get always => 'sempre';

  @override
  String get noMobile => 'Sem celular';

  @override
  String get manual => 'Manualmente';

  @override
  String get syncMode => 'Modo de sincronização';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Compromisso';

  @override
  String get moment => 'Momento';

  @override
  String get time => 'Horário';

  @override
  String deleteEvent(String name) {
    return 'Excluir evento $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Tem certeza que deseja excluir o evento $name?';
  }

  @override
  String get createAppointment => 'Criar nomeação';

  @override
  String get editAppointment => 'Editar nomeação';

  @override
  String get createMoment => 'Criar momento';

  @override
  String get editMoment => 'Editar momento';

  @override
  String get convertToNote => 'Converter para nota';

  @override
  String get convertToTodo => 'Converter para tarefa';

  @override
  String get open => 'Abertas';

  @override
  String get limited => 'Limitada';

  @override
  String get notSet => 'Não definido';

  @override
  String get createPending => 'Criar pendente';

  @override
  String get editPending => 'Editar pendente';

  @override
  String get convertTo => 'Converter para';

  @override
  String get comingSoon => 'Em breve';

  @override
  String get notSupported => 'Não suportado';

  @override
  String get databaseVersion => 'Versão do banco';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'RESTAURAR';

  @override
  String get markdownIsSupported => 'Markdown é suportado';

  @override
  String get createLabel => 'Criar marcador';

  @override
  String get editLabel => 'Editar etiqueta';

  @override
  String deleteLabel(String name) {
    return 'Excluir etiqueta $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Você tem certeza que deseja excluir a etiqueta $name?';
  }

  @override
  String get label => 'Descrição';

  @override
  String get startOfWeek => 'Início da semana';

  @override
  String headlineNumber(int number) {
    return 'Título $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Riscado';

  @override
  String get code => 'Código';

  @override
  String get link => 'Vincular';

  @override
  String get codeBlock => 'Bloco de código';

  @override
  String get quote => 'Cotação';

  @override
  String get numberedList => 'Lista numerada';

  @override
  String get density => 'Densidade';

  @override
  String get compact => 'Compacta';

  @override
  String get comfortable => 'Confortável';

  @override
  String get standard => 'Padrão';

  @override
  String get highContrast => 'Alto contraste';

  @override
  String get labels => 'Marcadores';

  @override
  String get systemLocale => 'Localização do sistema';

  @override
  String get notebooks => 'Cadernos';

  @override
  String get createNotebook => 'Criar caderno';

  @override
  String get editNotebook => 'Editar caderno';

  @override
  String get update => 'Atualizar';

  @override
  String get currentVersion => 'Versão atual';

  @override
  String get checkForUpdates => 'Verificar se há atualizações';

  @override
  String get checkForUpdatesWarning =>
      'Ao realizar uma verificação de atualizações irá conectar-se ao site Flow para obter as informações.';

  @override
  String get usingLatestStable => 'Está a usar a versão estável mais recente';

  @override
  String get usingLatestNightly => 'Está a usar a versão noturna mais recente';

  @override
  String get updateNow => 'Atualizar agora';

  @override
  String get stable => 'Estável';

  @override
  String get nightly => 'Noturno';

  @override
  String get updateAvailable => 'Atualização disponível';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '1 item',
      zero: 'No items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Tema do sistema';

  @override
  String get desktop => 'Computadores';

  @override
  String get restoreSettingsFromFile => 'Restaurar configurações do arquivo';

  @override
  String get exportSettingsToFile => 'Exportar configurações para arquivo';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Ativado';

  @override
  String get countdown => 'Contagem regressiva';

  @override
  String get unlink => 'Desvincular';

  @override
  String get noAlarms => 'Não há alarmes para exibir.';

  @override
  String get allDay => 'O dia todo';
}

/// The translations for Portuguese, as used in Brazil (`pt_BR`).
class AppLocalizationsPtBr extends AppLocalizationsPt {
  AppLocalizationsPtBr() : super('pt_BR');

  @override
  String get dashboard => 'Painel';

  @override
  String get translate => 'Traduzir';

  @override
  String get calendar => 'calendário';

  @override
  String get resources => 'Recursos';

  @override
  String get users => 'Utilizadores';

  @override
  String get user => 'Usuário';

  @override
  String get sources => 'Fontes';

  @override
  String get settings => 'Confirgurações';

  @override
  String get create => 'Crio';

  @override
  String get information => 'Informacao';

  @override
  String get source => 'fonte';

  @override
  String get license => 'Tipo:';

  @override
  String get thirdPartyLicenses => 'Licenças de Terceiros';

  @override
  String get documentation => 'Documentação';

  @override
  String get privacyPolicy => 'Política de Privacidade';

  @override
  String get imprint => 'Imprimir';

  @override
  String get releaseNotes => 'Notas de Versão';

  @override
  String get changelog => 'Mudanças';

  @override
  String get legal => 'Informações';

  @override
  String get personalization => 'Personalização';

  @override
  String get design => 'Projetar';

  @override
  String get language => 'IDIOMA';

  @override
  String get theme => 'Tema';

  @override
  String get classic => 'Clássico';

  @override
  String get systemDefault => 'Padrão do Sistema';

  @override
  String get light => 'Claro';

  @override
  String get dark => 'Escuro';

  @override
  String get createResource => 'Criar recurso';

  @override
  String get cancel => 'cancelar';

  @override
  String get name => 'Nome:';

  @override
  String get description => 'Descrição:';

  @override
  String get start => 'Iniciar';

  @override
  String get next => 'Próximo';

  @override
  String get skip => 'Ignorar';

  @override
  String get back => 'Anterior';

  @override
  String get today => 'hoje';

  @override
  String get groups => 'grupos';

  @override
  String get createGroup => 'Criar grupo';

  @override
  String get editGroup => 'Editar grupo';

  @override
  String get list => 'Lista';

  @override
  String get day => 'dia';

  @override
  String get week => 'semana';

  @override
  String get month => 'Mês';

  @override
  String get version => 'Versão';

  @override
  String get intro => 'Introdução';

  @override
  String get caldavDescription =>
      'A interface CalDAV permite que você acesse seus dados de qualquer servidor CalDAV. Tem suporte limitado e apenas funções básicas são suportadas. Você pode usá-lo para sincronizar seus dados com outros dispositivos ou serviços.';

  @override
  String get webdavDescription =>
      'A interface WebDAV permite que você acesse seus dados de qualquer servidor WebDAV. Arquivos e diretórios para armazenar dados. Você pode usá-lo para sincronizar seus dados com outros dispositivos ou serviços.';

  @override
  String get server => 'Servidor';

  @override
  String get serverDescription =>
      'Sincronize seus dados com um servidor nativo do Linwood Flow. Isso é recomendado para usuários que querem auto-hospedar seus dados.';

  @override
  String get googleDescription =>
      'Sincronize seus dados com o Google. Isso é recomendado para usuários que querem usar sua conta do Google para acessar seus dados. Nem todos os recursos estão disponíveis com esta opção.';

  @override
  String get microsoftDescription =>
      'Sincronize seus dados com a Microsoft. Isso é recomendado para usuários que queiram usar sua conta da Microsoft para acessar seus dados. Nem todos os recursos estão disponíveis com esta opção.';

  @override
  String get addSource => 'Adicionar fonte';

  @override
  String get local => 'Localização';

  @override
  String get close => 'FECHAR';

  @override
  String get unknown => 'Desconhecido';

  @override
  String get loading => 'Carregando...';

  @override
  String get export => 'Exportação';

  @override
  String get createEvent => 'Criar evento';

  @override
  String get save => 'Guardar';

  @override
  String get allSources => 'Todas as fontes';

  @override
  String get editEvent => 'Editar evento';

  @override
  String get end => 'Término';

  @override
  String get location => 'Local:';

  @override
  String get status => 'SItuação';

  @override
  String get confirmed => 'Confirmado';

  @override
  String get draft => 'Rascunho';

  @override
  String get cancelled => 'Cancelado';

  @override
  String get general => 'Gerais';

  @override
  String get notes => 'Observações';

  @override
  String get createNote => 'Criar nota';

  @override
  String get editNote => 'Editar nota';

  @override
  String get indicatorEmpty => 'Nenhum item encontrado';

  @override
  String get indicatorEmptyDescription => 'A lista está atualmente vazia.';

  @override
  String get indicatorLoading => 'Carregando...';

  @override
  String get indicatorError => 'Ocorreu um erro';

  @override
  String get indicatorErrorDescription =>
      'Ocorreu um erro ao carregar os dados.';

  @override
  String get tryAgain => 'Tente novamente';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event em $date às $time em $location ($status)';
  }

  @override
  String get filter => 'filtro';

  @override
  String get done => 'Concluído';

  @override
  String get inProgress => 'Em Execução';

  @override
  String get note => 'Observação';

  @override
  String get delete => 'excluir';

  @override
  String get edit => 'Alterar';

  @override
  String deleteGroup(String name) {
    return 'Excluir grupo $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Tem certeza que deseja excluir o grupo $name?';
  }

  @override
  String groupName(String name) {
    return 'Grupo $name';
  }

  @override
  String get noData => 'Não há dados para exibir.';

  @override
  String get noEvents => 'Não há eventos para exibir.';

  @override
  String get group => 'grupo';

  @override
  String get search => 'Pesquisa';

  @override
  String get events => 'Eventos';

  @override
  String get past => 'Passado';

  @override
  String get decentralized => 'Descentralizado';

  @override
  String get decentralizedDescription =>
      'A interface descentralizada permite que você acesse seus dados a partir de qualquer servidor descentralizado. Você pode usá-lo para sincronizar seus dados com outros dispositivos ou serviços.';

  @override
  String get importFile => 'Importar arquivo';

  @override
  String get importFileDescription =>
      'Importar um arquivo do seu dispositivo. Você pode importar um arquivo de banco de dados de outra instância do Linwood Flow ou um arquivo de calendário comum.';

  @override
  String get icalDescription =>
      'A interface iCal permite que você acesse seus dados a partir de qualquer servidor iCal. Só pode ler dados e não suporta a escrita. Você pode usá-lo para sincronizar seus dados com outros dispositivos ou serviços que não suportam CalDAV.';

  @override
  String get resource => 'Recurso';

  @override
  String get editResource => 'Editar recurso';

  @override
  String deleteResource(String name) {
    return 'Excluir recurso $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Tem certeza que deseja excluir o recurso $name?';
  }

  @override
  String get priority => 'Prioridade';

  @override
  String get assignEvent => 'Atribuir evento';

  @override
  String get noEvent => 'Nenhum evento';

  @override
  String get parentGroup => 'Grupo pai';

  @override
  String deleteUser(String name) {
    return 'Excluir usuário $name';
  }

  @override
  String get createUser => 'Criar usuário';

  @override
  String get editUser => 'Atualizar usuário';

  @override
  String deleteUserDescription(String name) {
    return 'Tem certeza que deseja excluir o usuário $name?';
  }

  @override
  String get pending => 'PENDENTE';

  @override
  String get removeEvent => 'Excluir evento';

  @override
  String get event => 'Evento';

  @override
  String get nativeTitleBar => 'Barra de título nativa';

  @override
  String get blocked => 'Bloqueado';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count eventos',
      one: '1 evento',
      zero: 'Sem eventos',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importação';

  @override
  String get confirmImport => 'Você tem certeza que deseja importá-lo?';

  @override
  String get welcome => 'Boas-vindas';

  @override
  String get url => 'URL:';

  @override
  String get username => 'Usuário:';

  @override
  String get password => 'Palavra-passe';

  @override
  String get connect => 'Conectar';

  @override
  String get data => 'Dado';

  @override
  String get syncing => 'Sincronizando';

  @override
  String get synced => 'Sincronizado';

  @override
  String get error => 'ERRO';

  @override
  String get always => 'sempre';

  @override
  String get noMobile => 'Sem celular';

  @override
  String get manual => 'Manualmente';

  @override
  String get syncMode => 'Modo de sincronização';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Compromisso';

  @override
  String get moment => 'Momento';

  @override
  String get time => 'Horário';

  @override
  String deleteEvent(String name) {
    return 'Excluir evento $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Tem certeza que deseja excluir o evento $name?';
  }

  @override
  String get createAppointment => 'Criar nomeação';

  @override
  String get editAppointment => 'Editar nomeação';

  @override
  String get createMoment => 'Criar momento';

  @override
  String get editMoment => 'Editar momento';

  @override
  String get convertToNote => 'Converter para nota';

  @override
  String get convertToTodo => 'Converter para tarefa';

  @override
  String get open => 'Abertas';

  @override
  String get limited => 'Limitada';

  @override
  String get notSet => 'Não definido';

  @override
  String get createPending => 'Criar pendente';

  @override
  String get editPending => 'Editar pendente';

  @override
  String get convertTo => 'Converter para';

  @override
  String get comingSoon => 'Em breve';

  @override
  String get notSupported => 'Não suportado';

  @override
  String get databaseVersion => 'Versão do banco';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'RESTAURAR';

  @override
  String get markdownIsSupported => 'Markdown é suportado';

  @override
  String get createLabel => 'Criar marcador';

  @override
  String get editLabel => 'Editar etiqueta';

  @override
  String deleteLabel(String name) {
    return 'Excluir etiqueta $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Você tem certeza que deseja excluir a etiqueta $name?';
  }

  @override
  String get label => 'Descrição';

  @override
  String get startOfWeek => 'Início da semana';

  @override
  String headlineNumber(int number) {
    return 'Título $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Riscado';

  @override
  String get code => 'Código';

  @override
  String get link => 'Vincular';

  @override
  String get codeBlock => 'Bloco de código';

  @override
  String get quote => 'Cotação';

  @override
  String get numberedList => 'Lista numerada';

  @override
  String get density => 'Densidade';

  @override
  String get compact => 'Compacta';

  @override
  String get comfortable => 'Confortável';

  @override
  String get standard => 'Padrão';

  @override
  String get highContrast => 'Alto contraste';

  @override
  String get labels => 'Marcadores';

  @override
  String get systemLocale => 'Localização do sistema';

  @override
  String get notebooks => 'Cadernos';

  @override
  String get createNotebook => 'Criar caderno';

  @override
  String get editNotebook => 'Editar caderno';

  @override
  String get update => 'Atualização';

  @override
  String get currentVersion => 'Versão atual';

  @override
  String get checkForUpdates => 'Verificar se há atualizações';

  @override
  String get checkForUpdatesWarning =>
      'Ao realizar uma verificação de atualizações irá conectar-se ao site Flow para obter as informações.';

  @override
  String get usingLatestStable => 'Você está usando a última versão estável';

  @override
  String get usingLatestNightly => 'Você está usando a última versão noturna';

  @override
  String get updateNow => 'Atualizar agora';

  @override
  String get stable => 'Estável';

  @override
  String get nightly => 'Noturno';

  @override
  String get updateAvailable => 'Atualização disponível';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '1 item',
      zero: 'No items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Tema do sistema';

  @override
  String get desktop => 'Computadores';

  @override
  String get restoreSettingsFromFile => 'Restaurar configurações do arquivo';

  @override
  String get exportSettingsToFile => 'Exportar configurações para arquivo';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Ativado';

  @override
  String get countdown => 'Contagem regressiva';

  @override
  String get unlink => 'Desvincular';

  @override
  String get noAlarms => 'Não há alarmes para exibir.';

  @override
  String get allDay => 'O dia todo';
}
