// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Dutch Flemish (`nl`).
class AppLocalizationsNl extends AppLocalizations {
  AppLocalizationsNl([String locale = 'nl']) : super(locale);

  @override
  String get dashboard => 'Dashboard';

  @override
  String get translate => 'Vertalen';

  @override
  String get calendar => 'Kalender';

  @override
  String get resources => 'Hulpmiddelen';

  @override
  String get users => 'Gebruikers';

  @override
  String get user => 'Gebruiker';

  @override
  String get sources => 'Bronnen';

  @override
  String get settings => 'Instellingen';

  @override
  String get create => 'Aanmaken';

  @override
  String get information => 'Informatie';

  @override
  String get source => 'Bron';

  @override
  String get license => 'Licentie';

  @override
  String get thirdPartyLicenses => 'Licenties van derden';

  @override
  String get documentation => 'Documentatie';

  @override
  String get privacyPolicy => 'Privacy Beleid';

  @override
  String get imprint => 'Impressum';

  @override
  String get releaseNotes => 'Release opmerkingen';

  @override
  String get changelog => 'Wijzigingslogboek';

  @override
  String get legal => 'Juridisch';

  @override
  String get personalization => 'Personalisatie';

  @override
  String get design => 'Ontwerp';

  @override
  String get language => 'Taal';

  @override
  String get theme => 'Thema';

  @override
  String get classic => 'Klassiek';

  @override
  String get systemDefault => 'Standaard systeeminstelling';

  @override
  String get light => 'Licht';

  @override
  String get dark => 'Donker';

  @override
  String get createResource => 'Bron aanmaken';

  @override
  String get cancel => 'annuleren';

  @override
  String get name => 'naam';

  @override
  String get description => 'Beschrijving';

  @override
  String get start => 'Beginnen';

  @override
  String get next => 'Volgende';

  @override
  String get skip => 'Overslaan';

  @override
  String get back => 'Achterzijde';

  @override
  String get today => 'vandaag';

  @override
  String get groups => 'Groepen';

  @override
  String get createGroup => 'Groep aanmaken';

  @override
  String get editGroup => 'Groep bewerken';

  @override
  String get list => 'Klantenlijst';

  @override
  String get day => 'dag';

  @override
  String get week => 'week';

  @override
  String get month => 'maand';

  @override
  String get version => 'Versie';

  @override
  String get intro => 'Introductie';

  @override
  String get caldavDescription =>
      'Op de CalDAV interface kunt u toegang krijgen tot uw gegevens uit elke CalDAV server. Het heeft beperkte ondersteuning en alleen basisfuncties worden ondersteund. U kunt het gebruiken om uw gegevens te synchroniseren met andere apparaten of diensten.';

  @override
  String get webdavDescription =>
      'De WebDAV interface geeft u toegang tot uw gegevens vanaf elke WebDAV server. Het zijn bestanden en mappen om gegevens op te slaan. U kunt deze gebruiken om uw gegevens te synchroniseren met andere apparaten of diensten.';

  @override
  String get server => 'Server';

  @override
  String get serverDescription =>
      'Synchroniseer je gegevens met een native Linwood Flow server. Dit is aanbevolen voor gebruikers die hun gegevens zelf willen organiseren.';

  @override
  String get googleDescription =>
      'Synchroniseer uw gegevens met Google. Dit wordt aanbevolen voor gebruikers die hun Google-account willen gebruiken om toegang te krijgen tot hun gegevens. Niet alle functies zijn beschikbaar met deze optie.';

  @override
  String get microsoftDescription =>
      'Synchroniseer je gegevens met Microsoft. Dit wordt aanbevolen voor gebruikers die hun Microsoft account willen gebruiken om toegang te krijgen tot hun gegevens. Niet alle functies zijn beschikbaar met deze optie.';

  @override
  String get addSource => 'Bron toevoegen';

  @override
  String get local => 'lokaal';

  @override
  String get close => 'Afsluiten';

  @override
  String get unknown => 'onbekend';

  @override
  String get loading => 'Laden...';

  @override
  String get export => 'Exporteren';

  @override
  String get createEvent => 'Creëer evenement';

  @override
  String get save => 'Opslaan';

  @override
  String get allSources => 'Alle bronnen';

  @override
  String get editEvent => 'Afspraak bewerken';

  @override
  String get end => 'Beëindigen';

  @override
  String get location => 'Locatie';

  @override
  String get status => 'status';

  @override
  String get confirmed => 'Bevestigd';

  @override
  String get draft => 'Kladversie';

  @override
  String get cancelled => 'Geannuleerd';

  @override
  String get general => 'Algemeen';

  @override
  String get notes => 'Opmerkingen';

  @override
  String get createNote => 'Notitie maken';

  @override
  String get editNote => 'Notitie bewerken';

  @override
  String get indicatorEmpty => 'Geen items gevonden';

  @override
  String get indicatorEmptyDescription => 'De lijst is momenteel leeg.';

  @override
  String get indicatorLoading => 'Laden...';

  @override
  String get indicatorError => 'Er is een fout opgetreden';

  @override
  String get indicatorErrorDescription =>
      'Er is een fout opgetreden tijdens het laden van de gegevens.';

  @override
  String get tryAgain => 'Opnieuw proberen';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event op $date om $time in $location ($status)';
  }

  @override
  String get filter => 'Filteren';

  @override
  String get done => 'Voltooid';

  @override
  String get inProgress => 'In behandeling';

  @override
  String get note => 'Notitie';

  @override
  String get delete => 'Verwijderen';

  @override
  String get edit => 'Bewerken';

  @override
  String deleteGroup(String name) {
    return 'Verwijder groep $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Weet u zeker dat u de groep $name wilt verwijderen?';
  }

  @override
  String groupName(String name) {
    return 'Groep $name';
  }

  @override
  String get noData => 'Er zijn geen gegevens om weer te geven.';

  @override
  String get noEvents => 'Er zijn geen evenementen om weer te geven.';

  @override
  String get group => 'Groeperen';

  @override
  String get search => 'Zoeken';

  @override
  String get events => 'Evenementen';

  @override
  String get past => 'Verleden';

  @override
  String get decentralized => 'Ongecentraliseerd';

  @override
  String get decentralizedDescription =>
      'Het gedecentraliseerde scherm geeft u toegang tot uw gegevens van elke gedecentraliseerde server. U kunt het gebruiken om uw gegevens te synchroniseren met andere apparaten of diensten.';

  @override
  String get importFile => 'Bestand importeren';

  @override
  String get importFileDescription =>
      'Importeer een bestand vanaf uw apparaat. U kunt een databasebestand importeren uit een ander Linwood Flow exemplaar of een normaal kalenderbestand.';

  @override
  String get icalDescription =>
      'De iCal interface geeft u toegang tot uw gegevens op elke iCal server. Het kan alleen gegevens lezen en ondersteunt geen schrijfgegevens. U kunt het gebruiken om uw gegevens te synchroniseren met andere apparaten of diensten die CalDAV niet ondersteunen.';

  @override
  String get resource => 'Bron';

  @override
  String get editResource => 'Bewerk document';

  @override
  String deleteResource(String name) {
    return 'Verwijder resource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Weet u zeker dat u de bron $name wilt verwijderen?';
  }

  @override
  String get priority => 'Prioriteit';

  @override
  String get assignEvent => 'Afspraak toewijzen';

  @override
  String get noEvent => 'Geen gebeurtenis';

  @override
  String get parentGroup => 'Bovenliggende groep';

  @override
  String deleteUser(String name) {
    return 'Verwijder gebruiker $name';
  }

  @override
  String get createUser => 'Gebruiker aanmaken';

  @override
  String get editUser => 'Gebruiker bewerken';

  @override
  String deleteUserDescription(String name) {
    return 'Weet u zeker dat u gebruiker $name wilt verwijderen?';
  }

  @override
  String get pending => 'Lopende';

  @override
  String get removeEvent => 'Gebeurtenis verwijderen';

  @override
  String get event => 'Gebeurtenis';

  @override
  String get nativeTitleBar => 'Oorspronkelijke titelbalk';

  @override
  String get blocked => 'Geblokkeerd';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count events',
      one: '1 event',
      zero: 'No events',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importeren';

  @override
  String get confirmImport => 'Weet u zeker dat u deze wilt importeren?';

  @override
  String get welcome => 'Verwelkoming';

  @override
  String get url => 'URL';

  @override
  String get username => 'Gebruikersnaam';

  @override
  String get password => 'Wachtwoord';

  @override
  String get connect => 'Verbinden';

  @override
  String get data => 'Gegevens';

  @override
  String get syncing => 'Synchroniseren';

  @override
  String get synced => 'Gesynchroniseerd';

  @override
  String get error => 'Foutmelding';

  @override
  String get always => 'altijd';

  @override
  String get noMobile => 'Geen mobiel';

  @override
  String get manual => 'Handleiding';

  @override
  String get syncMode => 'Synchronisatie modus';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Afspraak';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Tijd';

  @override
  String deleteEvent(String name) {
    return 'Afspraak $name verwijderen';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Weet u zeker dat u het evenement $name wilt verwijderen?';
  }

  @override
  String get createAppointment => 'Creëer afspraak';

  @override
  String get editAppointment => 'Afspraak bewerken';

  @override
  String get createMoment => 'Moment aanmaken';

  @override
  String get editMoment => 'Bewerk moment';

  @override
  String get convertToNote => 'Converteren naar notitie';

  @override
  String get convertToTodo => 'Converteren naar todo';

  @override
  String get open => 'Open';

  @override
  String get limited => 'Beperkt';

  @override
  String get notSet => 'Niet ingesteld';

  @override
  String get createPending => 'Aanmaken in afwachting';

  @override
  String get editPending => 'In afwachting bewerken';

  @override
  String get convertTo => 'Converteren naar';

  @override
  String get comingSoon => 'Binnenkort beschikbaar';

  @override
  String get notSupported => 'Niet ondersteund';

  @override
  String get databaseVersion => 'Database versie';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Herstellen';

  @override
  String get markdownIsSupported => 'Markdown wordt ondersteund';

  @override
  String get createLabel => 'Label aanmaken';

  @override
  String get editLabel => 'Bewerk label';

  @override
  String deleteLabel(String name) {
    return 'Verwijder label $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Weet u zeker dat u het label $name wilt verwijderen?';
  }

  @override
  String get label => 'Omschrijving';

  @override
  String get startOfWeek => 'Begin van de week';

  @override
  String headlineNumber(int number) {
    return 'Kop $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Doorhalen';

  @override
  String get code => 'Code';

  @override
  String get link => 'Koppeling';

  @override
  String get codeBlock => 'Code blok';

  @override
  String get quote => 'Offerte';

  @override
  String get numberedList => 'Genummerde lijst';

  @override
  String get density => 'Dichtheid';

  @override
  String get compact => 'Compacte';

  @override
  String get comfortable => 'Comfortabel';

  @override
  String get standard => 'Standaard';

  @override
  String get highContrast => 'Hoog contrast';

  @override
  String get labels => 'Labels';

  @override
  String get systemLocale => 'Systeem lokalisatie';

  @override
  String get notebooks => 'Notitieboekjes';

  @override
  String get createNotebook => 'Notitieboekje maken';

  @override
  String get editNotebook => 'Notitieboekje bewerken';

  @override
  String get update => 'Vernieuwen';

  @override
  String get currentVersion => 'Huidige versie';

  @override
  String get checkForUpdates => 'Op updates controleren';

  @override
  String get checkForUpdatesWarning =>
      'Door controle uit te voeren op updates wordt verbinding gemaakt met de Flow website om de informatie te krijgen.';

  @override
  String get usingLatestStable => 'U gebruikt de laatste stabiele versie';

  @override
  String get usingLatestNightly => 'U gebruikt de laatste nightly versie';

  @override
  String get updateNow => 'Nu bijwerken';

  @override
  String get stable => 'Stabiel';

  @override
  String get nightly => 'Nachtelijk';

  @override
  String get updateAvailable => 'Update beschikbaar';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '1 item',
      zero: 'No items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Systeem thema';

  @override
  String get desktop => 'Startscherm';

  @override
  String get restoreSettingsFromFile =>
      'Instellingen herstellen vanuit bestand';

  @override
  String get exportSettingsToFile => 'Instellingen exporteren naar bestand';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Ingeschakeld';

  @override
  String get countdown => 'Aftellen';

  @override
  String get unlink => 'Ontkoppelen';

  @override
  String get noAlarms => 'Er zijn geen alarmen om weer te geven.';

  @override
  String get allDay => 'De hele dag';
}
