// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Arabic (`ar`).
class AppLocalizationsAr extends AppLocalizations {
  AppLocalizationsAr([String locale = 'ar']) : super(locale);

  @override
  String get dashboard => 'لوحة التحكم';

  @override
  String get translate => 'ترجم';

  @override
  String get calendar => 'التقويم';

  @override
  String get resources => 'الموارد';

  @override
  String get users => 'المستخدمون';

  @override
  String get user => 'المستخدم';

  @override
  String get sources => 'المصادر';

  @override
  String get settings => 'الإعدادات';

  @override
  String get create => 'إنشاء';

  @override
  String get information => 'معلومات';

  @override
  String get source => 'المصدر';

  @override
  String get license => 'الترخيص';

  @override
  String get thirdPartyLicenses => 'تراخيص الطرف الثالث';

  @override
  String get documentation => 'الوثائق';

  @override
  String get privacyPolicy => 'سياسة الخصوصية';

  @override
  String get imprint => 'بصمة';

  @override
  String get releaseNotes => 'ملاحظات الإصدار';

  @override
  String get changelog => 'تغيير';

  @override
  String get legal => 'قانوني';

  @override
  String get personalization => 'التخصيص';

  @override
  String get design => 'تصميم';

  @override
  String get language => 'اللغة';

  @override
  String get theme => 'السمة';

  @override
  String get classic => 'كلاسيكي';

  @override
  String get systemDefault => 'النظام الافتراضي';

  @override
  String get light => 'فاتح';

  @override
  String get dark => 'داكن';

  @override
  String get createResource => 'إنشاء مورد';

  @override
  String get cancel => 'إلغاء';

  @override
  String get name => 'الاسم';

  @override
  String get description => 'الوصف';

  @override
  String get start => 'ابدأ';

  @override
  String get next => 'التالي';

  @override
  String get skip => 'تخطي';

  @override
  String get back => 'الرجوع';

  @override
  String get today => 'اليوم';

  @override
  String get groups => 'المجموعات';

  @override
  String get createGroup => 'إنشاء مجموعة';

  @override
  String get editGroup => 'تحرير المجموعة';

  @override
  String get list => 'قائمة';

  @override
  String get day => 'يوم';

  @override
  String get week => 'أسبوع';

  @override
  String get month => 'شهر';

  @override
  String get version => 'الإصدار';

  @override
  String get intro => 'مقدمة';

  @override
  String get caldavDescription =>
      'تتيح لك واجهة CalDAV الوصول إلى بياناتك من أي خادم CalDAV. يحتوي على دعم محدود و فقط الوظائف الأساسية مدعومة. يمكنك استخدامه لمزامنة بياناتك مع الأجهزة أو الخدمات الأخرى.';

  @override
  String get webdavDescription =>
      'تتيح لك واجهة WebDAV الوصول إلى بياناتك من أي خادم WebDAV. إنها الملفات والدلائل لتخزين البيانات. يمكنك استخدامها لمزامنة بياناتك مع الأجهزة أو الخدمات الأخرى.';

  @override
  String get server => 'خادم';

  @override
  String get serverDescription =>
      'مزامنة بياناتك مع خادم لينود الأصلي. ينصح هذا للمستخدمين الذين يريدون استضافة بياناتهم ذاتيا.';

  @override
  String get googleDescription =>
      'قم بمزامنة بياناتك مع جوجل. وهذا ينصح للمستخدمين الذين يريدون استخدام حساب جوجل للوصول إلى بياناتهم. ليست كل الميزات متوفرة مع هذا الخيار.';

  @override
  String get microsoftDescription =>
      'قم بمزامنة بياناتك مع مايكروسوفت. ينصح هذا للمستخدمين الذين يريدون استخدام حساب مايكروسوفت للوصول إلى بياناتهم. ليست كل الميزات متوفرة مع هذا الخيار.';

  @override
  String get addSource => 'إضافة مصدر';

  @override
  String get local => 'محلي';

  @override
  String get close => 'أغلق';

  @override
  String get unknown => 'غير معروف';

  @override
  String get loading => 'جاري التحميل';

  @override
  String get export => 'تصدير';

  @override
  String get createEvent => 'إنشاء حدث';

  @override
  String get save => 'حفظ';

  @override
  String get allSources => 'جميع المصادر';

  @override
  String get editEvent => 'تحرير الحدث';

  @override
  String get end => 'نهاية';

  @override
  String get location => 'الموقع';

  @override
  String get status => 'الحالة';

  @override
  String get confirmed => 'مؤكد';

  @override
  String get draft => 'مسودة';

  @override
  String get cancelled => 'ملغاة';

  @override
  String get general => 'عام';

  @override
  String get notes => 'الحواشي';

  @override
  String get createNote => 'إنشاء ملاحظة';

  @override
  String get editNote => 'تعديل الملاحظة';

  @override
  String get indicatorEmpty => 'لم يتم العثور على عناصر';

  @override
  String get indicatorEmptyDescription => 'القائمة فارغة حاليا.';

  @override
  String get indicatorLoading => 'جاري التحميل';

  @override
  String get indicatorError => 'حدث خطأ';

  @override
  String get indicatorErrorDescription => 'حدث خطأ أثناء تحميل البيانات.';

  @override
  String get tryAgain => 'حاول مرة أخرى';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event في $date في $time في $location ($status)';
  }

  @override
  String get filter => 'تصفية';

  @override
  String get done => 'تم';

  @override
  String get inProgress => 'قيد التقدم';

  @override
  String get note => 'ملاحظة';

  @override
  String get delete => 'حذف';

  @override
  String get edit => 'تحرير';

  @override
  String deleteGroup(String name) {
    return 'حذف المجموعة $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'هل أنت متأكد من أنك تريد حذف المجموعة $name؟';
  }

  @override
  String groupName(String name) {
    return 'مجموعة $name';
  }

  @override
  String get noData => 'لا توجد بيانات لعرضها.';

  @override
  String get noEvents => 'لا توجد أحداث لعرضها.';

  @override
  String get group => 'مجموعة';

  @override
  String get search => 'البحث';

  @override
  String get events => 'الأحداث';

  @override
  String get past => 'الماضي';

  @override
  String get decentralized => 'لامركزية';

  @override
  String get decentralizedDescription =>
      'تتيح لك الواجهة اللامركزية الوصول إلى بياناتك من أي خادم لامركزي. يمكنك استخدامه لمزامنة بياناتك مع الأجهزة أو الخدمات الأخرى.';

  @override
  String get importFile => 'استيراد ملف';

  @override
  String get importFileDescription =>
      'استيراد ملف من جهازك. يمكنك استيراد ملف قاعدة بيانات من نموذج لينود آخر أو ملف تقويم عادي.';

  @override
  String get icalDescription =>
      'واجهة iCal تسمح لك بالوصول إلى بياناتك من أي خادم iCal. يمكنها فقط قراءة البيانات ولا تدعم الكتابة. يمكنك استخدامه لمزامنة بياناتك مع الأجهزة الأخرى أو الخدمات التي لا تدعم CalDAV.';

  @override
  String get resource => 'المورد';

  @override
  String get editResource => 'تعديل المورد';

  @override
  String deleteResource(String name) {
    return 'حذف المورد $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'هل أنت متأكد من أنك تريد حذف المورد $name؟';
  }

  @override
  String get priority => 'الأولوية';

  @override
  String get assignEvent => 'تعيين الحدث';

  @override
  String get noEvent => 'لا يوجد حدث';

  @override
  String get parentGroup => 'المجموعة الأصل';

  @override
  String deleteUser(String name) {
    return 'حذف المستخدم $name';
  }

  @override
  String get createUser => 'إنشاء مستخدم';

  @override
  String get editUser => 'تحرير المستخدم';

  @override
  String deleteUserDescription(String name) {
    return 'هل أنت متأكد من أنك تريد حذف المستخدم $name؟';
  }

  @override
  String get pending => 'معلق';

  @override
  String get removeEvent => 'إزالة الحدث';

  @override
  String get event => 'الحدث';

  @override
  String get nativeTitleBar => 'شريط العنوان الأصلي';

  @override
  String get blocked => 'محظور';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count أحداث',
      one: 'حدث واحد',
      zero: 'لا أحداث',
    );
    return '$_temp0';
  }

  @override
  String get import => 'استيراد';

  @override
  String get confirmImport => 'هل أنت متأكد من أنك تريد استيرادها؟';

  @override
  String get welcome => 'مرحبا بك';

  @override
  String get url => 'الرابط';

  @override
  String get username => 'اسم المستخدم';

  @override
  String get password => 'كلمة المرور';

  @override
  String get connect => 'الاتصال';

  @override
  String get data => 'البيانات';

  @override
  String get syncing => 'مزامنة';

  @override
  String get synced => 'مزامنة';

  @override
  String get error => 'خطأ';

  @override
  String get always => 'دائما';

  @override
  String get noMobile => 'لا يوجد هاتف';

  @override
  String get manual => 'دليل';

  @override
  String get syncMode => 'وضع المزامنة';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'تعيين';

  @override
  String get moment => 'لحظة';

  @override
  String get time => 'الوقت';

  @override
  String deleteEvent(String name) {
    return 'حذف الحدث $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'هل أنت متأكد من أنك تريد حذف الحدث $name؟';
  }

  @override
  String get createAppointment => 'إنشاء موعد';

  @override
  String get editAppointment => 'تعديل الموعد';

  @override
  String get createMoment => 'إنشاء لحظة';

  @override
  String get editMoment => 'تحرير اللحظة';

  @override
  String get convertToNote => 'تحويل إلى ملاحظة';

  @override
  String get convertToTodo => 'تحويل إلى مهمة';

  @override
  String get open => 'فتح';

  @override
  String get limited => 'محدود';

  @override
  String get notSet => 'لم يتم تعيينه';

  @override
  String get createPending => 'إنشاء معلق';

  @override
  String get editPending => 'تحرير معلق';

  @override
  String get convertTo => 'تحويل إلى';

  @override
  String get comingSoon => 'قريباً';

  @override
  String get notSupported => 'غير مدعوم';

  @override
  String get databaseVersion => 'إصدار قاعدة البيانات';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'إستعادة';

  @override
  String get markdownIsSupported => 'Markdown مدعوم';

  @override
  String get createLabel => 'إنشاء تسمية';

  @override
  String get editLabel => 'تعديل التسمية';

  @override
  String deleteLabel(String name) {
    return 'حذف التسمية $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'هل أنت متأكد من أنك تريد حذف التسمية $name؟';
  }

  @override
  String get label => 'تسمية';

  @override
  String get startOfWeek => 'بداية الأسبوع';

  @override
  String headlineNumber(int number) {
    return 'العنوان $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'ضربة';

  @override
  String get code => 'الكود';

  @override
  String get link => 'رابط';

  @override
  String get codeBlock => 'كتلة التعليمات البرمجية';

  @override
  String get quote => 'اقتباس';

  @override
  String get numberedList => 'قائمة مرقمة';

  @override
  String get density => 'الكثافة';

  @override
  String get compact => 'مدمج';

  @override
  String get comfortable => 'مريح';

  @override
  String get standard => 'قياسي';

  @override
  String get highContrast => 'تباين عالي';

  @override
  String get labels => 'التسميات';

  @override
  String get systemLocale => 'محلي النظام';

  @override
  String get notebooks => 'الحواشي';

  @override
  String get createNotebook => 'إنشاء دفتر ملاحظات';

  @override
  String get editNotebook => 'تحرير دفتر الملاحظات';

  @override
  String get update => 'تحديث';

  @override
  String get currentVersion => 'الإصدار الحالي';

  @override
  String get checkForUpdates => 'التحقق من وجود تحديثات';

  @override
  String get checkForUpdatesWarning =>
      'إجراء التحقق من التحديثات سوف يتصل بموقع التدفق للحصول على المعلومات.';

  @override
  String get usingLatestStable => 'أنت تستخدم أحدث إصدار مستقر';

  @override
  String get usingLatestNightly => 'أنت تستخدم أحدث إصدار ليلي';

  @override
  String get updateNow => 'التحديث الآن';

  @override
  String get stable => 'اسطبل';

  @override
  String get nightly => 'ليلي';

  @override
  String get updateAvailable => 'التحديث متاح';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count عناصر',
      one: 'عنصر واحد',
      zero: 'لا توجد عناصر',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'سمة النظام';

  @override
  String get desktop => 'سطح المكتب';

  @override
  String get restoreSettingsFromFile => 'استعادة الإعدادات من الملف';

  @override
  String get exportSettingsToFile => 'تصدير الإعدادات إلى ملف';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'تمكين';

  @override
  String get countdown => 'العد التنازلي';

  @override
  String get unlink => 'إلغاء الارتباط';

  @override
  String get noAlarms => 'لا يوجد تنبيهات لعرضها.';

  @override
  String get allDay => 'طوال اليوم';
}
