// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Turkish (`tr`).
class AppLocalizationsTr extends AppLocalizations {
  AppLocalizationsTr([String locale = 'tr']) : super(locale);

  @override
  String get dashboard => 'Kontrol Paneli';

  @override
  String get translate => 'Çevir';

  @override
  String get calendar => 'Takvim';

  @override
  String get resources => 'Resources';

  @override
  String get users => 'Kullanıcılar';

  @override
  String get user => 'User';

  @override
  String get sources => 'Kaynaklar';

  @override
  String get settings => 'Ayarlar';

  @override
  String get create => 'Oluştur';

  @override
  String get information => 'Bilgi';

  @override
  String get source => 'Kaynak';

  @override
  String get license => 'Lisans';

  @override
  String get thirdPartyLicenses => 'Üçüncü Parti Lisansları';

  @override
  String get documentation => 'Dökümantasyon';

  @override
  String get privacyPolicy => 'Gizlilik Politikası';

  @override
  String get imprint => 'Künye';

  @override
  String get releaseNotes => 'Sürüm Notları';

  @override
  String get changelog => 'Değişim kaydı';

  @override
  String get legal => 'Yasal';

  @override
  String get personalization => 'Kişiselleştirme';

  @override
  String get design => 'Tasarım';

  @override
  String get language => 'Dil';

  @override
  String get theme => 'Tema';

  @override
  String get classic => 'Klasik';

  @override
  String get systemDefault => 'Sistem Varsayılanı';

  @override
  String get light => 'Açık';

  @override
  String get dark => 'Koyu';

  @override
  String get createResource => 'Create resource';

  @override
  String get cancel => 'İptal';

  @override
  String get name => 'Ad';

  @override
  String get description => 'Açıklama';

  @override
  String get start => 'Başla';

  @override
  String get next => 'Sıradaki';

  @override
  String get skip => 'Geç';

  @override
  String get back => 'Geri';

  @override
  String get today => 'Bugün';

  @override
  String get groups => 'Gruplar';

  @override
  String get createGroup => 'Grup oluştur';

  @override
  String get editGroup => 'Grubu düzenle';

  @override
  String get list => 'Liste';

  @override
  String get day => 'Gün';

  @override
  String get week => 'Hafta';

  @override
  String get month => 'Ay';

  @override
  String get version => 'Sürüm';

  @override
  String get intro => 'Tanıtım';

  @override
  String get caldavDescription =>
      'CalDAV arayüzü, verilerinize herhangi bir CalDAV sunucusundan erişmenizi sağlar. Desteği sınırlıdır ve yalnızca temel işlevler desteklenir. Verilerinizi diğer cihazlarla veya hizmetlerle senkronize etmek için kullanabilirsiniz.';

  @override
  String get webdavDescription =>
      'WebDAV arayüzü, verilerinize herhangi bir WebDAV sunucusundan erişmenizi sağlar. Verileri depolamak için dosyalar ve dizinler. Verilerinizi diğer cihazlarla veya hizmetlerle senkronize etmek için kullanabilirsiniz.';

  @override
  String get server => 'Sunucu';

  @override
  String get serverDescription =>
      'Verilerinizi yerel bir Linwood Flow sunucusu ile senkronize edin. Bu, verilerini kendi kendine barındırmak isteyen kullanıcılar için önerilir.';

  @override
  String get googleDescription =>
      'Verilerinizi Google ile senkronize edin. Bu, verilerine erişmek için Google hesaplarını kullanmak isteyen kullanıcılar için önerilir. Bu seçenekle tüm özellikler kullanılamaz.';

  @override
  String get microsoftDescription =>
      'Verilerinizi Microsoft ile senkronize edin. Bu, verilerine erişmek için Microsoft hesaplarını kullanmak isteyen kullanıcılar için önerilir. Bu seçenekle tüm özellikler kullanılamaz.';

  @override
  String get addSource => 'Kaynak ekle';

  @override
  String get local => 'Yerel';

  @override
  String get close => 'Kapat';

  @override
  String get unknown => 'Bilinmiyor';

  @override
  String get loading => 'Yükleniyor';

  @override
  String get export => 'Dışa Aktar';

  @override
  String get createEvent => 'Etkinlik oluştur';

  @override
  String get save => 'Kaydet';

  @override
  String get allSources => 'Tüm kaynaklar';

  @override
  String get editEvent => 'Etkinliği düzenle';

  @override
  String get end => 'Bitiş';

  @override
  String get location => 'Konum';

  @override
  String get status => 'Durum';

  @override
  String get confirmed => 'Doğrulanmış';

  @override
  String get draft => 'Taslak';

  @override
  String get cancelled => 'İptal edildi';

  @override
  String get general => 'Genel';

  @override
  String get notes => 'Notlar';

  @override
  String get createNote => 'Not oluştur';

  @override
  String get editNote => 'Notu düzenle';

  @override
  String get indicatorEmpty => 'Öğe bulunamadı';

  @override
  String get indicatorEmptyDescription => 'Liste şu anda boş.';

  @override
  String get indicatorLoading => 'Yükleniyor';

  @override
  String get indicatorError => 'Bir hata oluştu';

  @override
  String get indicatorErrorDescription =>
      'Veriler yüklenirken bir hata oluştu.';

  @override
  String get tryAgain => 'Tekrar deneyin';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event etkinliği için tarih $date, saat $time, konum $location ($status)';
  }

  @override
  String get filter => 'Filtre';

  @override
  String get done => 'Bitti';

  @override
  String get inProgress => 'Devam ediyor';

  @override
  String get note => 'Not';

  @override
  String get delete => 'Sil';

  @override
  String get edit => 'Düzenle';

  @override
  String deleteGroup(String name) {
    return '$name grubunu sil';
  }

  @override
  String deleteGroupDescription(String name) {
    return '$name grubunu silmek istediğinize emin misiniz?';
  }

  @override
  String groupName(String name) {
    return '$name grubu';
  }

  @override
  String get noData => 'Görüntülenecek veri yok.';

  @override
  String get noEvents => 'Gösterilecek etkinlik yok.';

  @override
  String get group => 'Grup';

  @override
  String get search => 'Ara';

  @override
  String get events => 'Etkinlikler';

  @override
  String get past => 'Geçmiş';

  @override
  String get decentralized => 'Merkeziyetsiz';

  @override
  String get decentralizedDescription =>
      'Merkezi olmayan arayüz, verilerinize herhangi bir merkezi olmayan sunucudan erişmenizi sağlar. Verilerinizi diğer cihazlarla veya hizmetlerle senkronize etmek için kullanabilirsiniz.';

  @override
  String get importFile => 'Dosyayı içeri aktar';

  @override
  String get importFileDescription =>
      'Cihazınızdan bir dosya içe aktarın. Başka bir Linwood Flow örneğinden bir veritabanı dosyasını veya normal bir takvim dosyasını içe aktarabilirsiniz.';

  @override
  String get icalDescription =>
      'iCal arayüzü, verilerinize herhangi bir iCal sunucusundan erişmenizi sağlar. Yalnızca veri okuyabilir ve yazmayı desteklemez. Verilerinizi CalDAV\'ı desteklemeyen diğer cihazlarla veya hizmetlerle senkronize etmek için kullanabilirsiniz.';

  @override
  String get resource => 'Resource';

  @override
  String get editResource => 'Edit resource';

  @override
  String deleteResource(String name) {
    return 'Delete resource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Are you sure you want to delete the resource $name?';
  }

  @override
  String get priority => 'Periyot';

  @override
  String get assignEvent => 'Etkinlik ata';

  @override
  String get noEvent => 'Etkinlik yok';

  @override
  String get parentGroup => 'Ebeveyn grubu';

  @override
  String deleteUser(String name) {
    return '$name kullanıcısını sil';
  }

  @override
  String get createUser => 'Kullanıcı oluştur';

  @override
  String get editUser => 'Kullanıcıyı düzenle';

  @override
  String deleteUserDescription(String name) {
    return '$name kullanıcısını silmek istediğinize emin misiniz?';
  }

  @override
  String get pending => 'Bekliyor';

  @override
  String get removeEvent => 'Etkinliği kaldır';

  @override
  String get event => 'Etkinlik';

  @override
  String get nativeTitleBar => 'Yerel başlık çubuğu';

  @override
  String get blocked => 'Engellendi';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count etkinlik',
      one: '1 etkinlik',
      zero: 'Etkinlik yok',
    );
    return '$_temp0';
  }

  @override
  String get import => 'İçe aktar';

  @override
  String get confirmImport => 'İçe aktarmak istediğinize emin misiniz?';

  @override
  String get welcome => 'Hoş geldiniz ';

  @override
  String get url => 'URL';

  @override
  String get username => 'Kullanıcı adı';

  @override
  String get password => 'Şifre';

  @override
  String get connect => 'Bağla';

  @override
  String get data => 'Veri';

  @override
  String get syncing => 'Eşitleniyor';

  @override
  String get synced => 'Eşitlendi';

  @override
  String get error => 'Hata';

  @override
  String get always => 'Her zaman';

  @override
  String get noMobile => 'Mobil yok';

  @override
  String get manual => 'Elle';

  @override
  String get syncMode => 'Eşitleme modu';

  @override
  String get todo => 'Yapılacak';

  @override
  String get appointment => 'Randevu';

  @override
  String get moment => 'An';

  @override
  String get time => 'Saat';

  @override
  String deleteEvent(String name) {
    return '$name etkinliğini sil';
  }

  @override
  String deleteEventDescription(String name) {
    return '$name etkinliğini silmek istediğinize emin misiniz?';
  }

  @override
  String get createAppointment => 'Randevu oluştur';

  @override
  String get editAppointment => 'Randevuyu düzenle';

  @override
  String get createMoment => 'Etkinlik oluştur';

  @override
  String get editMoment => 'Anı düzenle';

  @override
  String get convertToNote => 'Nota dönüştür';

  @override
  String get convertToTodo => 'Yapılacaklara dönüştür';

  @override
  String get open => 'Aç';

  @override
  String get limited => 'Sınırlanmış';

  @override
  String get notSet => 'Belirlenmemiş';

  @override
  String get createPending => 'Beklemede oluştur';

  @override
  String get editPending => 'Düzenleme beklemede';

  @override
  String get convertTo => 'Şuna dönüştür';

  @override
  String get comingSoon => 'Yakında';

  @override
  String get notSupported => 'Desteklenmiyor';

  @override
  String get databaseVersion => 'Veritabanı sürümü';

  @override
  String get minimize => 'Küçült';

  @override
  String get maximize => 'Büyüt';

  @override
  String get restore => 'Geri Yükle';

  @override
  String get markdownIsSupported => 'Markdown desteklenir';

  @override
  String get createLabel => 'Etiket oluştur';

  @override
  String get editLabel => 'Etiketi düzenle';

  @override
  String deleteLabel(String name) {
    return '$name etiketini sil';
  }

  @override
  String deleteLabelDescription(Object name) {
    return '$name etiketini silmek istediğinize emin misiniz?';
  }

  @override
  String get label => 'Etiket';

  @override
  String get startOfWeek => 'Haftanın başlangıcı';

  @override
  String headlineNumber(int number) {
    return '$number başlığı';
  }

  @override
  String get bold => 'Kalın';

  @override
  String get italic => 'İtalik';

  @override
  String get strikethrough => 'Üstü çizili';

  @override
  String get code => 'Kod';

  @override
  String get link => 'Bağlantı';

  @override
  String get codeBlock => 'Kod bloğu';

  @override
  String get quote => 'Alıntı';

  @override
  String get numberedList => 'Numaralı liste';

  @override
  String get density => 'Genişlik';

  @override
  String get compact => 'Sıkıştır';

  @override
  String get comfortable => 'Geniş';

  @override
  String get standard => 'Standart';

  @override
  String get highContrast => 'Yüksek kontrast';

  @override
  String get labels => 'Etiketler';

  @override
  String get systemLocale => 'Sistem varsayılanı';

  @override
  String get notebooks => 'Not Defterleri';

  @override
  String get createNotebook => 'Not defteri oluştur';

  @override
  String get editNotebook => 'Not defterini düzenle';

  @override
  String get update => 'Güncelleme';

  @override
  String get currentVersion => 'Şu anki sürüm';

  @override
  String get checkForUpdates => 'Güncellemeleri denetle';

  @override
  String get checkForUpdatesWarning =>
      'Performing a check for updates will connect to the Flow website to get the information.';

  @override
  String get usingLatestStable => 'En son sürümü kullanıyorsunuz';

  @override
  String get usingLatestNightly =>
      'En son nightly (kod tabanından gelen) sürümü kullanıyorsunuz';

  @override
  String get updateNow => 'Şimdi güncelle';

  @override
  String get stable => 'Kararlı';

  @override
  String get nightly => 'Nightly';

  @override
  String get updateAvailable => 'Güncelleme mevcut';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '1 item',
      zero: 'No items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'System theme';

  @override
  String get desktop => 'Masaüstü';

  @override
  String get restoreSettingsFromFile => 'Ayarları dosyadan geri yükle';

  @override
  String get exportSettingsToFile => 'Ayarları dosyaya dışa aktar';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Enabled';

  @override
  String get countdown => 'Countdown';

  @override
  String get unlink => 'Unlink';

  @override
  String get noAlarms => 'There are no alarms to display.';

  @override
  String get allDay => 'All day';
}
