// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Norwegian (`no`).
class AppLocalizationsNo extends AppLocalizations {
  AppLocalizationsNo([String locale = 'no']) : super(locale);

  @override
  String get dashboard => 'Kontrollpanel';

  @override
  String get translate => 'Oversett';

  @override
  String get calendar => 'Kalender';

  @override
  String get resources => 'Ressurser';

  @override
  String get users => 'Brukere';

  @override
  String get user => 'Bruker';

  @override
  String get sources => 'Kilder';

  @override
  String get settings => 'Innstillinger';

  @override
  String get create => 'Opprett';

  @override
  String get information => 'Informasjon';

  @override
  String get source => 'Kilde';

  @override
  String get license => 'Lisens';

  @override
  String get thirdPartyLicenses => 'Tredje part lisens';

  @override
  String get documentation => 'Dokumentasjon';

  @override
  String get privacyPolicy => 'Retningslinjer for personvern';

  @override
  String get imprint => 'Avtrykk';

  @override
  String get releaseNotes => 'Utgivelsesnotater';

  @override
  String get changelog => 'Endringslogg';

  @override
  String get legal => 'Juridisk';

  @override
  String get personalization => 'Personalisering';

  @override
  String get design => 'Utforming';

  @override
  String get language => 'Språk';

  @override
  String get theme => 'Tema';

  @override
  String get classic => 'Klassisk';

  @override
  String get systemDefault => 'Standard system';

  @override
  String get light => 'Lys';

  @override
  String get dark => 'Mørk';

  @override
  String get createResource => 'Opprett ressurs';

  @override
  String get cancel => 'Avbryt';

  @override
  String get name => 'Navn';

  @override
  String get description => 'Beskrivelse';

  @override
  String get start => 'Begynn';

  @override
  String get next => 'Neste';

  @override
  String get skip => 'Hopp';

  @override
  String get back => 'Tilbake';

  @override
  String get today => 'Idag';

  @override
  String get groups => 'Grupper';

  @override
  String get createGroup => 'Opprett gruppe';

  @override
  String get editGroup => 'Rediger gruppe';

  @override
  String get list => 'Liste';

  @override
  String get day => 'Dag';

  @override
  String get week => 'Uke';

  @override
  String get month => 'Måned';

  @override
  String get version => 'Versjon';

  @override
  String get intro => 'Introduksjon';

  @override
  String get caldavDescription =>
      'CalDAV-grensesnittet gir deg tilgang til dine data fra hvilken som helst CalDAV-server. Det har begrenset støtte og bare grunnleggende funksjoner støttes. Du kan bruke den for å synkronisere dataene med andre enheter og tjenester.';

  @override
  String get webdavDescription =>
      'WebDAV-grensesnittet gir deg tilgang til data fra en hvilken som helst WebDAV-server. Den filer og kataloger for å lagre data. Du kan bruke den for å synkronisere dataene med andre enheter eller tjenester.';

  @override
  String get server => 'Tjener';

  @override
  String get serverDescription =>
      'Synkroniser dataene dine med en naturlig Linewood Flow server. Dette er anbefalt for brukere som vil selv-arrangere dataene.';

  @override
  String get googleDescription =>
      'Synkroniser dataene dine med Google. Dette anbefales for brukere som vil bruke Google-kontoen sin for å få tilgang til dataene. Ikke alle funksjoner er tilgjengelige med dette alternativet.';

  @override
  String get microsoftDescription =>
      'Synkroniser data med Microsoft. Dette anbefales for brukere som vil bruke Microsoft-kontoen for å få tilgang til dataene sine. Ikke alle funksjoner er tilgjengelige med dette alternativet.';

  @override
  String get addSource => 'Legg til kilde';

  @override
  String get local => 'Lokal';

  @override
  String get close => 'Lukk';

  @override
  String get unknown => 'Ukjent';

  @override
  String get loading => 'Laster';

  @override
  String get export => 'Eksporter';

  @override
  String get createEvent => 'Opprett hendelse';

  @override
  String get save => 'Lagre';

  @override
  String get allSources => 'Alle kilder';

  @override
  String get editEvent => 'Rediger hendelse';

  @override
  String get end => 'Slutt';

  @override
  String get location => 'Sted';

  @override
  String get status => 'Status:';

  @override
  String get confirmed => 'Bekreftet';

  @override
  String get draft => 'Utkast';

  @override
  String get cancelled => 'Avbrutt';

  @override
  String get general => 'Generelt';

  @override
  String get notes => 'Notater';

  @override
  String get createNote => 'Opprett notat';

  @override
  String get editNote => 'Rediger notat';

  @override
  String get indicatorEmpty => 'Ingen produkter funnet';

  @override
  String get indicatorEmptyDescription => 'Listen er for øyeblikket tom.';

  @override
  String get indicatorLoading => 'Laster';

  @override
  String get indicatorError => 'En feil oppstod';

  @override
  String get indicatorErrorDescription =>
      'Det oppstod en feil under lasting av data.';

  @override
  String get tryAgain => 'Prøv igjen';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event på $date klokken $time i $location ($status)';
  }

  @override
  String get filter => 'Filtrer';

  @override
  String get done => 'Ferdig';

  @override
  String get inProgress => 'Under arbeid';

  @override
  String get note => 'Notat';

  @override
  String get delete => 'Slett';

  @override
  String get edit => 'Rediger';

  @override
  String deleteGroup(String name) {
    return 'Slett gruppen $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Er du sikker på at du vil slette gruppen $name?';
  }

  @override
  String groupName(String name) {
    return 'Gruppe $name';
  }

  @override
  String get noData => 'Det er ingen data å vise.';

  @override
  String get noEvents => 'Det er ingen hendelser å vise.';

  @override
  String get group => 'Gruppe';

  @override
  String get search => 'Søk';

  @override
  String get events => 'Hendelser';

  @override
  String get past => 'Tidligere';

  @override
  String get decentralized => 'Desentralisert';

  @override
  String get decentralizedDescription =>
      'Det desentraliserte grensesnittet gir deg tilgang til dine data fra en desentralisert server. Du kan bruke den for å synkronisere dataene med andre enheter eller tjenester.';

  @override
  String get importFile => 'Importer fil';

  @override
  String get importFileDescription =>
      'Importer en fil fra enheten. Du kan importere en databasefil fra en annen Linwood Flow forekomst eller en vanlig kalenderfil.';

  @override
  String get icalDescription =>
      'iCal grensesnittet gir deg tilgang til dine data fra hvilken som helst iCal server. Den kan bare lese data og støtter ikke skriving. Du kan bruke dem til å synkronisere dataene med andre enheter eller tjenester som ikke støtter CalDAV.';

  @override
  String get resource => 'Ressurs';

  @override
  String get editResource => 'Rediger ressurs';

  @override
  String deleteResource(String name) {
    return 'Slett ressurs $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Er du sikker på at du vil slette ressursen $name?';
  }

  @override
  String get priority => 'Prioritet';

  @override
  String get assignEvent => 'Tilordne hendelse';

  @override
  String get noEvent => 'Ingen hendelse';

  @override
  String get parentGroup => 'Overordnet gruppe';

  @override
  String deleteUser(String name) {
    return 'Slett brukeren $name';
  }

  @override
  String get createUser => 'Opprett bruker';

  @override
  String get editUser => 'Rediger bruker';

  @override
  String deleteUserDescription(String name) {
    return 'Er du sikker på at du vil slette bruker $name?';
  }

  @override
  String get pending => 'Ventende';

  @override
  String get removeEvent => 'Fjern hendelse';

  @override
  String get event => 'Hendelse';

  @override
  String get nativeTitleBar => 'Native tittellinjen';

  @override
  String get blocked => 'Blokkert';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count eventer',
      one: '1 hendelse',
      zero: 'Ingen hendelser',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importer';

  @override
  String get confirmImport => 'Er du sikker på at du vil importere den?';

  @override
  String get welcome => 'Velkommen';

  @override
  String get url => 'Nettadresse';

  @override
  String get username => 'Brukernavn';

  @override
  String get password => 'Passord';

  @override
  String get connect => 'Nettverk';

  @override
  String get data => 'Data';

  @override
  String get syncing => 'Synkroniserer';

  @override
  String get synced => 'Synkronisert';

  @override
  String get error => 'Feil';

  @override
  String get always => 'Alltid';

  @override
  String get noMobile => 'Ingen mobil';

  @override
  String get manual => 'Manuell';

  @override
  String get syncMode => 'Synk modus';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Avtale';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Tid';

  @override
  String deleteEvent(String name) {
    return 'Slett hendelsen $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Er du sikker på at du vil slette hendelsen $name?';
  }

  @override
  String get createAppointment => 'Opprett aktivitet';

  @override
  String get editAppointment => 'Rediger aktivitet';

  @override
  String get createMoment => 'Opprett øyeblikk';

  @override
  String get editMoment => 'Rediger øyeblikk';

  @override
  String get convertToNote => 'Konverter til notat';

  @override
  String get convertToTodo => 'Konverter til todo';

  @override
  String get open => 'Åpne';

  @override
  String get limited => 'Begrenset';

  @override
  String get notSet => 'Ikke angitt';

  @override
  String get createPending => 'Opprett ventende';

  @override
  String get editPending => 'Rediger ventende';

  @override
  String get convertTo => 'Konverter til';

  @override
  String get comingSoon => 'Kommer snart';

  @override
  String get notSupported => 'Støttes ikke';

  @override
  String get databaseVersion => 'Database versjon';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Gjenopprett';

  @override
  String get markdownIsSupported => 'Markdown støttes ikke';

  @override
  String get createLabel => 'Opprett etikett';

  @override
  String get editLabel => 'Rediger etikett';

  @override
  String deleteLabel(String name) {
    return 'Slett etikett $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Er du sikker på at du vil slette etiketten $name?';
  }

  @override
  String get label => 'Etikett';

  @override
  String get startOfWeek => 'Start på uken';

  @override
  String headlineNumber(int number) {
    return 'Overskrift $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Gjennomstreking';

  @override
  String get code => 'Kode';

  @override
  String get link => 'Lenke';

  @override
  String get codeBlock => 'Kode blokk';

  @override
  String get quote => 'Sitat';

  @override
  String get numberedList => 'Nummerert liste';

  @override
  String get density => 'Tetthet';

  @override
  String get compact => 'Kompakt';

  @override
  String get comfortable => 'Komfortabel';

  @override
  String get standard => 'Vanlig';

  @override
  String get highContrast => 'Høy kontrast';

  @override
  String get labels => 'Etiketter';

  @override
  String get systemLocale => 'System nasjonale innstillinger';

  @override
  String get notebooks => 'Notatbøker';

  @override
  String get createNotebook => 'Opprett notatbok';

  @override
  String get editNotebook => 'Rediger notatbok';

  @override
  String get update => 'Oppdater';

  @override
  String get currentVersion => 'Gjeldende versjon';

  @override
  String get checkForUpdates => 'Se etter oppdateringer';

  @override
  String get checkForUpdatesWarning =>
      'Utføre en sjekk for oppdateringer vil koble til Flow nettsiden for å få informasjonen.';

  @override
  String get usingLatestStable => 'Du bruker den nyeste stabile versjonen';

  @override
  String get usingLatestNightly => 'Du bruker den siste nattlige versjonen';

  @override
  String get updateNow => 'Oppdater nå';

  @override
  String get stable => 'Stabil';

  @override
  String get nightly => 'Nattlig';

  @override
  String get updateAvailable => 'Oppdatering tilgjengelig';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '1 item',
      zero: 'No items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'System tema';

  @override
  String get desktop => 'Skrivebord';

  @override
  String get restoreSettingsFromFile => 'Gjenopprett innstillinger fra fil';

  @override
  String get exportSettingsToFile => 'Eksporter innstillinger til fil';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Aktivert';

  @override
  String get countdown => 'Nedtelling';

  @override
  String get unlink => 'Frakoble';

  @override
  String get noAlarms => 'Det finnes ingen alarmer som skal vises.';

  @override
  String get allDay => 'Hele dagen';
}
