// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Korean (`ko`).
class AppLocalizationsKo extends AppLocalizations {
  AppLocalizationsKo([String locale = 'ko']) : super(locale);

  @override
  String get dashboard => 'Dashboard';

  @override
  String get translate => '번역';

  @override
  String get calendar => 'Calendar';

  @override
  String get resources => 'Resources';

  @override
  String get users => '사용자';

  @override
  String get user => 'User';

  @override
  String get sources => 'Sources';

  @override
  String get settings => '설정';

  @override
  String get create => 'Create';

  @override
  String get information => '정보';

  @override
  String get source => '소스';

  @override
  String get license => '라이선스';

  @override
  String get thirdPartyLicenses => 'Third Party Licenses';

  @override
  String get documentation => '문서';

  @override
  String get privacyPolicy => 'Privacy Policy';

  @override
  String get imprint => '제작 정보';

  @override
  String get releaseNotes => 'Release Notes';

  @override
  String get changelog => '변경 로그';

  @override
  String get legal => 'Legal';

  @override
  String get personalization => '개인화';

  @override
  String get design => '디자인';

  @override
  String get language => 'Language';

  @override
  String get theme => '테마';

  @override
  String get classic => 'Classic';

  @override
  String get systemDefault => 'System Default';

  @override
  String get light => '밝음';

  @override
  String get dark => '어두움';

  @override
  String get createResource => 'Create resource';

  @override
  String get cancel => 'Cancel';

  @override
  String get name => 'Name';

  @override
  String get description => '설명';

  @override
  String get start => '시작';

  @override
  String get next => 'Next';

  @override
  String get skip => 'Skip';

  @override
  String get back => '뒤로';

  @override
  String get today => 'Today';

  @override
  String get groups => 'Groups';

  @override
  String get createGroup => 'Create group';

  @override
  String get editGroup => 'Edit group';

  @override
  String get list => 'List';

  @override
  String get day => 'Day';

  @override
  String get week => 'Week';

  @override
  String get month => 'Month';

  @override
  String get version => '버전';

  @override
  String get intro => 'Intro';

  @override
  String get caldavDescription =>
      'The CalDAV interface allows you to access your data from any CalDAV server. It has limited support and only basic functions are supported. You can use it to synchronize your data with other devices or services.';

  @override
  String get webdavDescription =>
      'The WebDAV interface allows you to access your data from any WebDAV server. It files and directories to store data. You can use it to synchronize your data with other devices or services.';

  @override
  String get server => '서버';

  @override
  String get serverDescription =>
      'Sync your data with a native Linwood Flow server. This is recommended for users that want to self-host their data.';

  @override
  String get googleDescription =>
      'Sync your data with Google. This is recommended for users that want to use their Google account to access their data. Not all features are available with this option.';

  @override
  String get microsoftDescription =>
      'Sync your data with Microsoft. This is recommended for users that want to use their Microsoft account to access their data. Not all features are available with this option.';

  @override
  String get addSource => 'Add source';

  @override
  String get local => '로컬';

  @override
  String get close => 'Close';

  @override
  String get unknown => 'Unknown';

  @override
  String get loading => 'Loading';

  @override
  String get export => '내보내기';

  @override
  String get createEvent => 'Create event';

  @override
  String get save => '저장';

  @override
  String get allSources => 'All sources';

  @override
  String get editEvent => 'Edit event';

  @override
  String get end => 'End';

  @override
  String get location => '위치';

  @override
  String get status => 'Status';

  @override
  String get confirmed => 'Confirmed';

  @override
  String get draft => 'Draft';

  @override
  String get cancelled => 'Cancelled';

  @override
  String get general => '일반';

  @override
  String get notes => 'Notes';

  @override
  String get createNote => 'Create note';

  @override
  String get editNote => 'Edit note';

  @override
  String get indicatorEmpty => 'No items found';

  @override
  String get indicatorEmptyDescription => 'The list is currently empty.';

  @override
  String get indicatorLoading => 'Loading';

  @override
  String get indicatorError => 'An error occurred';

  @override
  String get indicatorErrorDescription =>
      'An error occurred while loading the data.';

  @override
  String get tryAgain => 'Try again';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event on $date at $time in $location ($status)';
  }

  @override
  String get filter => 'Filter';

  @override
  String get done => 'Done';

  @override
  String get inProgress => 'In progress';

  @override
  String get note => '노트';

  @override
  String get delete => '삭제';

  @override
  String get edit => '편집';

  @override
  String deleteGroup(String name) {
    return 'Delete group $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Are you sure you want to delete the group $name?';
  }

  @override
  String groupName(String name) {
    return 'Group $name';
  }

  @override
  String get noData => 'There is no data to display.';

  @override
  String get noEvents => 'There are no events to display.';

  @override
  String get group => 'Group';

  @override
  String get search => '검색';

  @override
  String get events => 'Events';

  @override
  String get past => 'Past';

  @override
  String get decentralized => 'Decentralized';

  @override
  String get decentralizedDescription =>
      'The decentralized interface allows you to access your data from any decentralized server. You can use it to synchronize your data with other devices or services.';

  @override
  String get importFile => 'Import file';

  @override
  String get importFileDescription =>
      'Import a file from your device. You can import a database file from another Linwood Flow instance or a regular calendar file.';

  @override
  String get icalDescription =>
      'The iCal interface allows you to access your data from any iCal server. It can only read data and does not support writing. You can use it to synchronize your data with other devices or services that do not support CalDAV.';

  @override
  String get resource => 'Resource';

  @override
  String get editResource => 'Edit resource';

  @override
  String deleteResource(String name) {
    return 'Delete resource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Are you sure you want to delete the resource $name?';
  }

  @override
  String get priority => 'Priority';

  @override
  String get assignEvent => 'Assign event';

  @override
  String get noEvent => 'No event';

  @override
  String get parentGroup => 'Parent group';

  @override
  String deleteUser(String name) {
    return 'Delete user $name';
  }

  @override
  String get createUser => 'Create user';

  @override
  String get editUser => 'Edit user';

  @override
  String deleteUserDescription(String name) {
    return 'Are you sure you want to delete the user $name?';
  }

  @override
  String get pending => 'Pending';

  @override
  String get removeEvent => 'Remove event';

  @override
  String get event => 'Event';

  @override
  String get nativeTitleBar => '네이티브 제목 표시줄';

  @override
  String get blocked => 'Blocked';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count events',
      one: '1 event',
      zero: 'No events',
    );
    return '$_temp0';
  }

  @override
  String get import => '가져오기';

  @override
  String get confirmImport => 'Are you sure you want to import it?';

  @override
  String get welcome => 'Welcome';

  @override
  String get url => 'URL';

  @override
  String get username => '사용자 이름';

  @override
  String get password => '비밀번호';

  @override
  String get connect => '연결';

  @override
  String get data => '데이터';

  @override
  String get syncing => 'Syncing';

  @override
  String get synced => '동기화됨';

  @override
  String get error => '오류';

  @override
  String get always => '항상';

  @override
  String get noMobile => '모바일 제외';

  @override
  String get manual => '수동';

  @override
  String get syncMode => '동기화 모드';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Appointment';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Time';

  @override
  String deleteEvent(String name) {
    return 'Delete event $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Are you sure you want to delete the event $name?';
  }

  @override
  String get createAppointment => 'Create appointment';

  @override
  String get editAppointment => 'Edit appointment';

  @override
  String get createMoment => 'Create moment';

  @override
  String get editMoment => 'Edit moment';

  @override
  String get convertToNote => 'Convert to note';

  @override
  String get convertToTodo => 'Convert to todo';

  @override
  String get open => '열기';

  @override
  String get limited => 'Limited';

  @override
  String get notSet => '설정 안 됨';

  @override
  String get createPending => 'Create pending';

  @override
  String get editPending => 'Edit pending';

  @override
  String get convertTo => 'Convert to';

  @override
  String get comingSoon => 'Coming soon';

  @override
  String get notSupported => 'Not supported';

  @override
  String get databaseVersion => 'Database version';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Restore';

  @override
  String get markdownIsSupported => 'Markdown is supported';

  @override
  String get createLabel => 'Create label';

  @override
  String get editLabel => 'Edit label';

  @override
  String deleteLabel(String name) {
    return 'Delete label $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Are you sure you want to delete the label $name?';
  }

  @override
  String get label => '레이블';

  @override
  String get startOfWeek => 'Start of week';

  @override
  String headlineNumber(int number) {
    return '헤드라인 $number';
  }

  @override
  String get bold => '굵게';

  @override
  String get italic => '기울임꼴';

  @override
  String get strikethrough => '취소선';

  @override
  String get code => '코드';

  @override
  String get link => '링크';

  @override
  String get codeBlock => 'Code block';

  @override
  String get quote => '인용';

  @override
  String get numberedList => 'Numbered list';

  @override
  String get density => '밀도';

  @override
  String get compact => '좁게';

  @override
  String get comfortable => '편안하게';

  @override
  String get standard => '표준';

  @override
  String get highContrast => '고대비';

  @override
  String get labels => 'Labels';

  @override
  String get systemLocale => '시스템 언어';

  @override
  String get notebooks => 'Notebooks';

  @override
  String get createNotebook => 'Create notebook';

  @override
  String get editNotebook => 'Edit notebook';

  @override
  String get update => '업데이트';

  @override
  String get currentVersion => '현재 버전';

  @override
  String get checkForUpdates => '업데이트 확인';

  @override
  String get checkForUpdatesWarning =>
      'Performing a check for updates will connect to the Flow website to get the information.';

  @override
  String get usingLatestStable => '최신 안정 버전을 사용하고 있습니다';

  @override
  String get usingLatestNightly => '최신 나이틀리 버전을 사용하고 있습니다';

  @override
  String get updateNow => '지금 업데이트';

  @override
  String get stable => '안정';

  @override
  String get nightly => '나이틀리';

  @override
  String get updateAvailable => '업데이트 가능';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '1 item',
      zero: 'No items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'System theme';

  @override
  String get desktop => '데스크톱';

  @override
  String get restoreSettingsFromFile => '파일에서 설정 복원';

  @override
  String get exportSettingsToFile => '설정을 파일로 내보내기';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Enabled';

  @override
  String get countdown => 'Countdown';

  @override
  String get unlink => 'Unlink';

  @override
  String get noAlarms => 'There are no alarms to display.';

  @override
  String get allDay => 'All day';
}
