// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Italian (`it`).
class AppLocalizationsIt extends AppLocalizations {
  AppLocalizationsIt([String locale = 'it']) : super(locale);

  @override
  String get dashboard => 'Dashboard';

  @override
  String get translate => 'Trasla';

  @override
  String get calendar => 'Calendario';

  @override
  String get resources => 'Risorse';

  @override
  String get users => 'Utenti';

  @override
  String get user => 'Utente';

  @override
  String get sources => 'Sorgenti';

  @override
  String get settings => 'Impostazioni';

  @override
  String get create => 'Crea';

  @override
  String get information => 'Informazioni';

  @override
  String get source => 'Fonte';

  @override
  String get license => 'Licenza';

  @override
  String get thirdPartyLicenses => 'Licenze Terze Parti';

  @override
  String get documentation => 'Documentazione';

  @override
  String get privacyPolicy => 'Politica Sulla Privacy';

  @override
  String get imprint => 'Imprint';

  @override
  String get releaseNotes => 'Note Di Rilascio';

  @override
  String get changelog => 'Changelog';

  @override
  String get legal => 'Legale';

  @override
  String get personalization => 'Personalizzazione';

  @override
  String get design => 'Design';

  @override
  String get language => 'Lingua';

  @override
  String get theme => 'Tema';

  @override
  String get classic => 'Classico';

  @override
  String get systemDefault => 'Predefinito Di Sistema';

  @override
  String get light => 'Chiaro';

  @override
  String get dark => 'Scuro';

  @override
  String get createResource => 'Crea risorsa';

  @override
  String get cancel => 'Annulla';

  @override
  String get name => 'Nome';

  @override
  String get description => 'Descrizione';

  @override
  String get start => 'Inizia';

  @override
  String get next => 'Successivo';

  @override
  String get skip => 'Salta';

  @override
  String get back => 'Indietro';

  @override
  String get today => 'Oggi';

  @override
  String get groups => 'Gruppi';

  @override
  String get createGroup => 'Crea gruppo';

  @override
  String get editGroup => 'Modifica gruppo';

  @override
  String get list => 'Elenco';

  @override
  String get day => 'Giorno';

  @override
  String get week => 'Settimana';

  @override
  String get month => 'Mese';

  @override
  String get version => 'Versione';

  @override
  String get intro => 'Introduzione';

  @override
  String get caldavDescription =>
      'L\'interfaccia CalDAV consente di accedere ai dati da qualsiasi server CalDAV. Ha un supporto limitato e sono supportate solo le funzioni di base. È possibile utilizzarlo per sincronizzare i dati con altri dispositivi o servizi.';

  @override
  String get webdavDescription =>
      'L\'interfaccia WebDAV consente di accedere ai dati da qualsiasi server WebDAV. File e directory per memorizzare i dati. È possibile utilizzarli per sincronizzare i dati con altri dispositivi o servizi.';

  @override
  String get server => 'Server';

  @override
  String get serverDescription =>
      'Sincronizza i tuoi dati con un server di Linwood Flow nativo. Questo è raccomandato per gli utenti che vogliono auto-ospitare i loro dati.';

  @override
  String get googleDescription =>
      'Sincronizza i tuoi dati con Google. Questo è raccomandato per gli utenti che desiderano utilizzare il loro account Google per accedere ai loro dati. Non tutte le funzionalità sono disponibili con questa opzione.';

  @override
  String get microsoftDescription =>
      'Sincronizza i tuoi dati con Microsoft. Questo è raccomandato per gli utenti che desiderano utilizzare il loro account Microsoft per accedere ai loro dati. Non tutte le funzionalità sono disponibili con questa opzione.';

  @override
  String get addSource => 'Aggiungi sorgente';

  @override
  String get local => 'Locale';

  @override
  String get close => 'Chiudi';

  @override
  String get unknown => 'Sconosciuto';

  @override
  String get loading => 'Caricamento';

  @override
  String get export => 'Esporta';

  @override
  String get createEvent => 'Crea evento';

  @override
  String get save => 'Salva';

  @override
  String get allSources => 'Tutte le fonti';

  @override
  String get editEvent => 'Modifica evento';

  @override
  String get end => 'Fine';

  @override
  String get location => 'Posizione';

  @override
  String get status => 'Stato';

  @override
  String get confirmed => 'Confermato';

  @override
  String get draft => 'Bozza';

  @override
  String get cancelled => 'Annullato';

  @override
  String get general => 'Generale';

  @override
  String get notes => 'Note';

  @override
  String get createNote => 'Crea nota';

  @override
  String get editNote => 'Modifica nota';

  @override
  String get indicatorEmpty => 'Nessun elemento trovato';

  @override
  String get indicatorEmptyDescription => 'La lista è attualmente vuota.';

  @override
  String get indicatorLoading => 'Caricamento';

  @override
  String get indicatorError => 'Si è verificato un errore';

  @override
  String get indicatorErrorDescription =>
      'Si è verificato un errore durante il caricamento dei dati.';

  @override
  String get tryAgain => 'Riprova';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event il $date alle $time in $location ($status)';
  }

  @override
  String get filter => 'Filtro';

  @override
  String get done => 'Fatto';

  @override
  String get inProgress => 'In corso';

  @override
  String get note => 'Nota';

  @override
  String get delete => 'Elimina';

  @override
  String get edit => 'Modifica';

  @override
  String deleteGroup(String name) {
    return 'Elimina gruppo $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Sei sicuro di voler eliminare il gruppo $name?';
  }

  @override
  String groupName(String name) {
    return 'Gruppo $name';
  }

  @override
  String get noData => 'Non ci sono dati da visualizzare.';

  @override
  String get noEvents => 'Non ci sono eventi da visualizzare.';

  @override
  String get group => 'Gruppo';

  @override
  String get search => 'Cerca';

  @override
  String get events => 'Eventi';

  @override
  String get past => 'Passato';

  @override
  String get decentralized => 'Decentralizzato';

  @override
  String get decentralizedDescription =>
      'L\'interfaccia decentralizzata consente di accedere ai dati da qualsiasi server decentralizzato. È possibile utilizzarlo per sincronizzare i dati con altri dispositivi o servizi.';

  @override
  String get importFile => 'Importa file';

  @override
  String get importFileDescription =>
      'Importa un file dal tuo dispositivo. Puoi importare un file di database da un\'altra istanza di Linwood Flow o da un normale file di calendario.';

  @override
  String get icalDescription =>
      'L\'interfaccia iCal ti permette di accedere ai tuoi dati da qualsiasi server iCal. Può leggere solo i dati e non supporta la scrittura. È possibile utilizzarlo per sincronizzare i dati con altri dispositivi o servizi che non supportano CalDAV.';

  @override
  String get resource => 'Risorsa';

  @override
  String get editResource => 'Modifica risorsa';

  @override
  String deleteResource(String name) {
    return 'Delete resource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Sei sicuro di voler eliminare la risorsa $name?';
  }

  @override
  String get priority => 'Priorità';

  @override
  String get assignEvent => 'Assegna evento';

  @override
  String get noEvent => 'Nessun evento';

  @override
  String get parentGroup => 'Gruppo genitore';

  @override
  String deleteUser(String name) {
    return 'Elimina utente $name';
  }

  @override
  String get createUser => 'Crea utente';

  @override
  String get editUser => 'Modifica utente';

  @override
  String deleteUserDescription(String name) {
    return 'Sei sicuro di voler eliminare l\'utente $name?';
  }

  @override
  String get pending => 'In Attesa';

  @override
  String get removeEvent => 'Rimuovi evento';

  @override
  String get event => 'Evento';

  @override
  String get nativeTitleBar => 'Barra del titolo nativo';

  @override
  String get blocked => 'Bloccato';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count eventi',
      one: '1 evento',
      zero: 'Nessun evento',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importa';

  @override
  String get confirmImport => 'Sei sicuro di volerlo importare?';

  @override
  String get welcome => 'Benvenuto';

  @override
  String get url => 'URL';

  @override
  String get username => 'Username';

  @override
  String get password => 'Password';

  @override
  String get connect => 'Connetti';

  @override
  String get data => 'Dati';

  @override
  String get syncing => 'Sincronizzazione';

  @override
  String get synced => 'Sincronizzato';

  @override
  String get error => 'Errore';

  @override
  String get always => 'Sempre';

  @override
  String get noMobile => 'Nessun cellulare';

  @override
  String get manual => 'Manuale';

  @override
  String get syncMode => 'Modalità sincronizzazione';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Nomina';

  @override
  String get moment => 'Momento';

  @override
  String get time => 'Tempo';

  @override
  String deleteEvent(String name) {
    return 'Elimina evento $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Sei sicuro di voler eliminare l\'evento $name?';
  }

  @override
  String get createAppointment => 'Crea appuntamento';

  @override
  String get editAppointment => 'Modifica appuntamento';

  @override
  String get createMoment => 'Crea momento';

  @override
  String get editMoment => 'Modifica momento';

  @override
  String get convertToNote => 'Converti in nota';

  @override
  String get convertToTodo => 'Converti in todo';

  @override
  String get open => 'Apri';

  @override
  String get limited => 'Limitato';

  @override
  String get notSet => 'Non impostato';

  @override
  String get createPending => 'Crea in sospeso';

  @override
  String get editPending => 'Modifica in sospeso';

  @override
  String get convertTo => 'Converti in';

  @override
  String get comingSoon => 'In arrivo';

  @override
  String get notSupported => 'Non supportato';

  @override
  String get databaseVersion => 'Versione del database';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Ripristina';

  @override
  String get markdownIsSupported => 'Markdown supportato';

  @override
  String get createLabel => 'Crea etichetta';

  @override
  String get editLabel => 'Modifica etichetta';

  @override
  String deleteLabel(String name) {
    return 'Elimina etichetta $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Sei sicuro di voler eliminare l\'etichetta $name?';
  }

  @override
  String get label => 'Etichetta';

  @override
  String get startOfWeek => 'Inizio settimana';

  @override
  String headlineNumber(int number) {
    return 'Titolo $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Barrato';

  @override
  String get code => 'Codice';

  @override
  String get link => 'Link';

  @override
  String get codeBlock => 'Blocco codice';

  @override
  String get quote => 'Preventivo';

  @override
  String get numberedList => 'Elenco numerato';

  @override
  String get density => 'Densità';

  @override
  String get compact => 'Compatto';

  @override
  String get comfortable => 'Confortevole';

  @override
  String get standard => 'Standard';

  @override
  String get highContrast => 'Alto contrasto';

  @override
  String get labels => 'Etichette';

  @override
  String get systemLocale => 'Localizzazione di sistema';

  @override
  String get notebooks => 'Taccuini';

  @override
  String get createNotebook => 'Crea taccuino';

  @override
  String get editNotebook => 'Modifica taccuino';

  @override
  String get update => 'Aggiorna';

  @override
  String get currentVersion => 'Versione attuale';

  @override
  String get checkForUpdates => 'Controlla aggiornamenti';

  @override
  String get checkForUpdatesWarning =>
      'Effettuando un controllo per gli aggiornamenti si collegherà al sito web di Flusso per ottenere le informazioni.';

  @override
  String get usingLatestStable => 'Stai usando l\'ultima versione stabile';

  @override
  String get usingLatestNightly => 'Stai usando l\'ultima versione nightly';

  @override
  String get updateNow => 'Aggiorna ora';

  @override
  String get stable => 'Stabile';

  @override
  String get nightly => 'Notte';

  @override
  String get updateAvailable => 'Aggiornamento disponibile';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elementi',
      one: '1 elemento',
      zero: 'Nessun elemento',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Tema di sistema';

  @override
  String get desktop => 'Desktop';

  @override
  String get restoreSettingsFromFile => 'Ripristina le impostazioni dal file';

  @override
  String get exportSettingsToFile => 'Esporta le impostazioni su file';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Abilitato';

  @override
  String get countdown => 'Conto Alla rovescia';

  @override
  String get unlink => 'Scollega';

  @override
  String get noAlarms => 'Non ci sono allarmi da visualizzare.';

  @override
  String get allDay => 'Tutto il giorno';
}
