// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Finnish (`fi`).
class AppLocalizationsFi extends AppLocalizations {
  AppLocalizationsFi([String locale = 'fi']) : super(locale);

  @override
  String get dashboard => 'Hallintapaneeli';

  @override
  String get translate => 'Käännä';

  @override
  String get calendar => 'Kalenteri';

  @override
  String get resources => 'Resurssit';

  @override
  String get users => 'Käyttäjät';

  @override
  String get user => 'Käyttäjä';

  @override
  String get sources => 'Lähteet';

  @override
  String get settings => 'Asetukset';

  @override
  String get create => 'Luo';

  @override
  String get information => 'Tiedot';

  @override
  String get source => 'Lähde';

  @override
  String get license => 'Lisenssi';

  @override
  String get thirdPartyLicenses => 'Kolmannen Osapuolen Lisenssit';

  @override
  String get documentation => 'Dokumentaatio';

  @override
  String get privacyPolicy => 'Yksityisyyden Suoja';

  @override
  String get imprint => 'Jälki';

  @override
  String get releaseNotes => 'Julkaise Muistiinpanot';

  @override
  String get changelog => 'Muutosloki';

  @override
  String get legal => 'Oikeudellinen';

  @override
  String get personalization => 'Mukauttaminen';

  @override
  String get design => 'Ulkoasu';

  @override
  String get language => 'Kieli';

  @override
  String get theme => 'Teema';

  @override
  String get classic => 'Klassinen';

  @override
  String get systemDefault => 'Järjestelmän Oletus';

  @override
  String get light => 'Vaalea';

  @override
  String get dark => 'Tumma';

  @override
  String get createResource => 'Luo resurssi';

  @override
  String get cancel => 'Peruuta';

  @override
  String get name => 'Nimi';

  @override
  String get description => 'Kuvaus';

  @override
  String get start => 'Aloita';

  @override
  String get next => 'Seuraava';

  @override
  String get skip => 'Ohita';

  @override
  String get back => 'Takaisin';

  @override
  String get today => 'Tänään';

  @override
  String get groups => 'Ryhmät';

  @override
  String get createGroup => 'Luo ryhmä';

  @override
  String get editGroup => 'Muokkaa ryhmää';

  @override
  String get list => 'Lista';

  @override
  String get day => 'Päivä';

  @override
  String get week => 'Viikko';

  @override
  String get month => 'Kuukausi';

  @override
  String get version => 'Versio';

  @override
  String get intro => 'Esittely';

  @override
  String get caldavDescription =>
      'CalDAV käyttöliittymän avulla voit käyttää tietoja tahansa CalDAV palvelimen. Se on rajoitettu tuki ja vain perustoiminnot ovat tuettuja. Voit käyttää sitä synkronoidaksesi dataa muiden laitteiden tai palveluiden kanssa.';

  @override
  String get webdavDescription =>
      'WebDAV käyttöliittymän avulla voit käyttää tietoja tahansa WebDAV palvelimella. Se tiedostoja ja hakemistoja tallentaa tietoja. Voit käyttää sitä synkronoida tietoja muiden laitteiden tai palvelujen kanssa.';

  @override
  String get server => 'Palvelin';

  @override
  String get serverDescription =>
      'Synkronoi tietosi natiivin Linwood Flow palvelimen kanssa. Tätä suositellaan käyttäjille, jotka haluavat itse isännöidä tietojaan.';

  @override
  String get googleDescription =>
      'Synkronoi tietosi Googlen kanssa. Tämä on suositeltavaa käyttäjille, jotka haluavat käyttää Google-tiliään päästäkseen käsiksi tietoihinsa. Kaikki ominaisuudet eivät ole käytettävissä tällä asetuksella.';

  @override
  String get microsoftDescription =>
      'Synkronoi tietosi Microsoftin kanssa. Tämä on suositeltavaa käyttäjille, jotka haluavat käyttää Microsoft-tiliään päästäkseen käsiksi tietoihinsa. Kaikki ominaisuudet eivät ole käytettävissä tällä asetuksella.';

  @override
  String get addSource => 'Lisää lähde';

  @override
  String get local => 'Paikallinen';

  @override
  String get close => 'Sulje';

  @override
  String get unknown => 'Tuntematon';

  @override
  String get loading => 'Ladataan';

  @override
  String get export => 'Vie';

  @override
  String get createEvent => 'Luo tapahtuma';

  @override
  String get save => 'Tallenna';

  @override
  String get allSources => 'Kaikki lähteet';

  @override
  String get editEvent => 'Muokkaa tapahtumaa';

  @override
  String get end => 'Loppu';

  @override
  String get location => 'Sijainti';

  @override
  String get status => 'Tila';

  @override
  String get confirmed => 'Vahvistettu';

  @override
  String get draft => 'Luonnos';

  @override
  String get cancelled => 'Peruutettu';

  @override
  String get general => 'Yleiset';

  @override
  String get notes => 'Muistiinpanot';

  @override
  String get createNote => 'Luo merkintä';

  @override
  String get editNote => 'Muokkaa merkintää';

  @override
  String get indicatorEmpty => 'Kohteita ei löytynyt';

  @override
  String get indicatorEmptyDescription => 'Luettelo on tällä hetkellä tyhjä.';

  @override
  String get indicatorLoading => 'Ladataan';

  @override
  String get indicatorError => 'Tapahtui virhe';

  @override
  String get indicatorErrorDescription => 'Dataa ladattaessa tapahtui virhe.';

  @override
  String get tryAgain => 'Yritä uudelleen';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event $date klo $time $location ($status)';
  }

  @override
  String get filter => 'Suodatin';

  @override
  String get done => 'Valmis';

  @override
  String get inProgress => 'Toiminto käynnissä';

  @override
  String get note => 'Huomautus';

  @override
  String get delete => 'Poista';

  @override
  String get edit => 'Muokkaa';

  @override
  String deleteGroup(String name) {
    return 'Poista ryhmä $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Oletko varma, että haluat poistaa ryhmän $name?';
  }

  @override
  String groupName(String name) {
    return 'Ryhmä $name';
  }

  @override
  String get noData => 'Tietoja ei ole näytettäväksi.';

  @override
  String get noEvents => 'Ei ole mitään näytettäviä tapahtumia.';

  @override
  String get group => 'Ryhmä';

  @override
  String get search => 'Etsi';

  @override
  String get events => 'Tapahtumat';

  @override
  String get past => 'Menneisyys';

  @override
  String get decentralized => 'Hajautettu';

  @override
  String get decentralizedDescription =>
      'Hajautetun käyttöliittymän avulla voit käyttää tietoja miltä tahansa hajautetulta palvelimelta. Voit käyttää sitä synkronoidaksesi tietosi muiden laitteiden tai palveluiden kanssa.';

  @override
  String get importFile => 'Tuo tiedosto';

  @override
  String get importFileDescription =>
      'Tuo tiedosto laitteestasi. Voit tuoda tietokantatiedoston toisesta Linwood Flow instanssista tai tavallisesta kalenteritiedostosta.';

  @override
  String get icalDescription =>
      'ICal käyttöliittymän avulla voit käyttää tietoja tahansa iCal palvelimella. Se voi vain lukea tietoja ja ei tue kirjoittamista. Voit käyttää sitä synkronoidaksesi dataa muiden laitteiden tai palvelujen kanssa, jotka eivät tue CalDAV:ta.';

  @override
  String get resource => 'Resurssi';

  @override
  String get editResource => 'Muokkaa resurssia';

  @override
  String deleteResource(String name) {
    return 'Poista resurssi $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Oletko varma, että haluat poistaa resurssin $name?';
  }

  @override
  String get priority => 'Prioriteetti';

  @override
  String get assignEvent => 'Määritä tapahtuma';

  @override
  String get noEvent => 'Ei tapahtumaa';

  @override
  String get parentGroup => 'Ylätason ryhmä';

  @override
  String deleteUser(String name) {
    return 'Poista käyttäjä $name';
  }

  @override
  String get createUser => 'Luo käyttäjä';

  @override
  String get editUser => 'Muokkaa käyttäjää';

  @override
  String deleteUserDescription(String name) {
    return 'Oletko varma, että haluat poistaa käyttäjän $name?';
  }

  @override
  String get pending => 'Odottaa';

  @override
  String get removeEvent => 'Poista tapahtuma';

  @override
  String get event => 'Tapahtuma';

  @override
  String get nativeTitleBar => 'Alkuperäinen otsikkopalkki';

  @override
  String get blocked => 'Estetty';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tapahtumia',
      one: '1 tapahtuma',
      zero: 'Ei tapahtumia',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Tuo';

  @override
  String get confirmImport => 'Oletko varma, että haluat tuoda sen?';

  @override
  String get welcome => 'Tervetuloa';

  @override
  String get url => 'URL-osoite';

  @override
  String get username => 'Käyttäjätunnus';

  @override
  String get password => 'Salasana';

  @override
  String get connect => 'Yhdistä';

  @override
  String get data => 'Tiedot';

  @override
  String get syncing => 'Synkronoidaan';

  @override
  String get synced => 'Synkronoitu';

  @override
  String get error => 'Virhe';

  @override
  String get always => 'Aina';

  @override
  String get noMobile => 'Ei matkapuhelinta';

  @override
  String get manual => 'Manuaalinen';

  @override
  String get syncMode => 'Synkronoinnin tila';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Tapaaminen';

  @override
  String get moment => 'Hetki';

  @override
  String get time => 'Aika';

  @override
  String deleteEvent(String name) {
    return 'Poista tapahtuma $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Oletko varma, että haluat poistaa tapahtuman $name?';
  }

  @override
  String get createAppointment => 'Luo tapaaminen';

  @override
  String get editAppointment => 'Muokkaa tapaamista';

  @override
  String get createMoment => 'Luo hetki';

  @override
  String get editMoment => 'Muokkaa hetkeä';

  @override
  String get convertToNote => 'Muunna muistiksi';

  @override
  String get convertToTodo => 'Muunna todoksi';

  @override
  String get open => 'Avaa';

  @override
  String get limited => 'Rajoitettu';

  @override
  String get notSet => 'Ei asetettu';

  @override
  String get createPending => 'Luo odottaa';

  @override
  String get editPending => 'Muokkaa odottavia';

  @override
  String get convertTo => 'Muunna muotoon';

  @override
  String get comingSoon => 'Tulossa pian';

  @override
  String get notSupported => 'Ei tuettu';

  @override
  String get databaseVersion => 'Tietokannan versio';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Palauta';

  @override
  String get markdownIsSupported => 'Markdown on tuettu';

  @override
  String get createLabel => 'Luo tunniste';

  @override
  String get editLabel => 'Muokkaa nimikettä';

  @override
  String deleteLabel(String name) {
    return 'Poista tunniste $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Oletko varma, että haluat poistaa tunnisteen $name?';
  }

  @override
  String get label => 'Tunniste';

  @override
  String get startOfWeek => 'Viikon alku';

  @override
  String headlineNumber(int number) {
    return 'Otsikko $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Yliviivaus';

  @override
  String get code => 'Koodi';

  @override
  String get link => 'Linkki';

  @override
  String get codeBlock => 'Koodilohko';

  @override
  String get quote => 'Tarjous';

  @override
  String get numberedList => 'Numeroitu luettelo';

  @override
  String get density => 'Tiheys';

  @override
  String get compact => 'Kompakti';

  @override
  String get comfortable => 'Mukava';

  @override
  String get standard => 'Normaali';

  @override
  String get highContrast => 'Korkea kontrasti';

  @override
  String get labels => 'Tunnisteet';

  @override
  String get systemLocale => 'Järjestelmän kieli';

  @override
  String get notebooks => 'Muistikirjat';

  @override
  String get createNotebook => 'Luo muistikirja';

  @override
  String get editNotebook => 'Muokkaa muistikirjaa';

  @override
  String get update => 'Päivitä';

  @override
  String get currentVersion => 'Nykyinen versio';

  @override
  String get checkForUpdates => 'Tarkista päivitykset';

  @override
  String get checkForUpdatesWarning =>
      'Tarkistamalla päivityksiä voit ottaa yhteyttä Flow verkkosivustoon saadaksesi tiedot.';

  @override
  String get usingLatestStable => 'Käytät viimeisintä vakaata versiota';

  @override
  String get usingLatestNightly => 'Olet käyttämässä uusinta yöllä versiota';

  @override
  String get updateNow => 'Päivitä nyt';

  @override
  String get stable => 'Vakaa';

  @override
  String get nightly => 'Yöllä';

  @override
  String get updateAvailable => 'Päivitys saatavilla';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count esineitä',
      one: '1 esine',
      zero: 'Ei esineitä',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Järjestelmän teema';

  @override
  String get desktop => 'Työpöytä';

  @override
  String get restoreSettingsFromFile => 'Palauta asetukset tiedostosta';

  @override
  String get exportSettingsToFile => 'Vie asetukset tiedostoon';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Käytössä';

  @override
  String get countdown => 'Lähtölaskenta';

  @override
  String get unlink => 'Irrota';

  @override
  String get noAlarms => 'Ei ole hälytyksiä näytettäväksi.';

  @override
  String get allDay => 'Koko päivä';
}
