// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class AppLocalizationsDe extends AppLocalizations {
  AppLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get dashboard => 'Dashboard';

  @override
  String get translate => 'Übersetzen';

  @override
  String get calendar => 'Kalender';

  @override
  String get resources => 'Ressourcen';

  @override
  String get users => 'Benutzer';

  @override
  String get user => 'Benutzer';

  @override
  String get sources => 'Quellen';

  @override
  String get settings => 'Einstellungen';

  @override
  String get create => 'Anlegen';

  @override
  String get information => 'Informationen';

  @override
  String get source => 'Quelle';

  @override
  String get license => 'Lizenz';

  @override
  String get thirdPartyLicenses => 'Drittlizenzen';

  @override
  String get documentation => 'Dokumentation';

  @override
  String get privacyPolicy => 'Datenschutzerklärung';

  @override
  String get imprint => 'Impressum';

  @override
  String get releaseNotes => 'Versionshinweise';

  @override
  String get changelog => 'Changelog';

  @override
  String get legal => 'Rechtlich';

  @override
  String get personalization => 'Personalisierung';

  @override
  String get design => 'Design';

  @override
  String get language => 'Sprache';

  @override
  String get theme => 'Thema';

  @override
  String get classic => 'Klassisch';

  @override
  String get systemDefault => 'Systemstandard';

  @override
  String get light => 'Hell';

  @override
  String get dark => 'Dunkel';

  @override
  String get createResource => 'Ressource erstellen';

  @override
  String get cancel => 'Abbrechen';

  @override
  String get name => 'Name';

  @override
  String get description => 'Beschreibung';

  @override
  String get start => 'Start';

  @override
  String get next => 'Nächste';

  @override
  String get skip => 'Überspringen';

  @override
  String get back => 'Zurück';

  @override
  String get today => 'Heute';

  @override
  String get groups => 'Gruppen';

  @override
  String get createGroup => 'Gruppe erstellen';

  @override
  String get editGroup => 'Gruppe bearbeiten';

  @override
  String get list => 'Liste';

  @override
  String get day => 'Tag';

  @override
  String get week => 'Woche';

  @override
  String get month => 'Monat';

  @override
  String get version => 'Version';

  @override
  String get intro => 'Einleitung';

  @override
  String get caldavDescription =>
      'Die CalDAV-Schnittstelle ermöglicht den Zugriff auf Ihre Daten von jedem CalDAV-Server. Es hat nur eine begrenzte Unterstützung und es werden nur grundlegende Funktionen unterstützt. Sie können Ihre Daten mit anderen Geräten oder Diensten synchronisieren.';

  @override
  String get webdavDescription =>
      'Die WebDAV-Schnittstelle ermöglicht den Zugriff auf Ihre Daten von jedem WebDAV-Server. Es sind Dateien und Verzeichnisse zum Speichern von Daten. Sie können sie verwenden, um Ihre Daten mit anderen Geräten oder Diensten zu synchronisieren.';

  @override
  String get server => 'Server';

  @override
  String get serverDescription =>
      'Synchronisieren Sie Ihre Daten mit einem nativen Linwood Flow Server. Dies wird empfohlen für Benutzer, die ihre Daten selbst hosten möchten.';

  @override
  String get googleDescription =>
      'Synchronisieren Sie Ihre Daten mit Google. Dies wird Benutzern empfohlen, die ihr Google-Konto verwenden möchten, um auf ihre Daten zuzugreifen. Nicht alle Funktionen sind mit dieser Option verfügbar.';

  @override
  String get microsoftDescription =>
      'Synchronisieren Sie Ihre Daten mit Microsoft. Dies wird Benutzern empfohlen, die ihr Microsoft-Konto verwenden möchten, um auf ihre Daten zuzugreifen. Nicht alle Funktionen sind mit dieser Option verfügbar.';

  @override
  String get addSource => 'Quelle hinzufügen';

  @override
  String get local => 'Lokal';

  @override
  String get close => 'Schließen';

  @override
  String get unknown => 'Unbekannt';

  @override
  String get loading => 'Lädt';

  @override
  String get export => 'Exportieren';

  @override
  String get createEvent => 'Ereignis erstellen';

  @override
  String get save => 'Speichern';

  @override
  String get allSources => 'Alle Quellen';

  @override
  String get editEvent => 'Ereignis bearbeiten';

  @override
  String get end => 'Ende';

  @override
  String get location => 'Standort';

  @override
  String get status => 'Status';

  @override
  String get confirmed => 'Bestätigt';

  @override
  String get draft => 'Entwurf';

  @override
  String get cancelled => 'Abgebrochen';

  @override
  String get general => 'Allgemein';

  @override
  String get notes => 'Notizen';

  @override
  String get createNote => 'Notiz erstellen';

  @override
  String get editNote => 'Notiz bearbeiten';

  @override
  String get indicatorEmpty => 'Keine Elemente gefunden';

  @override
  String get indicatorEmptyDescription => 'Die Liste ist derzeit leer.';

  @override
  String get indicatorLoading => 'Lädt';

  @override
  String get indicatorError => 'Ein Fehler ist aufgetreten';

  @override
  String get indicatorErrorDescription =>
      'Beim Laden der Daten ist ein Fehler aufgetreten.';

  @override
  String get tryAgain => 'Erneut versuchen';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event am $date in $time in $location ($status)';
  }

  @override
  String get filter => 'Filtern';

  @override
  String get done => 'Fertig';

  @override
  String get inProgress => 'In Bearbeitung';

  @override
  String get note => 'Notiz';

  @override
  String get delete => 'Löschen';

  @override
  String get edit => 'Bearbeiten';

  @override
  String deleteGroup(String name) {
    return 'Gruppe $name löschen';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Sind Sie sicher, dass Sie die Gruppe $name löschen möchten?';
  }

  @override
  String groupName(String name) {
    return 'Gruppe $name';
  }

  @override
  String get noData => 'Es sind keine Daten vorhanden.';

  @override
  String get noEvents => 'Es gibt keine Ereignisse zum Anzeigen.';

  @override
  String get group => 'Gruppe';

  @override
  String get search => 'Suchen';

  @override
  String get events => 'Ereignisse';

  @override
  String get past => 'Vorher';

  @override
  String get decentralized => 'Dezentralisiert';

  @override
  String get decentralizedDescription =>
      'Die dezentrale Schnittstelle ermöglicht den Zugriff auf Ihre Daten von jedem dezentralen Server. Sie können damit Ihre Daten mit anderen Geräten oder Diensten synchronisieren.';

  @override
  String get importFile => 'Datei importieren';

  @override
  String get importFileDescription =>
      'Importieren Sie eine Datei von Ihrem Gerät. Sie können eine Datenbankdatei aus einer anderen Linwood Flow Instanz oder einer regulären Kalenderdatei importieren.';

  @override
  String get icalDescription =>
      'Die iCal Schnittstelle ermöglicht den Zugriff auf Ihre Daten von jedem iCal Server. Sie können damit Ihre Daten mit anderen Geräten oder Diensten synchronisieren, die CalDAV nicht unterstützen.';

  @override
  String get resource => 'Ressource';

  @override
  String get editResource => 'Ressource bearbeiten';

  @override
  String deleteResource(String name) {
    return 'Delete resource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Are you sure you want to delete the resource $name?';
  }

  @override
  String get priority => 'Priorität';

  @override
  String get assignEvent => 'Ereignis zuweisen';

  @override
  String get noEvent => 'Kein Ereignis';

  @override
  String get parentGroup => 'Elterngruppe';

  @override
  String deleteUser(String name) {
    return 'Benutzer $name löschen';
  }

  @override
  String get createUser => 'Benutzer erstellen';

  @override
  String get editUser => 'Benutzer bearbeiten';

  @override
  String deleteUserDescription(String name) {
    return 'Sind Sie sicher, dass Sie den Benutzer $name löschen möchten?';
  }

  @override
  String get pending => 'Ausstehend';

  @override
  String get removeEvent => 'Ereignis entfernen';

  @override
  String get event => 'Ereignis';

  @override
  String get nativeTitleBar => 'Native Titelleiste';

  @override
  String get blocked => 'Blockiert';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Ereignisse',
      one: '1 Ereignis',
      zero: 'Keine Ereignisse',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importieren';

  @override
  String get confirmImport =>
      'Bist du sicher, dass du es importieren möchtest?';

  @override
  String get welcome => 'Willkommen';

  @override
  String get url => 'URL';

  @override
  String get username => 'Benutzername';

  @override
  String get password => 'Passwort';

  @override
  String get connect => 'Verbinden';

  @override
  String get data => 'Daten';

  @override
  String get syncing => 'Synchronisieren';

  @override
  String get synced => 'Synchronisiert';

  @override
  String get error => 'Fehler';

  @override
  String get always => 'Immer';

  @override
  String get noMobile => 'Kein Handy';

  @override
  String get manual => 'Manuell';

  @override
  String get syncMode => 'Sync-Modus';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Termin';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Zeit';

  @override
  String deleteEvent(String name) {
    return 'Ereignis $name löschen';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Sind Sie sicher, dass Sie das Ereignis $name löschen möchten?';
  }

  @override
  String get createAppointment => 'Termin erstellen';

  @override
  String get editAppointment => 'Termin bearbeiten';

  @override
  String get createMoment => 'Moment erstellen';

  @override
  String get editMoment => 'Moment bearbeiten';

  @override
  String get convertToNote => 'In Notiz konvertieren';

  @override
  String get convertToTodo => 'Zu Todo konvertieren';

  @override
  String get open => 'Öffnen';

  @override
  String get limited => 'Begrenzt';

  @override
  String get notSet => 'Nicht gesetzt';

  @override
  String get createPending => 'Erstellen ausstehend';

  @override
  String get editPending => 'Bearbeitung ausstehend';

  @override
  String get convertTo => 'Konvertiere in';

  @override
  String get comingSoon => 'Demnächst';

  @override
  String get notSupported => 'Nicht unterstützt';

  @override
  String get databaseVersion => 'Datenbankversion';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Wiederherstellen';

  @override
  String get markdownIsSupported => 'Markdown wird unterstützt';

  @override
  String get createLabel => 'Label erstellen';

  @override
  String get editLabel => 'Label bearbeiten';

  @override
  String deleteLabel(String name) {
    return 'Label $name löschen';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Sind Sie sicher, dass Sie die Bezeichnung $name löschen möchten?';
  }

  @override
  String get label => 'Label';

  @override
  String get startOfWeek => 'Beginn der Woche';

  @override
  String headlineNumber(int number) {
    return 'Überschrift $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Durchstreichen';

  @override
  String get code => 'Code';

  @override
  String get link => 'Link';

  @override
  String get codeBlock => 'Code-Block';

  @override
  String get quote => 'Zitat';

  @override
  String get numberedList => 'Nummerierte Liste';

  @override
  String get density => 'Dichte';

  @override
  String get compact => 'Kompakt';

  @override
  String get comfortable => 'Bequemer';

  @override
  String get standard => 'Standard';

  @override
  String get highContrast => 'Hoher Kontrast';

  @override
  String get labels => 'Etiketten';

  @override
  String get systemLocale => 'Systemsprache';

  @override
  String get notebooks => 'Notizbücher';

  @override
  String get createNotebook => 'Notizbuch erstellen';

  @override
  String get editNotebook => 'Notizbuch bearbeiten';

  @override
  String get update => 'Aktualisieren';

  @override
  String get currentVersion => 'Aktuelle Version';

  @override
  String get checkForUpdates => 'Nach Updates suchen';

  @override
  String get checkForUpdatesWarning =>
      'Wenn Sie eine Überprüfung auf Aktualisierungen durchführen, werden Sie sich mit der Flow Website verbinden, um die Informationen zu erhalten.';

  @override
  String get usingLatestStable => 'Sie verwenden die neueste stabile Version';

  @override
  String get usingLatestNightly => 'Sie verwenden die neueste Nightly Version';

  @override
  String get updateNow => 'Jetzt aktualisieren';

  @override
  String get stable => 'Stabil';

  @override
  String get nightly => 'Nachts';

  @override
  String get updateAvailable => 'Update verfügbar';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Items',
      one: '1 Element',
      zero: 'Keine Items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'System-Theme';

  @override
  String get desktop => 'Desktop';

  @override
  String get restoreSettingsFromFile =>
      'Einstellungen aus Datei wiederherstellen';

  @override
  String get exportSettingsToFile => 'Einstellungen in Datei exportieren';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Aktiviert';

  @override
  String get countdown => 'Countdown';

  @override
  String get unlink => 'Link aufheben';

  @override
  String get noAlarms => 'Es sind keine Erinnerungen vorhanden.';

  @override
  String get allDay => 'Ganztägig';
}
