// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Czech (`cs`).
class AppLocalizationsCs extends AppLocalizations {
  AppLocalizationsCs([String locale = 'cs']) : super(locale);

  @override
  String get dashboard => 'Nástěnka';

  @override
  String get translate => 'Přeložit';

  @override
  String get calendar => 'Kalendář';

  @override
  String get resources => 'Zdroje';

  @override
  String get users => 'Uživatelé';

  @override
  String get user => 'Uživatel';

  @override
  String get sources => 'Zdroje';

  @override
  String get settings => 'Nastavení';

  @override
  String get create => 'Vytvořit';

  @override
  String get information => 'Informace';

  @override
  String get source => 'Zdroj';

  @override
  String get license => 'Licence';

  @override
  String get thirdPartyLicenses => 'Licence třetích stran';

  @override
  String get documentation => 'Dokumentace';

  @override
  String get privacyPolicy => 'Ochrana osobních údajů';

  @override
  String get imprint => 'Tisk';

  @override
  String get releaseNotes => 'Poznámky k vydání';

  @override
  String get changelog => 'Seznam změn';

  @override
  String get legal => 'Právní předpisy';

  @override
  String get personalization => 'Přizpůsobení';

  @override
  String get design => 'Vzhled';

  @override
  String get language => 'Jazyk';

  @override
  String get theme => 'Téma';

  @override
  String get classic => 'Klasický';

  @override
  String get systemDefault => 'Výchozí nastavení systému';

  @override
  String get light => 'Světlý';

  @override
  String get dark => 'Tmavý';

  @override
  String get createResource => 'Vytvořit zdroj';

  @override
  String get cancel => 'Zrušit';

  @override
  String get name => 'Název';

  @override
  String get description => 'L 343, 22.12.2009, s. 1).';

  @override
  String get start => 'Začít';

  @override
  String get next => 'Další';

  @override
  String get skip => 'Přeskočit';

  @override
  String get back => 'Zpět';

  @override
  String get today => 'Dnes';

  @override
  String get groups => 'Skupiny';

  @override
  String get createGroup => 'Vytvořit skupinu';

  @override
  String get editGroup => 'Upravit skupinu';

  @override
  String get list => 'Seznam';

  @override
  String get day => 'Den';

  @override
  String get week => 'Týden';

  @override
  String get month => 'Měsíc';

  @override
  String get version => 'Verze';

  @override
  String get intro => 'Úvod';

  @override
  String get caldavDescription =>
      'Rozhraní CalDAV umožňuje přístup k vašim datům z jakéhokoliv serveru CalDAV. Má omezenou podporu a jsou podporovány pouze základní funkce. Můžete ji použít k synchronizaci dat s jinými zařízeními nebo službami.';

  @override
  String get webdavDescription =>
      'WebDAV rozhraní umožňuje přístup k vašim datům z jakéhokoliv WebDAV serveru. Soubory a adresáře pro ukládání dat. Můžete je použít k synchronizaci dat s jinými zařízeními nebo službami.';

  @override
  String get server => 'Server';

  @override
  String get serverDescription =>
      'Synchronizujte svá data s nativním Linwood Flow serverem. To je doporučeno pro uživatele, kteří chtějí hostit svá data.';

  @override
  String get googleDescription =>
      'Synchronizujte svá data s Googlem. To je doporučeno uživatelům, kteří chtějí použít svůj účet Google pro přístup ke svým datům. Ne všechny funkce jsou dostupné s touto možností.';

  @override
  String get microsoftDescription =>
      'Synchronizujte svá data s Microsoftem. To je doporučeno pro uživatele, kteří chtějí použít svůj účet Microsoft pro přístup ke svým datům. Ne všechny funkce jsou dostupné s touto možností.';

  @override
  String get addSource => 'Přidat zdroj';

  @override
  String get local => 'Místní';

  @override
  String get close => 'Zavřít';

  @override
  String get unknown => 'Neznámý';

  @override
  String get loading => 'Načítání';

  @override
  String get export => 'Exportovat';

  @override
  String get createEvent => 'Vytvořit událost';

  @override
  String get save => 'Uložit';

  @override
  String get allSources => 'Všechny zdroje';

  @override
  String get editEvent => 'Upravit událost';

  @override
  String get end => 'Ukončit';

  @override
  String get location => 'Poloha';

  @override
  String get status => 'Stav';

  @override
  String get confirmed => 'Potvrzeno';

  @override
  String get draft => 'Koncept';

  @override
  String get cancelled => 'Zrušeno';

  @override
  String get general => 'Obecná ustanovení';

  @override
  String get notes => 'Poznámky';

  @override
  String get createNote => 'Vytvořit poznámku';

  @override
  String get editNote => 'Upravit poznámku';

  @override
  String get indicatorEmpty => 'Nebyly nalezeny žádné položky';

  @override
  String get indicatorEmptyDescription => 'Seznam je momentálně prázdný.';

  @override
  String get indicatorLoading => 'Načítání';

  @override
  String get indicatorError => 'Došlo k chybě';

  @override
  String get indicatorErrorDescription => 'Při načítání dat došlo k chybě.';

  @override
  String get tryAgain => 'Zkuste to znovu';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event dne $date v $time v $location ($status)';
  }

  @override
  String get filter => 'Filtr';

  @override
  String get done => 'Hotovo';

  @override
  String get inProgress => 'Probíhá';

  @override
  String get note => 'Poznámka';

  @override
  String get delete => 'Vymazat';

  @override
  String get edit => 'Upravit';

  @override
  String deleteGroup(String name) {
    return 'Odstranit skupinu $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Jste si jisti, že chcete odstranit skupinu $name?';
  }

  @override
  String groupName(String name) {
    return 'Skupina $name';
  }

  @override
  String get noData => 'Žádná data k zobrazení.';

  @override
  String get noEvents => 'Nebyly nalezeny žádné události k zobrazení.';

  @override
  String get group => 'Skupina';

  @override
  String get search => 'Hledat';

  @override
  String get events => 'Události';

  @override
  String get past => 'Minulé';

  @override
  String get decentralized => 'Decentralizováno';

  @override
  String get decentralizedDescription =>
      'decentralizované rozhraní umožňuje přístup k vašim datům z libovolného decentralizovaného serveru. Můžete ji použít k synchronizaci dat s jinými zařízeními nebo službami.';

  @override
  String get importFile => 'Importovat soubor';

  @override
  String get importFileDescription =>
      'Importujte soubor z vašeho zařízení. Můžete importovat databázový soubor z jiné instance toku linwood nebo z běžného souboru kalendáře.';

  @override
  String get icalDescription =>
      'Rozhraní iCal umožňuje přístup k vašim datům z jakéhokoliv serveru iCal. Může pouze číst data a nepodporuje psaní. Můžete ji použít k synchronizaci dat s jinými zařízeními nebo službami, které CalDAV.';

  @override
  String get resource => 'Zdroj';

  @override
  String get editResource => 'Upravit zdroj';

  @override
  String deleteResource(String name) {
    return 'Odstranit dokument $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Jste si jisti, že chcete odstranit dokument $name?';
  }

  @override
  String get priority => 'Priorita';

  @override
  String get assignEvent => 'Přiřadit událost';

  @override
  String get noEvent => 'Žádná událost';

  @override
  String get parentGroup => 'Nadřazená skupina';

  @override
  String deleteUser(String name) {
    return 'Odstranit uživatele $name';
  }

  @override
  String get createUser => 'Vytvořit uživatele';

  @override
  String get editUser => 'Upravit uživatele';

  @override
  String deleteUserDescription(String name) {
    return 'Jste si jisti, že chcete odstranit uživatele $name?';
  }

  @override
  String get pending => 'Nevyřízeno';

  @override
  String get removeEvent => 'Odstranit událost';

  @override
  String get event => 'Událost';

  @override
  String get nativeTitleBar => 'Nativní titulek';

  @override
  String get blocked => 'Blokované';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count události',
      one: '1 události',
      zero: 'Žádné události',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importovat';

  @override
  String get confirmImport => 'Jste si jisti, že ho chcete importovat?';

  @override
  String get welcome => 'Vítejte';

  @override
  String get url => 'URL';

  @override
  String get username => 'Uživatelské jméno';

  @override
  String get password => 'Heslo';

  @override
  String get connect => 'Připojit';

  @override
  String get data => 'Údaje';

  @override
  String get syncing => 'Synchronizace';

  @override
  String get synced => 'Synchronizováno';

  @override
  String get error => 'Chyba';

  @override
  String get always => 'Vždy';

  @override
  String get noMobile => 'Žádný mobil';

  @override
  String get manual => 'Ruční';

  @override
  String get syncMode => 'Režim synchronizace';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Jmenování';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Čas';

  @override
  String deleteEvent(String name) {
    return 'Odstranit událost $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Jste si jisti, že chcete odstranit událost $name?';
  }

  @override
  String get createAppointment => 'Vytvořit jmenování';

  @override
  String get editAppointment => 'Upravit jmenování';

  @override
  String get createMoment => 'Vytvořit okamžik';

  @override
  String get editMoment => 'Upravit okamžik';

  @override
  String get convertToNote => 'Převést na poznámku';

  @override
  String get convertToTodo => 'Převést na úkol';

  @override
  String get open => 'Otevřít';

  @override
  String get limited => 'Omezeno';

  @override
  String get notSet => 'Nenastaveno';

  @override
  String get createPending => 'Vytvořit nevyřízené';

  @override
  String get editPending => 'Upravit čekající';

  @override
  String get convertTo => 'Převést na';

  @override
  String get comingSoon => 'Již brzy';

  @override
  String get notSupported => 'Nepodporováno';

  @override
  String get databaseVersion => 'Verze databáze';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Obnovit';

  @override
  String get markdownIsSupported => 'Markdown je podporován';

  @override
  String get createLabel => 'Vytvořit štítek';

  @override
  String get editLabel => 'Upravit štítek';

  @override
  String deleteLabel(String name) {
    return 'Odstranit štítek $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Jste si jisti, že chcete odstranit štítek $name?';
  }

  @override
  String get label => 'Popisek';

  @override
  String get startOfWeek => 'Začátek týdne';

  @override
  String headlineNumber(int number) {
    return 'Nadpis $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Úderná';

  @override
  String get code => 'Kód';

  @override
  String get link => 'Odkaz';

  @override
  String get codeBlock => 'Blok kódu';

  @override
  String get quote => 'Cenová nabídka';

  @override
  String get numberedList => 'Číslovaný seznam';

  @override
  String get density => 'Hustota';

  @override
  String get compact => 'Kompaktní';

  @override
  String get comfortable => 'Komfortní';

  @override
  String get standard => 'Standardní';

  @override
  String get highContrast => 'Vysoký kontrast';

  @override
  String get labels => 'Popisky';

  @override
  String get systemLocale => 'Systémová lokalizace';

  @override
  String get notebooks => 'Sešity';

  @override
  String get createNotebook => 'Vytvořit sešit';

  @override
  String get editNotebook => 'Upravit sešit';

  @override
  String get update => 'Aktualizovat';

  @override
  String get currentVersion => 'Aktuální verze';

  @override
  String get checkForUpdates => 'Zkontrolovat aktualizace';

  @override
  String get checkForUpdatesWarning =>
      'Kontrola aktualizací se připojí k webu Flow pro získání informací.';

  @override
  String get usingLatestStable => 'Používáte nejnovější stabilní verzi';

  @override
  String get usingLatestNightly => 'Používáte nejnovější noční verzi';

  @override
  String get updateNow => 'Aktualizovat nyní';

  @override
  String get stable => 'Stabilní';

  @override
  String get nightly => 'Noční';

  @override
  String get updateAvailable => 'K dispozici je aktualizace';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count položky',
      one: '1 položka',
      zero: 'Žádné položky',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Motiv systému';

  @override
  String get desktop => 'Stolní počítače';

  @override
  String get restoreSettingsFromFile => 'Obnovit nastavení ze souboru';

  @override
  String get exportSettingsToFile => 'Exportovat nastavení do souboru';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Povoleno';

  @override
  String get countdown => 'Odpočítávání';

  @override
  String get unlink => 'Odpojit';

  @override
  String get noAlarms => 'Žádné budíky k zobrazení.';

  @override
  String get allDay => 'Celý den';
}
