// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Catalan Valencian (`ca`).
class AppLocalizationsCa extends AppLocalizations {
  AppLocalizationsCa([String locale = 'ca']) : super(locale);

  @override
  String get dashboard => 'Dashboard';

  @override
  String get translate => 'Tradueix';

  @override
  String get calendar => 'Calendar';

  @override
  String get resources => 'Resources';

  @override
  String get users => 'Usuaris';

  @override
  String get user => 'User';

  @override
  String get sources => 'Sources';

  @override
  String get settings => 'Paràmetres';

  @override
  String get create => 'Crear';

  @override
  String get information => 'Informació';

  @override
  String get source => 'Font';

  @override
  String get license => 'Llicència';

  @override
  String get thirdPartyLicenses => 'Third Party Licenses';

  @override
  String get documentation => 'Documentació';

  @override
  String get privacyPolicy => 'Privacy Policy';

  @override
  String get imprint => 'Avís legal';

  @override
  String get releaseNotes => 'Release Notes';

  @override
  String get changelog => 'Registre de canvis';

  @override
  String get legal => 'Legal';

  @override
  String get personalization => 'Personalització';

  @override
  String get design => 'Disseny';

  @override
  String get language => 'Language';

  @override
  String get theme => 'Tema';

  @override
  String get classic => 'Classic';

  @override
  String get systemDefault => 'System Default';

  @override
  String get light => 'Clar';

  @override
  String get dark => 'Fosc';

  @override
  String get createResource => 'Create resource';

  @override
  String get cancel => 'Cancel•lar';

  @override
  String get name => 'Nom';

  @override
  String get description => 'Descripció';

  @override
  String get start => 'Inicia';

  @override
  String get next => 'Next';

  @override
  String get skip => 'Skip';

  @override
  String get back => 'Enrere';

  @override
  String get today => 'Today';

  @override
  String get groups => 'Groups';

  @override
  String get createGroup => 'Create group';

  @override
  String get editGroup => 'Edit group';

  @override
  String get list => 'List';

  @override
  String get day => 'Day';

  @override
  String get week => 'Week';

  @override
  String get month => 'Month';

  @override
  String get version => 'Versió';

  @override
  String get intro => 'Intro';

  @override
  String get caldavDescription =>
      'The CalDAV interface allows you to access your data from any CalDAV server. It has limited support and only basic functions are supported. You can use it to synchronize your data with other devices or services.';

  @override
  String get webdavDescription =>
      'The WebDAV interface allows you to access your data from any WebDAV server. It files and directories to store data. You can use it to synchronize your data with other devices or services.';

  @override
  String get server => 'Servidor';

  @override
  String get serverDescription =>
      'Sync your data with a native Linwood Flow server. This is recommended for users that want to self-host their data.';

  @override
  String get googleDescription =>
      'Sync your data with Google. This is recommended for users that want to use their Google account to access their data. Not all features are available with this option.';

  @override
  String get microsoftDescription =>
      'Sync your data with Microsoft. This is recommended for users that want to use their Microsoft account to access their data. Not all features are available with this option.';

  @override
  String get addSource => 'Add source';

  @override
  String get local => 'Local';

  @override
  String get close => 'Close';

  @override
  String get unknown => 'Unknown';

  @override
  String get loading => 'Loading';

  @override
  String get export => 'Exportar';

  @override
  String get createEvent => 'Create event';

  @override
  String get save => 'Guardar';

  @override
  String get allSources => 'All sources';

  @override
  String get editEvent => 'Edit event';

  @override
  String get end => 'End';

  @override
  String get location => 'Ubicació';

  @override
  String get status => 'Status';

  @override
  String get confirmed => 'Confirmed';

  @override
  String get draft => 'Draft';

  @override
  String get cancelled => 'Cancelled';

  @override
  String get general => 'General';

  @override
  String get notes => 'Notes';

  @override
  String get createNote => 'Create note';

  @override
  String get editNote => 'Edit note';

  @override
  String get indicatorEmpty => 'No items found';

  @override
  String get indicatorEmptyDescription => 'The list is currently empty.';

  @override
  String get indicatorLoading => 'Loading';

  @override
  String get indicatorError => 'An error occurred';

  @override
  String get indicatorErrorDescription =>
      'An error occurred while loading the data.';

  @override
  String get tryAgain => 'Try again';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event on $date at $time in $location ($status)';
  }

  @override
  String get filter => 'Filter';

  @override
  String get done => 'Done';

  @override
  String get inProgress => 'In progress';

  @override
  String get note => 'Nota';

  @override
  String get delete => 'Suprimeix';

  @override
  String get edit => 'Editar';

  @override
  String deleteGroup(String name) {
    return 'Delete group $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Are you sure you want to delete the group $name?';
  }

  @override
  String groupName(String name) {
    return 'Group $name';
  }

  @override
  String get noData => 'There is no data to display.';

  @override
  String get noEvents => 'There are no events to display.';

  @override
  String get group => 'Group';

  @override
  String get search => 'Cerca';

  @override
  String get events => 'Events';

  @override
  String get past => 'Past';

  @override
  String get decentralized => 'Decentralized';

  @override
  String get decentralizedDescription =>
      'The decentralized interface allows you to access your data from any decentralized server. You can use it to synchronize your data with other devices or services.';

  @override
  String get importFile => 'Import file';

  @override
  String get importFileDescription =>
      'Import a file from your device. You can import a database file from another Linwood Flow instance or a regular calendar file.';

  @override
  String get icalDescription =>
      'The iCal interface allows you to access your data from any iCal server. It can only read data and does not support writing. You can use it to synchronize your data with other devices or services that do not support CalDAV.';

  @override
  String get resource => 'Resource';

  @override
  String get editResource => 'Edit resource';

  @override
  String deleteResource(String name) {
    return 'Delete resource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Are you sure you want to delete the resource $name?';
  }

  @override
  String get priority => 'Priority';

  @override
  String get assignEvent => 'Assign event';

  @override
  String get noEvent => 'No event';

  @override
  String get parentGroup => 'Parent group';

  @override
  String deleteUser(String name) {
    return 'Delete user $name';
  }

  @override
  String get createUser => 'Create user';

  @override
  String get editUser => 'Edit user';

  @override
  String deleteUserDescription(String name) {
    return 'Are you sure you want to delete the user $name?';
  }

  @override
  String get pending => 'Pending';

  @override
  String get removeEvent => 'Remove event';

  @override
  String get event => 'Event';

  @override
  String get nativeTitleBar => 'Barra de títol nativa';

  @override
  String get blocked => 'Blocked';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count events',
      one: '1 event',
      zero: 'No events',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importa';

  @override
  String get confirmImport => 'Are you sure you want to import it?';

  @override
  String get welcome => 'Welcome';

  @override
  String get url => 'URL';

  @override
  String get username => 'Nom d\'usuari';

  @override
  String get password => 'Contrasenya';

  @override
  String get connect => 'Connecta';

  @override
  String get data => 'Dades';

  @override
  String get syncing => 'Syncing';

  @override
  String get synced => 'Sincronitzat';

  @override
  String get error => 'Error';

  @override
  String get always => 'Sempre';

  @override
  String get noMobile => 'Sense mòbil';

  @override
  String get manual => 'Manual';

  @override
  String get syncMode => 'Mode de sincronització';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Appointment';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Time';

  @override
  String deleteEvent(String name) {
    return 'Delete event $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Are you sure you want to delete the event $name?';
  }

  @override
  String get createAppointment => 'Create appointment';

  @override
  String get editAppointment => 'Edit appointment';

  @override
  String get createMoment => 'Create moment';

  @override
  String get editMoment => 'Edit moment';

  @override
  String get convertToNote => 'Convert to note';

  @override
  String get convertToTodo => 'Convert to todo';

  @override
  String get open => 'Obrir';

  @override
  String get limited => 'Limited';

  @override
  String get notSet => 'No establert';

  @override
  String get createPending => 'Create pending';

  @override
  String get editPending => 'Edit pending';

  @override
  String get convertTo => 'Convert to';

  @override
  String get comingSoon => 'Coming soon';

  @override
  String get notSupported => 'Not supported';

  @override
  String get databaseVersion => 'Database version';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Restore';

  @override
  String get markdownIsSupported => 'Markdown is supported';

  @override
  String get createLabel => 'Create label';

  @override
  String get editLabel => 'Edit label';

  @override
  String deleteLabel(String name) {
    return 'Delete label $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Are you sure you want to delete the label $name?';
  }

  @override
  String get label => 'Etiqueta';

  @override
  String get startOfWeek => 'Start of week';

  @override
  String headlineNumber(int number) {
    return 'Títol $number';
  }

  @override
  String get bold => 'Negreta';

  @override
  String get italic => 'Cursiva';

  @override
  String get strikethrough => 'Ratllat';

  @override
  String get code => 'Codi';

  @override
  String get link => 'Enllaç';

  @override
  String get codeBlock => 'Code block';

  @override
  String get quote => 'Cita';

  @override
  String get numberedList => 'Numbered list';

  @override
  String get density => 'Densitat';

  @override
  String get compact => 'Compacte';

  @override
  String get comfortable => 'Còmode';

  @override
  String get standard => 'Estàndard';

  @override
  String get highContrast => 'Alt contrast';

  @override
  String get labels => 'Labels';

  @override
  String get systemLocale => 'Configuració regional del sistema';

  @override
  String get notebooks => 'Notebooks';

  @override
  String get createNotebook => 'Create notebook';

  @override
  String get editNotebook => 'Edit notebook';

  @override
  String get update => 'Actualitza';

  @override
  String get currentVersion => 'Versió actual';

  @override
  String get checkForUpdates => 'Comprova actualitzacions';

  @override
  String get checkForUpdatesWarning =>
      'Performing a check for updates will connect to the Flow website to get the information.';

  @override
  String get usingLatestStable => 'Estàs utilitzant l\'última versió estable';

  @override
  String get usingLatestNightly => 'Estàs utilitzant l\'última versió nightly';

  @override
  String get updateNow => 'Actualitza ara';

  @override
  String get stable => 'Estable';

  @override
  String get nightly => 'Nightly';

  @override
  String get updateAvailable => 'Actualització disponible';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '1 item',
      zero: 'No items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'System theme';

  @override
  String get desktop => 'Escriptori';

  @override
  String get restoreSettingsFromFile => 'Restaura configuració des de fitxer';

  @override
  String get exportSettingsToFile => 'Exporta configuració a fitxer';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Enabled';

  @override
  String get countdown => 'Countdown';

  @override
  String get unlink => 'Unlink';

  @override
  String get noAlarms => 'There are no alarms to display.';

  @override
  String get allDay => 'All day';
}
