import 'leap_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Arabic (`ar`).
class LeapLocalizationsAr extends LeapLocalizations {
  LeapLocalizationsAr([String locale = 'ar']) : super(locale);

  @override
  String get color => 'اللون';

  @override
  String get red => 'أحمر';

  @override
  String get green => 'أخضر';

  @override
  String get blue => 'أزرق';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get close => 'أغلق';

  @override
  String get exitAlwaysOnTop => 'الخروج دائما في الأعلى';

  @override
  String get alwaysOnTop => 'دائما في الأعلى';

  @override
  String get exitFullScreen => 'الخروج من ملء الشاشة';

  @override
  String get fullScreen => 'ملء الشاشة';

  @override
  String get restore => 'إستعادة';

  @override
  String get copyMessage => 'نسخ إلى الحافظة';

  @override
  String get reset => 'Reset';

  @override
  String get shouldNotEmpty => 'يجب ألا تكون هذه القيمة فارغة';

  @override
  String get alreadyExists => 'هذا العنصر موجود بالفعل';

  @override
  String get create => 'إنشاء';

  @override
  String get enterName => 'الرجاء إدخال اسم';

  @override
  String get name => 'الاسم';

  @override
  String get invalidName => 'اسم غير صالح';
}
