// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class AppLocalizationsZh extends AppLocalizations {
  AppLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get dashboard => '仪表板';

  @override
  String get translate => '翻译';

  @override
  String get calendar => '日程表';

  @override
  String get resources => '资源';

  @override
  String get users => '用户';

  @override
  String get user => '用户';

  @override
  String get sources => '来源';

  @override
  String get settings => '设置';

  @override
  String get create => '创建';

  @override
  String get information => '信息';

  @override
  String get source => '来源';

  @override
  String get license => '许可协议';

  @override
  String get thirdPartyLicenses => '第三方许可证';

  @override
  String get documentation => '文件';

  @override
  String get privacyPolicy => '隐私政策';

  @override
  String get imprint => '图形';

  @override
  String get releaseNotes => '发布说明';

  @override
  String get changelog => '更新日志';

  @override
  String get legal => '法律';

  @override
  String get personalization => '个性化';

  @override
  String get design => '设计';

  @override
  String get language => '语言';

  @override
  String get theme => '主题';

  @override
  String get classic => '经典';

  @override
  String get systemDefault => '系统默认';

  @override
  String get light => '亮色的';

  @override
  String get dark => '深色';

  @override
  String get createResource => '创建资源';

  @override
  String get cancel => '取消';

  @override
  String get name => '名称';

  @override
  String get description => '描述';

  @override
  String get start => '开始';

  @override
  String get next => '下一个';

  @override
  String get skip => '跳过';

  @override
  String get back => '后退';

  @override
  String get today => '今日：';

  @override
  String get groups => '群組';

  @override
  String get createGroup => '创建组';

  @override
  String get editGroup => '编辑组';

  @override
  String get list => '列表';

  @override
  String get day => '日';

  @override
  String get week => '周';

  @override
  String get month => '月';

  @override
  String get version => '版本';

  @override
  String get intro => '简介';

  @override
  String get caldavDescription =>
      'CalDAV 接口允许您从任意CalDAV服务器访问您的数据。 它的支持有限，只支持基本功能。您可以使用它来将您的数据与其他设备或服务同步。';

  @override
  String get webdavDescription =>
      'WebDAV 接口允许您从任何 WebDAV 服务器访问您的数据。 它存储数据的文件和目录。您可以使用它来同步您的数据和其他设备或服务。';

  @override
  String get server => '服务器';

  @override
  String get serverDescription =>
      '将您的数据与原生的Linwood Flow 服务器同步。这是推荐给想要自我主机数据的用户。';

  @override
  String get googleDescription =>
      '与Google同步您的数据。建议用户使用他们的Google账户访问他们的数据。 此选项并非所有功能都可用。';

  @override
  String get microsoftDescription =>
      '与Microsoft同步您的数据。建议想要使用Microsoft账户访问他们的数据。 此选项并非所有功能都可用。';

  @override
  String get addSource => '添加源';

  @override
  String get local => '本地的';

  @override
  String get close => '关闭';

  @override
  String get unknown => '未知的';

  @override
  String get loading => '正在加载';

  @override
  String get export => '导出';

  @override
  String get createEvent => '创建事件';

  @override
  String get save => '保存';

  @override
  String get allSources => '所有来源';

  @override
  String get editEvent => '编辑事件';

  @override
  String get end => '结束';

  @override
  String get location => '地点';

  @override
  String get status => '状态';

  @override
  String get confirmed => '已确认';

  @override
  String get draft => '草稿';

  @override
  String get cancelled => '已取消';

  @override
  String get general => 'A. 概况';

  @override
  String get notes => '注';

  @override
  String get createNote => '创建笔记';

  @override
  String get editNote => '编辑笔记';

  @override
  String get indicatorEmpty => '未找到项目';

  @override
  String get indicatorEmptyDescription => '列表目前是空的。';

  @override
  String get indicatorLoading => '正在加载';

  @override
  String get indicatorError => '发生错误';

  @override
  String get indicatorErrorDescription => '加载数据时出错。';

  @override
  String get tryAgain => '再试一次';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event 在 $date 上 $time 于 $location ($status)';
  }

  @override
  String get filter => '筛选器';

  @override
  String get done => '完成';

  @override
  String get inProgress => '进行中';

  @override
  String get note => '说明';

  @override
  String get delete => '删除';

  @override
  String get edit => '编辑';

  @override
  String deleteGroup(String name) {
    return '删除组 $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return '您确定要删除组 $name 吗？';
  }

  @override
  String groupName(String name) {
    return '组 $name';
  }

  @override
  String get noData => '没有要显示的数据。';

  @override
  String get noEvents => '没有要显示的事件。';

  @override
  String get group => '组别';

  @override
  String get search => '搜索';

  @override
  String get events => '事件';

  @override
  String get past => '过去的';

  @override
  String get decentralized => '放权化';

  @override
  String get decentralizedDescription =>
      '分散化接口允许您从任何分散的服务器访问您的数据。 您可以使用它来同步您的数据和其他设备或服务。';

  @override
  String get importFile => '导入文件';

  @override
  String get importFileDescription =>
      '从您的设备导入文件。您可以从另一个 Linwood 流实例或常规日历文件导入数据库文件。';

  @override
  String get icalDescription =>
      'iCal 接口允许您从任何 iCal 服务器访问您的数据。它只能读取数据，不支持写入。 您可以使用它来同步您的数据和不支持CalDAV的其他设备或服务。';

  @override
  String get resource => '资源';

  @override
  String get editResource => '编辑资源';

  @override
  String deleteResource(String name) {
    return 'Delete resource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Are you sure you want to delete the resource $name?';
  }

  @override
  String get priority => '优先权';

  @override
  String get assignEvent => '分配事件';

  @override
  String get noEvent => '无事件';

  @override
  String get parentGroup => '父组';

  @override
  String deleteUser(String name) {
    return '删除用户 $name';
  }

  @override
  String get createUser => '创建用户';

  @override
  String get editUser => '编辑用户';

  @override
  String deleteUserDescription(String name) {
    return '您确定要删除用户 $name 吗？';
  }

  @override
  String get pending => '待定';

  @override
  String get removeEvent => '删除事件';

  @override
  String get event => '事件';

  @override
  String get nativeTitleBar => '原生标题栏';

  @override
  String get blocked => '已阻止';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '事件$count 事件',
      one: '1个事件',
      zero: '没有事件',
    );
    return '$_temp0';
  }

  @override
  String get import => '导入';

  @override
  String get confirmImport => '您确定要导入它吗？';

  @override
  String get welcome => '欢迎使用';

  @override
  String get url => '网址';

  @override
  String get username => '用户名';

  @override
  String get password => '密码';

  @override
  String get connect => '连接';

  @override
  String get data => '数据';

  @override
  String get syncing => '正在同步';

  @override
  String get synced => '已同步';

  @override
  String get error => '错误';

  @override
  String get always => '总是显示';

  @override
  String get noMobile => '无手机';

  @override
  String get manual => '手动模式';

  @override
  String get syncMode => '同步模式';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => '约会';

  @override
  String get moment => '瞬时';

  @override
  String get time => '时间';

  @override
  String deleteEvent(String name) {
    return '删除事件 $name';
  }

  @override
  String deleteEventDescription(String name) {
    return '您确定要删除事件 $name 吗？';
  }

  @override
  String get createAppointment => '创建约会';

  @override
  String get editAppointment => '编辑约会';

  @override
  String get createMoment => '创建时间';

  @override
  String get editMoment => '编辑时间';

  @override
  String get convertToNote => '转换为笔记';

  @override
  String get convertToTodo => '转换为土豆';

  @override
  String get open => '打开';

  @override
  String get limited => '限量的';

  @override
  String get notSet => '未设置';

  @override
  String get createPending => '创建待定';

  @override
  String get editPending => '编辑待定';

  @override
  String get convertTo => '转换为';

  @override
  String get comingSoon => '即将开始';

  @override
  String get notSupported => '不支持';

  @override
  String get databaseVersion => '数据库版本';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => '恢复';

  @override
  String get markdownIsSupported => '支持Markdown';

  @override
  String get createLabel => '创建标签';

  @override
  String get editLabel => '编辑标签';

  @override
  String deleteLabel(String name) {
    return '删除标签 $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return '您确定要删除标签 $name 吗？';
  }

  @override
  String get label => '标签';

  @override
  String get startOfWeek => '一周开始';

  @override
  String headlineNumber(int number) {
    return '标题 $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => '删除线';

  @override
  String get code => '代码';

  @override
  String get link => '链接';

  @override
  String get codeBlock => '代码块';

  @override
  String get quote => '引用';

  @override
  String get numberedList => '编号列表';

  @override
  String get density => '密度';

  @override
  String get compact => '紧凑的';

  @override
  String get comfortable => '舒适的';

  @override
  String get standard => '标准的';

  @override
  String get highContrast => '高对比度';

  @override
  String get labels => '标签';

  @override
  String get systemLocale => '系统区域设置';

  @override
  String get notebooks => '笔记本';

  @override
  String get createNotebook => '创建笔记本';

  @override
  String get editNotebook => '编辑笔记本';

  @override
  String get update => '更新';

  @override
  String get currentVersion => '当前版本';

  @override
  String get checkForUpdates => '检查更新';

  @override
  String get checkForUpdatesWarning => '检查更新将连接到 Flow 网站获取信息。';

  @override
  String get usingLatestStable => '您正在使用最新的稳定版本';

  @override
  String get usingLatestNightly => '您正在使用最新的夜间版本';

  @override
  String get updateNow => '立即更新';

  @override
  String get stable => '稳定的';

  @override
  String get nightly => '每晚一次';

  @override
  String get updateAvailable => '可用更新';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '项目$count 项目',
      one: '1个项目',
      zero: '没有项目',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => '系统主题';

  @override
  String get desktop => '桌面';

  @override
  String get restoreSettingsFromFile => '从文件恢复设置';

  @override
  String get exportSettingsToFile => '导出设置到文件';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => '已启用';

  @override
  String get countdown => '倒计时';

  @override
  String get unlink => '取消链接';

  @override
  String get noAlarms => '没有提醒可显示。';

  @override
  String get allDay => '全天';
}

/// The translations for Chinese, using the Han script (`zh_Hant`).
class AppLocalizationsZhHant extends AppLocalizationsZh {
  AppLocalizationsZhHant() : super('zh_Hant');

  @override
  String get dashboard => 'Dashboard';

  @override
  String get translate => '翻譯';

  @override
  String get calendar => 'Calendar';

  @override
  String get resources => 'Resources';

  @override
  String get users => '使用者';

  @override
  String get user => 'User';

  @override
  String get sources => 'Sources';

  @override
  String get settings => '設定';

  @override
  String get create => '建立';

  @override
  String get information => '資訊';

  @override
  String get source => '來源';

  @override
  String get license => '授權';

  @override
  String get thirdPartyLicenses => 'Third Party Licenses';

  @override
  String get documentation => '文件';

  @override
  String get privacyPolicy => 'Privacy Policy';

  @override
  String get imprint => '發行頁面';

  @override
  String get releaseNotes => 'Release Notes';

  @override
  String get changelog => '更新紀錄';

  @override
  String get legal => '法律資訊';

  @override
  String get personalization => '個人化';

  @override
  String get design => '配色';

  @override
  String get language => 'Language';

  @override
  String get theme => '主題';

  @override
  String get classic => 'Classic';

  @override
  String get systemDefault => 'System Default';

  @override
  String get light => '亮';

  @override
  String get dark => '暗';

  @override
  String get createResource => 'Create resource';

  @override
  String get cancel => '取消';

  @override
  String get name => '名稱';

  @override
  String get description => '說明';

  @override
  String get start => '開始';

  @override
  String get next => 'Next';

  @override
  String get skip => 'Skip';

  @override
  String get back => '返回';

  @override
  String get today => 'Today';

  @override
  String get groups => 'Groups';

  @override
  String get createGroup => 'Create group';

  @override
  String get editGroup => 'Edit group';

  @override
  String get list => 'List';

  @override
  String get day => 'Day';

  @override
  String get week => 'Week';

  @override
  String get month => 'Month';

  @override
  String get version => '版本';

  @override
  String get intro => 'Intro';

  @override
  String get caldavDescription =>
      'The CalDAV interface allows you to access your data from any CalDAV server. It has limited support and only basic functions are supported. You can use it to synchronize your data with other devices or services.';

  @override
  String get webdavDescription =>
      'The WebDAV interface allows you to access your data from any WebDAV server. It files and directories to store data. You can use it to synchronize your data with other devices or services.';

  @override
  String get server => '伺服器';

  @override
  String get serverDescription =>
      'Sync your data with a native Linwood Flow server. This is recommended for users that want to self-host their data.';

  @override
  String get googleDescription =>
      'Sync your data with Google. This is recommended for users that want to use their Google account to access their data. Not all features are available with this option.';

  @override
  String get microsoftDescription =>
      'Sync your data with Microsoft. This is recommended for users that want to use their Microsoft account to access their data. Not all features are available with this option.';

  @override
  String get addSource => 'Add source';

  @override
  String get local => '本機';

  @override
  String get close => '關閉';

  @override
  String get unknown => 'Unknown';

  @override
  String get loading => 'Loading';

  @override
  String get export => '匯出';

  @override
  String get createEvent => 'Create event';

  @override
  String get save => '儲存';

  @override
  String get allSources => 'All sources';

  @override
  String get editEvent => 'Edit event';

  @override
  String get end => 'End';

  @override
  String get location => '位置';

  @override
  String get status => 'Status';

  @override
  String get confirmed => 'Confirmed';

  @override
  String get draft => 'Draft';

  @override
  String get cancelled => 'Cancelled';

  @override
  String get general => '一般';

  @override
  String get notes => 'Notes';

  @override
  String get createNote => 'Create note';

  @override
  String get editNote => 'Edit note';

  @override
  String get indicatorEmpty => 'No items found';

  @override
  String get indicatorEmptyDescription => 'The list is currently empty.';

  @override
  String get indicatorLoading => 'Loading';

  @override
  String get indicatorError => 'An error occurred';

  @override
  String get indicatorErrorDescription =>
      'An error occurred while loading the data.';

  @override
  String get tryAgain => 'Try again';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event on $date at $time in $location ($status)';
  }

  @override
  String get filter => 'Filter';

  @override
  String get done => 'Done';

  @override
  String get inProgress => 'In progress';

  @override
  String get note => '筆記';

  @override
  String get delete => '刪除';

  @override
  String get edit => '編輯';

  @override
  String deleteGroup(String name) {
    return 'Delete group $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Are you sure you want to delete the group $name?';
  }

  @override
  String groupName(String name) {
    return 'Group $name';
  }

  @override
  String get noData => 'There is no data to display.';

  @override
  String get noEvents => 'There are no events to display.';

  @override
  String get group => 'Group';

  @override
  String get search => '搜尋';

  @override
  String get events => 'Events';

  @override
  String get past => 'Past';

  @override
  String get decentralized => 'Decentralized';

  @override
  String get decentralizedDescription =>
      'The decentralized interface allows you to access your data from any decentralized server. You can use it to synchronize your data with other devices or services.';

  @override
  String get importFile => 'Import file';

  @override
  String get importFileDescription =>
      'Import a file from your device. You can import a database file from another Linwood Flow instance or a regular calendar file.';

  @override
  String get icalDescription =>
      'The iCal interface allows you to access your data from any iCal server. It can only read data and does not support writing. You can use it to synchronize your data with other devices or services that do not support CalDAV.';

  @override
  String get resource => 'Resource';

  @override
  String get editResource => 'Edit resource';

  @override
  String deleteResource(String name) {
    return 'Delete resource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Are you sure you want to delete the resource $name?';
  }

  @override
  String get priority => 'Priority';

  @override
  String get assignEvent => 'Assign event';

  @override
  String get noEvent => 'No event';

  @override
  String get parentGroup => 'Parent group';

  @override
  String deleteUser(String name) {
    return 'Delete user $name';
  }

  @override
  String get createUser => 'Create user';

  @override
  String get editUser => 'Edit user';

  @override
  String deleteUserDescription(String name) {
    return 'Are you sure you want to delete the user $name?';
  }

  @override
  String get pending => 'Pending';

  @override
  String get removeEvent => 'Remove event';

  @override
  String get event => 'Event';

  @override
  String get nativeTitleBar => '原生標題列';

  @override
  String get blocked => 'Blocked';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count events',
      one: '1 event',
      zero: 'No events',
    );
    return '$_temp0';
  }

  @override
  String get import => '匯入';

  @override
  String get confirmImport => 'Are you sure you want to import it?';

  @override
  String get welcome => 'Welcome';

  @override
  String get url => '網址';

  @override
  String get username => '使用者名稱';

  @override
  String get password => '密碼';

  @override
  String get connect => '連線';

  @override
  String get data => '資料';

  @override
  String get syncing => 'Syncing';

  @override
  String get synced => '已同步';

  @override
  String get error => '錯誤';

  @override
  String get always => '一律';

  @override
  String get noMobile => '沒有行動裝置';

  @override
  String get manual => '手動';

  @override
  String get syncMode => '同步模式';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Appointment';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Time';

  @override
  String deleteEvent(String name) {
    return 'Delete event $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Are you sure you want to delete the event $name?';
  }

  @override
  String get createAppointment => 'Create appointment';

  @override
  String get editAppointment => 'Edit appointment';

  @override
  String get createMoment => 'Create moment';

  @override
  String get editMoment => 'Edit moment';

  @override
  String get convertToNote => 'Convert to note';

  @override
  String get convertToTodo => 'Convert to todo';

  @override
  String get open => '開啟';

  @override
  String get limited => 'Limited';

  @override
  String get notSet => '未設';

  @override
  String get createPending => 'Create pending';

  @override
  String get editPending => 'Edit pending';

  @override
  String get convertTo => 'Convert to';

  @override
  String get comingSoon => 'Coming soon';

  @override
  String get notSupported => 'Not supported';

  @override
  String get databaseVersion => 'Database version';

  @override
  String get minimize => '最小化';

  @override
  String get maximize => '最大化';

  @override
  String get restore => '恢復';

  @override
  String get markdownIsSupported => 'Markdown is supported';

  @override
  String get createLabel => 'Create label';

  @override
  String get editLabel => 'Edit label';

  @override
  String deleteLabel(String name) {
    return 'Delete label $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Are you sure you want to delete the label $name?';
  }

  @override
  String get label => '標記';

  @override
  String get startOfWeek => 'Start of week';

  @override
  String headlineNumber(int number) {
    return '標題 $number';
  }

  @override
  String get bold => '粗體';

  @override
  String get italic => '斜體';

  @override
  String get strikethrough => '刪除線';

  @override
  String get code => '程式碼';

  @override
  String get link => '鏈結';

  @override
  String get codeBlock => 'Code block';

  @override
  String get quote => '引述';

  @override
  String get numberedList => 'Numbered list';

  @override
  String get density => '密度';

  @override
  String get compact => '緊湊';

  @override
  String get comfortable => '舒適';

  @override
  String get standard => '標準';

  @override
  String get highContrast => '高對比';

  @override
  String get labels => 'Labels';

  @override
  String get systemLocale => '系統語言';

  @override
  String get notebooks => 'Notebooks';

  @override
  String get createNotebook => 'Create notebook';

  @override
  String get editNotebook => 'Edit notebook';

  @override
  String get update => '更新';

  @override
  String get currentVersion => '目前版本';

  @override
  String get checkForUpdates => '檢查更新';

  @override
  String get checkForUpdatesWarning =>
      'Performing a check for updates will connect to the Flow website to get the information.';

  @override
  String get usingLatestStable => '現在的是最新穩定版';

  @override
  String get usingLatestNightly => '現在的是最新夜間版';

  @override
  String get updateNow => '立即更新';

  @override
  String get stable => '穩定版';

  @override
  String get nightly => '預覽版';

  @override
  String get updateAvailable => '有更新';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '1 item',
      zero: 'No items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'System theme';

  @override
  String get desktop => '電腦';

  @override
  String get restoreSettingsFromFile => '從檔案還原設定';

  @override
  String get exportSettingsToFile => '匯出設定到檔案';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Enabled';

  @override
  String get countdown => 'Countdown';

  @override
  String get unlink => 'Unlink';

  @override
  String get noAlarms => 'There are no alarms to display.';

  @override
  String get allDay => 'All day';
}
