// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Vietnamese (`vi`).
class AppLocalizationsVi extends AppLocalizations {
  AppLocalizationsVi([String locale = 'vi']) : super(locale);

  @override
  String get dashboard => 'Dashboard';

  @override
  String get translate => 'Dịch';

  @override
  String get calendar => 'Calendar';

  @override
  String get resources => 'Resources';

  @override
  String get users => 'Người dùng';

  @override
  String get user => 'User';

  @override
  String get sources => 'Sources';

  @override
  String get settings => 'Cài đặt';

  @override
  String get create => 'Tạo mới';

  @override
  String get information => 'Thông tin';

  @override
  String get source => 'Nguồn';

  @override
  String get license => 'Giấy phép';

  @override
  String get thirdPartyLicenses => 'Third Party Licenses';

  @override
  String get documentation => 'Tài liệu';

  @override
  String get privacyPolicy => 'Chính sách bảo mật';

  @override
  String get imprint => 'Thông tin pháp lý';

  @override
  String get releaseNotes => 'Release Notes';

  @override
  String get changelog => 'Nhật ký thay đổi';

  @override
  String get legal => 'Legal';

  @override
  String get personalization => 'Cá nhân hóa';

  @override
  String get design => 'Thiết kế';

  @override
  String get language => 'Language';

  @override
  String get theme => 'Giao diện';

  @override
  String get classic => 'Classic';

  @override
  String get systemDefault => 'System Default';

  @override
  String get light => 'Sáng';

  @override
  String get dark => 'Tối';

  @override
  String get createResource => 'Create resource';

  @override
  String get cancel => 'Hủy';

  @override
  String get name => 'Tiêu đề';

  @override
  String get description => 'Mô tả';

  @override
  String get start => 'Bắt đầu';

  @override
  String get next => 'Next';

  @override
  String get skip => 'Skip';

  @override
  String get back => 'Quay lại';

  @override
  String get today => 'Today';

  @override
  String get groups => 'Groups';

  @override
  String get createGroup => 'Create group';

  @override
  String get editGroup => 'Edit group';

  @override
  String get list => 'List';

  @override
  String get day => 'Day';

  @override
  String get week => 'Week';

  @override
  String get month => 'Month';

  @override
  String get version => 'Phiên bản';

  @override
  String get intro => 'Intro';

  @override
  String get caldavDescription =>
      'The CalDAV interface allows you to access your data from any CalDAV server. It has limited support and only basic functions are supported. You can use it to synchronize your data with other devices or services.';

  @override
  String get webdavDescription =>
      'The WebDAV interface allows you to access your data from any WebDAV server. It files and directories to store data. You can use it to synchronize your data with other devices or services.';

  @override
  String get server => 'Máy chủ';

  @override
  String get serverDescription =>
      'Sync your data with a native Linwood Flow server. This is recommended for users that want to self-host their data.';

  @override
  String get googleDescription =>
      'Sync your data with Google. This is recommended for users that want to use their Google account to access their data. Not all features are available with this option.';

  @override
  String get microsoftDescription =>
      'Sync your data with Microsoft. This is recommended for users that want to use their Microsoft account to access their data. Not all features are available with this option.';

  @override
  String get addSource => 'Add source';

  @override
  String get local => 'Cục bộ';

  @override
  String get close => 'Đóng';

  @override
  String get unknown => 'Unknown';

  @override
  String get loading => 'Loading';

  @override
  String get export => 'Xuất dữ liệu';

  @override
  String get createEvent => 'Create event';

  @override
  String get save => 'Lưu';

  @override
  String get allSources => 'All sources';

  @override
  String get editEvent => 'Edit event';

  @override
  String get end => 'End';

  @override
  String get location => 'Vị trí';

  @override
  String get status => 'Status';

  @override
  String get confirmed => 'Confirmed';

  @override
  String get draft => 'Draft';

  @override
  String get cancelled => 'Cancelled';

  @override
  String get general => 'Chung';

  @override
  String get notes => 'Notes';

  @override
  String get createNote => 'Create note';

  @override
  String get editNote => 'Edit note';

  @override
  String get indicatorEmpty => 'No items found';

  @override
  String get indicatorEmptyDescription => 'The list is currently empty.';

  @override
  String get indicatorLoading => 'Loading';

  @override
  String get indicatorError => 'An error occurred';

  @override
  String get indicatorErrorDescription =>
      'An error occurred while loading the data.';

  @override
  String get tryAgain => 'Try again';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event on $date at $time in $location ($status)';
  }

  @override
  String get filter => 'Filter';

  @override
  String get done => 'Done';

  @override
  String get inProgress => 'In progress';

  @override
  String get note => 'Ghi chú';

  @override
  String get delete => 'Xóa';

  @override
  String get edit => 'Chỉnh sửa';

  @override
  String deleteGroup(String name) {
    return 'Delete group $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Are you sure you want to delete the group $name?';
  }

  @override
  String groupName(String name) {
    return 'Group $name';
  }

  @override
  String get noData => 'There is no data to display.';

  @override
  String get noEvents => 'There are no events to display.';

  @override
  String get group => 'Group';

  @override
  String get search => 'Tìm kiếm';

  @override
  String get events => 'Events';

  @override
  String get past => 'Past';

  @override
  String get decentralized => 'Decentralized';

  @override
  String get decentralizedDescription =>
      'The decentralized interface allows you to access your data from any decentralized server. You can use it to synchronize your data with other devices or services.';

  @override
  String get importFile => 'Import file';

  @override
  String get importFileDescription =>
      'Import a file from your device. You can import a database file from another Linwood Flow instance or a regular calendar file.';

  @override
  String get icalDescription =>
      'The iCal interface allows you to access your data from any iCal server. It can only read data and does not support writing. You can use it to synchronize your data with other devices or services that do not support CalDAV.';

  @override
  String get resource => 'Resource';

  @override
  String get editResource => 'Edit resource';

  @override
  String deleteResource(String name) {
    return 'Delete resource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Are you sure you want to delete the resource $name?';
  }

  @override
  String get priority => 'Priority';

  @override
  String get assignEvent => 'Assign event';

  @override
  String get noEvent => 'No event';

  @override
  String get parentGroup => 'Parent group';

  @override
  String deleteUser(String name) {
    return 'Delete user $name';
  }

  @override
  String get createUser => 'Create user';

  @override
  String get editUser => 'Edit user';

  @override
  String deleteUserDescription(String name) {
    return 'Are you sure you want to delete the user $name?';
  }

  @override
  String get pending => 'Pending';

  @override
  String get removeEvent => 'Remove event';

  @override
  String get event => 'Event';

  @override
  String get nativeTitleBar => 'Thanh tiêu đề gốc';

  @override
  String get blocked => 'Blocked';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count events',
      one: '1 event',
      zero: 'No events',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Nhập';

  @override
  String get confirmImport => 'Are you sure you want to import it?';

  @override
  String get welcome => 'Welcome';

  @override
  String get url => 'URL';

  @override
  String get username => 'Tên người dùng';

  @override
  String get password => 'Mật khẩu';

  @override
  String get connect => 'Kết nối';

  @override
  String get data => 'Dữ liệu';

  @override
  String get syncing => 'Syncing';

  @override
  String get synced => 'Đã đồng bộ';

  @override
  String get error => 'Lỗi';

  @override
  String get always => 'Luôn luôn';

  @override
  String get noMobile => 'Không dữ liệu di động';

  @override
  String get manual => 'Thủ công';

  @override
  String get syncMode => 'Chế độ đồng bộ';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Appointment';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Time';

  @override
  String deleteEvent(String name) {
    return 'Delete event $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Are you sure you want to delete the event $name?';
  }

  @override
  String get createAppointment => 'Create appointment';

  @override
  String get editAppointment => 'Edit appointment';

  @override
  String get createMoment => 'Create moment';

  @override
  String get editMoment => 'Edit moment';

  @override
  String get convertToNote => 'Convert to note';

  @override
  String get convertToTodo => 'Convert to todo';

  @override
  String get open => 'Mở';

  @override
  String get limited => 'Limited';

  @override
  String get notSet => 'Chưa đặt';

  @override
  String get createPending => 'Create pending';

  @override
  String get editPending => 'Edit pending';

  @override
  String get convertTo => 'Convert to';

  @override
  String get comingSoon => 'Coming soon';

  @override
  String get notSupported => 'Not supported';

  @override
  String get databaseVersion => 'Database version';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Khôi phục';

  @override
  String get markdownIsSupported => 'Markdown is supported';

  @override
  String get createLabel => 'Create label';

  @override
  String get editLabel => 'Edit label';

  @override
  String deleteLabel(String name) {
    return 'Delete label $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Are you sure you want to delete the label $name?';
  }

  @override
  String get label => 'Nhãn';

  @override
  String get startOfWeek => 'Start of week';

  @override
  String headlineNumber(int number) {
    return 'Tiêu đề $number';
  }

  @override
  String get bold => 'In đậm';

  @override
  String get italic => 'In nghiêng';

  @override
  String get strikethrough => 'Gạch ngang';

  @override
  String get code => 'Mã';

  @override
  String get link => 'Liên kết';

  @override
  String get codeBlock => 'Code block';

  @override
  String get quote => 'Trích dẫn';

  @override
  String get numberedList => 'Numbered list';

  @override
  String get density => 'Mật độ';

  @override
  String get compact => 'Gọn';

  @override
  String get comfortable => 'Thoải mái';

  @override
  String get standard => 'Tiêu chuẩn';

  @override
  String get highContrast => 'Độ tương phản cao';

  @override
  String get labels => 'Labels';

  @override
  String get systemLocale => 'Ngôn ngữ hệ thống';

  @override
  String get notebooks => 'Notebooks';

  @override
  String get createNotebook => 'Create notebook';

  @override
  String get editNotebook => 'Edit notebook';

  @override
  String get update => 'Cập nhật';

  @override
  String get currentVersion => 'Phiên bản hiện tại';

  @override
  String get checkForUpdates => 'Kiểm tra cập nhật';

  @override
  String get checkForUpdatesWarning =>
      'Performing a check for updates will connect to the Flow website to get the information.';

  @override
  String get usingLatestStable => 'Bạn đang dùng phiên bản ổn định mới nhất';

  @override
  String get usingLatestNightly => 'Bạn đang dùng phiên bản nightly mới nhất';

  @override
  String get updateNow => 'Cập nhật ngay';

  @override
  String get stable => 'Ổn định';

  @override
  String get nightly => 'Nightly';

  @override
  String get updateAvailable => 'Đã có bản cập nhật';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '1 item',
      zero: 'No items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'System theme';

  @override
  String get desktop => 'Máy tính';

  @override
  String get restoreSettingsFromFile => 'Khôi phục cài đặt từ tệp tin';

  @override
  String get exportSettingsToFile => 'Xuất cài đặt ra tệp tin';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Enabled';

  @override
  String get countdown => 'Countdown';

  @override
  String get unlink => 'Unlink';

  @override
  String get noAlarms => 'There are no alarms to display.';

  @override
  String get allDay => 'All day';
}
