// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Ukrainian (`uk`).
class AppLocalizationsUk extends AppLocalizations {
  AppLocalizationsUk([String locale = 'uk']) : super(locale);

  @override
  String get dashboard => 'Приладна дошка';

  @override
  String get translate => 'Переклад';

  @override
  String get calendar => 'Календар';

  @override
  String get resources => 'Ресурси';

  @override
  String get users => 'Спільноти';

  @override
  String get user => 'Користувач';

  @override
  String get sources => 'Джерела';

  @override
  String get settings => 'Налаштування';

  @override
  String get create => 'Створити';

  @override
  String get information => 'Інформація про нас';

  @override
  String get source => 'Джерело';

  @override
  String get license => 'Ліцензія';

  @override
  String get thirdPartyLicenses => 'Ліцензії третіх сторін';

  @override
  String get documentation => 'Документація';

  @override
  String get privacyPolicy => 'Політика конфіденційності';

  @override
  String get imprint => 'Відомості';

  @override
  String get releaseNotes => 'Примітки до релізу';

  @override
  String get changelog => 'Список змін';

  @override
  String get legal => 'Юридичні';

  @override
  String get personalization => 'Персоналізація';

  @override
  String get design => 'Дизайн';

  @override
  String get language => 'Мова:';

  @override
  String get theme => 'Тема';

  @override
  String get classic => 'Класичний';

  @override
  String get systemDefault => 'Системна по замовчуванню';

  @override
  String get light => 'Світла';

  @override
  String get dark => 'Темна';

  @override
  String get createResource => 'Створити ресурс';

  @override
  String get cancel => 'Скасувати';

  @override
  String get name => 'Ім\'я';

  @override
  String get description => 'Опис';

  @override
  String get start => 'Старт';

  @override
  String get next => 'Уперед';

  @override
  String get skip => 'Пропустити';

  @override
  String get back => 'Відмінити';

  @override
  String get today => 'Сьогодні';

  @override
  String get groups => 'Групи';

  @override
  String get createGroup => 'Створити групу';

  @override
  String get editGroup => 'Редагувати групу';

  @override
  String get list => 'Список';

  @override
  String get day => 'День';

  @override
  String get week => 'Тижні';

  @override
  String get month => 'Місяць';

  @override
  String get version => 'Версія';

  @override
  String get intro => 'Вступ';

  @override
  String get caldavDescription =>
      'Інтерфейс CalDAV надає доступ до ваших даних з будь-якого сервера CalDAV. Він має обмежену підтримку і підтримується тільки основні функції. Ви можете використовувати його для синхронізації ваших даних з іншими пристроями або сервісами.';

  @override
  String get webdavDescription =>
      'Інтерфейс WebDAV дозволяє отримати доступ до ваших даних з будь-якого сервера WebDAV. Файли та директорії для зберігання даних. Ви можете використовувати їх для синхронізації ваших даних з іншими пристроями або сервісами.';

  @override
  String get server => 'Сервер';

  @override
  String get serverDescription =>
      'Синхронізація даних з рідним сервером Linwood Flow. Рекомендується для користувачів, які хочуть самотужки їх дані.';

  @override
  String get googleDescription =>
      'Синхронізуйте ваші дані з Google. Це рекомендується для користувачів, які хочуть використовувати свій обліковий запис Google, щоб отримати доступ до їх даних. Не всі функції доступні для цієї опції.';

  @override
  String get microsoftDescription =>
      'Синхронізуйте свої дані з Microsoft. Рекомендується для користувачів, які хочуть використовувати свій обліковий запис Microsoft, щоб отримати доступ до їх даних. Не всі функції доступні для цієї опції.';

  @override
  String get addSource => 'Додати джерело';

  @override
  String get local => 'Місцевий';

  @override
  String get close => 'Закрити';

  @override
  String get unknown => 'Не вказано';

  @override
  String get loading => 'Завантаження';

  @override
  String get export => 'Експорт';

  @override
  String get createEvent => 'Створити подію';

  @override
  String get save => 'Зберегти';

  @override
  String get allSources => 'Всі джерела';

  @override
  String get editEvent => 'Редагувати подію';

  @override
  String get end => 'Кінець';

  @override
  String get location => 'Місцезнаходження';

  @override
  String get status => 'Статус';

  @override
  String get confirmed => 'Підтверджений';

  @override
  String get draft => 'Креслення';

  @override
  String get cancelled => 'Скасовано';

  @override
  String get general => 'Загальні налаштування';

  @override
  String get notes => 'Нотатки';

  @override
  String get createNote => 'Створити нотатку';

  @override
  String get editNote => 'Редагувати нотатку';

  @override
  String get indicatorEmpty => 'Нічого не знайдено';

  @override
  String get indicatorEmptyDescription => 'Список наразі порожній.';

  @override
  String get indicatorLoading => 'Завантаження';

  @override
  String get indicatorError => 'Виникла помилка';

  @override
  String get indicatorErrorDescription =>
      'Сталася помилка під час завантаження даних.';

  @override
  String get tryAgain => 'Спробуйте ще раз';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event $date о $time в $location ($status)';
  }

  @override
  String get filter => 'Фільтр';

  @override
  String get done => 'Виконано';

  @override
  String get inProgress => 'Обробка';

  @override
  String get note => 'Примітка';

  @override
  String get delete => 'Видалити';

  @override
  String get edit => 'Редагувати';

  @override
  String deleteGroup(String name) {
    return 'Видалити групу $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Ви дійсно бажаєте видалити групу $name?';
  }

  @override
  String groupName(String name) {
    return 'Група $name';
  }

  @override
  String get noData => 'Немає даних для відображення.';

  @override
  String get noEvents => 'Немає подій для відображення.';

  @override
  String get group => 'Група';

  @override
  String get search => 'Пошук';

  @override
  String get events => 'Події';

  @override
  String get past => 'Минуле';

  @override
  String get decentralized => 'Децентралізовано';

  @override
  String get decentralizedDescription =>
      'Децентралізований інтерфейс дозволяє отримати доступ до ваших даних з будь-якого децентралізованого сервера. Ви можете використовувати його для синхронізації ваших даних з іншими пристроями або сервісами.';

  @override
  String get importFile => 'Імпортувати файл';

  @override
  String get importFileDescription =>
      'Імпортуйте файл з вашого пристрою. Ви можете імпортувати файл бази даних з іншого файлу Linwood Flow екземпляра або звичний файл календаря.';

  @override
  String get icalDescription =>
      'Інтерфейс iCal дозволяє вам отримати доступ до ваших даних з будь-якого сервера iCal. Він може читати лише дані і не підтримує запис. Ви можете використати його для синхронізації даних з іншими пристроями чи службами, які не підтримують CalDAV.';

  @override
  String get resource => 'Ресурси';

  @override
  String get editResource => 'Редагувати ресурс';

  @override
  String deleteResource(String name) {
    return 'Видалити ресурс $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Ви дійсно бажаєте видалити ресурс $name?';
  }

  @override
  String get priority => 'Пріоритет';

  @override
  String get assignEvent => 'Призначити подію';

  @override
  String get noEvent => 'Немає подій';

  @override
  String get parentGroup => 'Батьківська група';

  @override
  String deleteUser(String name) {
    return 'Видалити користувача $name';
  }

  @override
  String get createUser => 'Створити користувача';

  @override
  String get editUser => 'Редагувати користувача';

  @override
  String deleteUserDescription(String name) {
    return 'Ви дійсно бажаєте видалити користувача $name?';
  }

  @override
  String get pending => 'Очікує підтвердження';

  @override
  String get removeEvent => 'Видалити подію';

  @override
  String get event => 'Подія';

  @override
  String get nativeTitleBar => 'Область заголовка';

  @override
  String get blocked => 'Заблоковано';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count події',
      one: '1 подія',
      zero: 'Немає подій',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Імпорт';

  @override
  String get confirmImport => 'Ви впевнені, що хочете імпортувати його?';

  @override
  String get welcome => 'Вітаємо';

  @override
  String get url => 'Адреса';

  @override
  String get username => 'Ім\'я користувача';

  @override
  String get password => 'Пароль';

  @override
  String get connect => 'Підключитися';

  @override
  String get data => 'Дані';

  @override
  String get syncing => 'Синхронізація';

  @override
  String get synced => 'Синхронізовано';

  @override
  String get error => 'Помилка';

  @override
  String get always => 'Завжди';

  @override
  String get noMobile => 'Немає мобільного телефону';

  @override
  String get manual => 'Вручну';

  @override
  String get syncMode => 'Режим синхронізації';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Посада';

  @override
  String get moment => 'Момент';

  @override
  String get time => 'Час';

  @override
  String deleteEvent(String name) {
    return 'Видалити подію $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Ви дійсно бажаєте видалити подію $name?';
  }

  @override
  String get createAppointment => 'Створити зустріч';

  @override
  String get editAppointment => 'Редагувати зустріч';

  @override
  String get createMoment => 'Створити момент';

  @override
  String get editMoment => 'Змінити момент';

  @override
  String get convertToNote => 'Конвертувати в нотатку';

  @override
  String get convertToTodo => 'Перетворити на todo';

  @override
  String get open => 'Відкриті';

  @override
  String get limited => 'Обмежений';

  @override
  String get notSet => 'Не задано';

  @override
  String get createPending => 'Створити в очікуванні';

  @override
  String get editPending => 'Редагування в очікуванні';

  @override
  String get convertTo => 'Конвертувати в';

  @override
  String get comingSoon => 'Чекайте вже скоро';

  @override
  String get notSupported => 'Не підтримується';

  @override
  String get databaseVersion => 'Версія бази даних';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Відновити';

  @override
  String get markdownIsSupported => 'Markdown підтримується';

  @override
  String get createLabel => 'Створити мітку';

  @override
  String get editLabel => 'Редагувати мітку';

  @override
  String deleteLabel(String name) {
    return 'Видалити мітку $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Ви дійсно бажаєте видалити мітку $name?';
  }

  @override
  String get label => 'Мітка';

  @override
  String get startOfWeek => 'Початок тижня';

  @override
  String headlineNumber(int number) {
    return 'Заголовок $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Закреслений';

  @override
  String get code => 'Код';

  @override
  String get link => 'Лінк';

  @override
  String get codeBlock => 'Блок коду';

  @override
  String get quote => 'Цитувати';

  @override
  String get numberedList => 'Нумерований список';

  @override
  String get density => 'Густина';

  @override
  String get compact => 'Компактний';

  @override
  String get comfortable => 'Комфортний';

  @override
  String get standard => 'Стандартна';

  @override
  String get highContrast => 'Високий контраст';

  @override
  String get labels => 'Мітки';

  @override
  String get systemLocale => 'Мова локалізації системи';

  @override
  String get notebooks => 'Ноутбуки';

  @override
  String get createNotebook => 'Створити зошит';

  @override
  String get editNotebook => 'Редагувати блокнот';

  @override
  String get update => 'Оновити';

  @override
  String get currentVersion => 'Поточна версія';

  @override
  String get checkForUpdates => 'Перевірити наявність оновлень';

  @override
  String get checkForUpdatesWarning =>
      'Перевірка оновлень з’єднується з веб-сайтом Flow для отримання інформації.';

  @override
  String get usingLatestStable => 'Ви використовуєте останню стабільну версію';

  @override
  String get usingLatestNightly => 'Ви використовуєте останню нічну версію';

  @override
  String get updateNow => 'Оновити зараз';

  @override
  String get stable => 'Стабільний';

  @override
  String get nightly => 'Нічна';

  @override
  String get updateAvailable => 'Доступне оновлення';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count елементи',
      one: '1 об\'єкт',
      zero: 'Немає елементів',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Системна тема';

  @override
  String get desktop => 'Стільниця';

  @override
  String get restoreSettingsFromFile => 'Відновити налаштування з файлу';

  @override
  String get exportSettingsToFile => 'Експорт налаштувань у файл';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Увімкнено';

  @override
  String get countdown => 'Зворотний відлік';

  @override
  String get unlink => 'Розірвання зв\'язку';

  @override
  String get noAlarms => 'Немає будильників для відображення.';

  @override
  String get allDay => 'Увесь день';
}
