// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Swedish (`sv`).
class AppLocalizationsSv extends AppLocalizations {
  AppLocalizationsSv([String locale = 'sv']) : super(locale);

  @override
  String get dashboard => 'Instrumentpanel';

  @override
  String get translate => 'Översätt';

  @override
  String get calendar => 'Kalender';

  @override
  String get resources => 'Resurser';

  @override
  String get users => 'Användare';

  @override
  String get user => 'Användare';

  @override
  String get sources => 'Källor';

  @override
  String get settings => 'Inställningar';

  @override
  String get create => 'Skapa';

  @override
  String get information => 'Information';

  @override
  String get source => 'Källa';

  @override
  String get license => 'Licens';

  @override
  String get thirdPartyLicenses => 'Licenser för tredje part';

  @override
  String get documentation => 'Dokumentation';

  @override
  String get privacyPolicy => 'Integritetspolicy';

  @override
  String get imprint => 'Avtryck';

  @override
  String get releaseNotes => 'Kommentarer till utgåvan';

  @override
  String get changelog => 'Ändringslogg';

  @override
  String get legal => 'Juridisk';

  @override
  String get personalization => 'Personalisering';

  @override
  String get design => 'Design';

  @override
  String get language => 'Språk';

  @override
  String get theme => 'Tema';

  @override
  String get classic => 'Klassisk';

  @override
  String get systemDefault => 'Systemets standard';

  @override
  String get light => 'Ljus';

  @override
  String get dark => 'Mörk';

  @override
  String get createResource => 'Skapa resurs';

  @override
  String get cancel => 'Avbryt';

  @override
  String get name => 'Namn';

  @override
  String get description => 'Beskrivning';

  @override
  String get start => 'Starta';

  @override
  String get next => 'Nästa';

  @override
  String get skip => 'Hoppa';

  @override
  String get back => 'Tillbaka';

  @override
  String get today => 'Idag';

  @override
  String get groups => 'Grupper';

  @override
  String get createGroup => 'Skapa grupp';

  @override
  String get editGroup => 'Redigera grupp';

  @override
  String get list => 'Lista';

  @override
  String get day => 'Dag';

  @override
  String get week => 'Vecka';

  @override
  String get month => 'Månad';

  @override
  String get version => 'Version';

  @override
  String get intro => 'Introduktion';

  @override
  String get caldavDescription =>
      'CalDAV-gränssnittet låter dig komma åt dina data från alla CalDAV-servrar. Det har begränsat stöd och endast grundläggande funktioner stöds. Du kan använda det för att synkronisera dina data med andra enheter eller tjänster.';

  @override
  String get webdavDescription =>
      'Med WebDAV-gränssnittet kan du komma åt dina data från vilken WebDAV-server som helst. Det filer och kataloger att lagra data. Du kan använda den för att synkronisera dina data med andra enheter eller tjänster.';

  @override
  String get server => 'Server';

  @override
  String get serverDescription =>
      'Synkronisera dina data med en infödd Linwood Flow-server. Detta rekommenderas för användare som själv vill vara värd för sina data.';

  @override
  String get googleDescription =>
      'Synkronisera dina data med Google. Detta rekommenderas för användare som vill använda sitt Google-konto för att komma åt sina data. Alla funktioner är inte tillgängliga med det här alternativet.';

  @override
  String get microsoftDescription =>
      'Synkronisera dina data med Microsoft. Detta rekommenderas för användare som vill använda sitt Microsoft-konto för att komma åt sina data. Alla funktioner är inte tillgängliga med det här alternativet.';

  @override
  String get addSource => 'Lägg till källa';

  @override
  String get local => 'Lokal';

  @override
  String get close => 'Stäng';

  @override
  String get unknown => 'Okänd';

  @override
  String get loading => 'Laddar';

  @override
  String get export => 'Exportera';

  @override
  String get createEvent => 'Skapa händelse';

  @override
  String get save => 'Spara';

  @override
  String get allSources => 'Alla källor';

  @override
  String get editEvent => 'Redigera händelse';

  @override
  String get end => 'Slut';

  @override
  String get location => 'Plats';

  @override
  String get status => 'Status';

  @override
  String get confirmed => 'Bekräftad';

  @override
  String get draft => 'Utkast';

  @override
  String get cancelled => 'Avbruten';

  @override
  String get general => 'Allmänt';

  @override
  String get notes => 'Anteckningar';

  @override
  String get createNote => 'Skapa anteckning';

  @override
  String get editNote => 'Redigera anteckning';

  @override
  String get indicatorEmpty => 'Inga objekt hittades';

  @override
  String get indicatorEmptyDescription => 'Listan är för närvarande tom.';

  @override
  String get indicatorLoading => 'Laddar';

  @override
  String get indicatorError => 'Ett fel uppstod';

  @override
  String get indicatorErrorDescription =>
      'Ett fel inträffade vid inläsning av data.';

  @override
  String get tryAgain => 'Försök igen';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event den $date kl. $time i $location ($status)';
  }

  @override
  String get filter => 'Filtrera';

  @override
  String get done => 'Klar';

  @override
  String get inProgress => 'pågår';

  @override
  String get note => 'Anteckning';

  @override
  String get delete => 'Radera';

  @override
  String get edit => 'Redigera';

  @override
  String deleteGroup(String name) {
    return 'Ta bort grupp $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Är du säker på att du vill ta bort gruppen $name?';
  }

  @override
  String groupName(String name) {
    return 'Grupp $name';
  }

  @override
  String get noData => 'Det finns inga data att visa.';

  @override
  String get noEvents => 'Det finns inga händelser att visa.';

  @override
  String get group => 'Grupp';

  @override
  String get search => 'Sök';

  @override
  String get events => 'Händelser';

  @override
  String get past => 'Tidigare';

  @override
  String get decentralized => 'Decentraliserad';

  @override
  String get decentralizedDescription =>
      'Det decentraliserade gränssnittet ger dig tillgång till dina data från alla decentraliserade servrar. Du kan använda den för att synkronisera dina data med andra enheter eller tjänster.';

  @override
  String get importFile => 'Importera fil';

  @override
  String get importFileDescription =>
      'Importera en fil från din enhet. Du kan importera en databasfil från en annan Linwood Flow-instans eller en vanlig kalenderfil.';

  @override
  String get icalDescription =>
      'Med iCal-gränssnittet kan du komma åt dina data från alla iCal-servrar. Det kan bara läsa data och stöder inte skrivning. Du kan använda den för att synkronisera dina data med andra enheter eller tjänster som inte stöder CalDAV.';

  @override
  String get resource => 'Resurs';

  @override
  String get editResource => 'Redigera resurs';

  @override
  String deleteResource(String name) {
    return 'Ta bort resurs $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Är du säker på att du vill radera resursen $name?';
  }

  @override
  String get priority => 'Prioritet';

  @override
  String get assignEvent => 'Tilldela händelse';

  @override
  String get noEvent => 'Ingen händelse';

  @override
  String get parentGroup => 'Överordnad grupp';

  @override
  String deleteUser(String name) {
    return 'Ta bort användare $name';
  }

  @override
  String get createUser => 'Skapa användare';

  @override
  String get editUser => 'Redigera användare';

  @override
  String deleteUserDescription(String name) {
    return 'Är du säker på att du vill ta bort användaren $name?';
  }

  @override
  String get pending => 'Väntande';

  @override
  String get removeEvent => 'Ta bort händelse';

  @override
  String get event => 'Händelse';

  @override
  String get nativeTitleBar => 'Namnfält med ursprungsbeteckning';

  @override
  String get blocked => 'Blockerad';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count händelser',
      one: '1 händelse',
      zero: 'Inga händelser',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importera';

  @override
  String get confirmImport => 'Är du säker du vill importera den?';

  @override
  String get welcome => 'Välkommen';

  @override
  String get url => 'URL';

  @override
  String get username => 'Användarnamn';

  @override
  String get password => 'Lösenord';

  @override
  String get connect => 'Anslut';

  @override
  String get data => 'Data';

  @override
  String get syncing => 'Synkroniserar';

  @override
  String get synced => 'Synkroniserad';

  @override
  String get error => 'Fel';

  @override
  String get always => 'Alltid';

  @override
  String get noMobile => 'Ingen mobil';

  @override
  String get manual => 'Manuell';

  @override
  String get syncMode => 'Synkronisera läge';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Utnämning';

  @override
  String get moment => 'Ögonblick';

  @override
  String get time => 'Tid';

  @override
  String deleteEvent(String name) {
    return 'Ta bort händelse $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Är du säker på att du vill radera händelsen $name?';
  }

  @override
  String get createAppointment => 'Skapa tid';

  @override
  String get editAppointment => 'Redigera tid';

  @override
  String get createMoment => 'Skapa ögonblick';

  @override
  String get editMoment => 'Redigera ögonblick';

  @override
  String get convertToNote => 'Konvertera till anteckning';

  @override
  String get convertToTodo => 'Konvertera till todo';

  @override
  String get open => 'Öppna';

  @override
  String get limited => 'Begränsad';

  @override
  String get notSet => 'Ej inställd';

  @override
  String get createPending => 'Skapa väntande';

  @override
  String get editPending => 'Redigera väntande';

  @override
  String get convertTo => 'Konvertera till';

  @override
  String get comingSoon => 'Kommer snart';

  @override
  String get notSupported => 'Stöds inte';

  @override
  String get databaseVersion => 'Databasens version';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Återställ';

  @override
  String get markdownIsSupported => 'Markdown stöds';

  @override
  String get createLabel => 'Skapa etikett';

  @override
  String get editLabel => 'Redigera etikett';

  @override
  String deleteLabel(String name) {
    return 'Ta bort etikett $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Är du säker på att du vill ta bort etiketten $name?';
  }

  @override
  String get label => 'Etikett';

  @override
  String get startOfWeek => 'Början av veckan';

  @override
  String headlineNumber(int number) {
    return 'Rubrik $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Genomstruken';

  @override
  String get code => 'Kod';

  @override
  String get link => 'Länk';

  @override
  String get codeBlock => 'Kod block';

  @override
  String get quote => 'Offert';

  @override
  String get numberedList => 'Numrerad lista';

  @override
  String get density => 'Densitet';

  @override
  String get compact => 'Kompakt';

  @override
  String get comfortable => 'Bekväm';

  @override
  String get standard => 'Standard';

  @override
  String get highContrast => 'Hög kontrast';

  @override
  String get labels => 'Etiketter';

  @override
  String get systemLocale => 'Systemets språk';

  @override
  String get notebooks => 'Anteckningsböcker';

  @override
  String get createNotebook => 'Skapa anteckningsbok';

  @override
  String get editNotebook => 'Redigera anteckningsbok';

  @override
  String get update => 'Uppdatera';

  @override
  String get currentVersion => 'Nuvarande version';

  @override
  String get checkForUpdates => 'Sök efter uppdateringar';

  @override
  String get checkForUpdatesWarning =>
      'Utföra en sökning efter uppdateringar kommer att ansluta till Flow-webbplatsen för att få informationen.';

  @override
  String get usingLatestStable => 'Du använder den senaste stabila versionen';

  @override
  String get usingLatestNightly => 'Du använder den senaste nattliga versionen';

  @override
  String get updateNow => 'Uppdatera nu';

  @override
  String get stable => 'Stabil';

  @override
  String get nightly => 'Nattlig';

  @override
  String get updateAvailable => 'Uppdatering tillgänglig';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count artiklar',
      one: '1 artikel',
      zero: 'Inga artiklar',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Systemets tema';

  @override
  String get desktop => 'Skrivbord';

  @override
  String get restoreSettingsFromFile => 'Återställ inställningar från fil';

  @override
  String get exportSettingsToFile => 'Exportera inställningar till fil';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Aktiverad';

  @override
  String get countdown => 'Nedräkning';

  @override
  String get unlink => 'Avlänka';

  @override
  String get noAlarms => 'Det finns inga alarm att visa.';

  @override
  String get allDay => 'Hela dagen';
}
