// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Polish (`pl`).
class AppLocalizationsPl extends AppLocalizations {
  AppLocalizationsPl([String locale = 'pl']) : super(locale);

  @override
  String get dashboard => 'Pulpit';

  @override
  String get translate => 'Przetłumacz';

  @override
  String get calendar => 'Kalendarz';

  @override
  String get resources => 'Zasoby';

  @override
  String get users => 'Użytkownicy';

  @override
  String get user => 'Użytkownik';

  @override
  String get sources => 'Źródła';

  @override
  String get settings => 'Ustawienia';

  @override
  String get create => 'Utwórz';

  @override
  String get information => 'Informacje';

  @override
  String get source => 'Źródło';

  @override
  String get license => 'Licencja';

  @override
  String get thirdPartyLicenses => 'Licencje osób trzecich';

  @override
  String get documentation => 'Dokumentacja';

  @override
  String get privacyPolicy => 'Polityka prywatności';

  @override
  String get imprint => 'Nadruk';

  @override
  String get releaseNotes => 'Informacje o wydaniu';

  @override
  String get changelog => 'Lista zmian';

  @override
  String get legal => 'Prawne';

  @override
  String get personalization => 'Personalizacja';

  @override
  String get design => 'Projekt';

  @override
  String get language => 'Język';

  @override
  String get theme => 'Motyw';

  @override
  String get classic => 'Klasyczny';

  @override
  String get systemDefault => 'Domyślne systemowe';

  @override
  String get light => 'Światło';

  @override
  String get dark => 'Ciemny';

  @override
  String get createResource => 'Utwórz zasób';

  @override
  String get cancel => 'Anuluj';

  @override
  String get name => 'Nazwisko';

  @override
  String get description => 'Opis';

  @override
  String get start => 'Rozpocznij';

  @override
  String get next => 'Następny';

  @override
  String get skip => 'Pomiń';

  @override
  String get back => 'Powrót';

  @override
  String get today => 'Dziś';

  @override
  String get groups => 'Grupy';

  @override
  String get createGroup => 'Utwórz grupę';

  @override
  String get editGroup => 'Edytuj grupę';

  @override
  String get list => 'Lista';

  @override
  String get day => 'Dzień';

  @override
  String get week => 'Tydzień';

  @override
  String get month => 'Miesiąc';

  @override
  String get version => 'Wersja';

  @override
  String get intro => 'Wprowadzenie';

  @override
  String get caldavDescription =>
      'Interfejs CalDAV umożliwia dostęp do danych z dowolnego serwera CalDAV. Ma ograniczone wsparcie i obsługiwane są tylko podstawowe funkcje. Możesz je użyć do synchronizacji swoich danych z innymi urządzeniami lub usługami.';

  @override
  String get webdavDescription =>
      'Interfejs WebDAV umożliwia dostęp do danych z dowolnego serwera WebDAV. Pliki i katalogi do przechowywania danych. Możesz je użyć do synchronizacji swoich danych z innymi urządzeniami lub usługami.';

  @override
  String get server => 'Serwer';

  @override
  String get serverDescription =>
      'Synchronizuj swoje dane z natywnym serwerem Linwood Flow. Jest to zalecane dla użytkowników, którzy chcą samodzielnie hostować swoje dane.';

  @override
  String get googleDescription =>
      'Synchronizuj swoje dane z Google. Jest to zalecane dla użytkowników, którzy chcą używać swojego konta Google, aby uzyskać dostęp do swoich danych. Nie wszystkie funkcje są dostępne w tej opcji.';

  @override
  String get microsoftDescription =>
      'Synchronizuj swoje dane z Microsoft. Jest to zalecane dla użytkowników, którzy chcą używać swojego konta Microsoft, aby uzyskać dostęp do swoich danych. Nie wszystkie funkcje są dostępne w tej opcji.';

  @override
  String get addSource => 'Dodaj źródło';

  @override
  String get local => 'Lokalny';

  @override
  String get close => 'Zamknij';

  @override
  String get unknown => 'Nieznane';

  @override
  String get loading => 'Ładowanie';

  @override
  String get export => 'Eksportuj';

  @override
  String get createEvent => 'Utwórz wydarzenie';

  @override
  String get save => 'Zapisz';

  @override
  String get allSources => 'Wszystkie źródła';

  @override
  String get editEvent => 'Edytuj wydarzenie';

  @override
  String get end => 'Koniec';

  @override
  String get location => 'Lokalizacja';

  @override
  String get status => 'Status';

  @override
  String get confirmed => 'Potwierdzone';

  @override
  String get draft => 'Szkic';

  @override
  String get cancelled => 'Anulowane';

  @override
  String get general => 'Ogólny';

  @override
  String get notes => 'Uwagi';

  @override
  String get createNote => 'Utwórz notatkę';

  @override
  String get editNote => 'Edytuj notatkę';

  @override
  String get indicatorEmpty => 'Nie znaleziono elementów';

  @override
  String get indicatorEmptyDescription => 'Lista jest obecnie pusta.';

  @override
  String get indicatorLoading => 'Ładowanie';

  @override
  String get indicatorError => 'Wystąpił błąd';

  @override
  String get indicatorErrorDescription =>
      'Wystąpił błąd podczas ładowania danych.';

  @override
  String get tryAgain => 'Spróbuj ponownie';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event dnia $date o $time w $location ($status)';
  }

  @override
  String get filter => 'Filtr';

  @override
  String get done => 'Gotowe';

  @override
  String get inProgress => 'W toku';

  @override
  String get note => 'Uwaga';

  @override
  String get delete => 'Usuń';

  @override
  String get edit => 'Edytuj';

  @override
  String deleteGroup(String name) {
    return 'Usuń grupę $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Czy na pewno chcesz usunąć grupę $name?';
  }

  @override
  String groupName(String name) {
    return 'Grupa $name';
  }

  @override
  String get noData => 'Brak danych do wyświetlenia.';

  @override
  String get noEvents => 'Brak wydarzeń do wyświetlenia.';

  @override
  String get group => 'Grupa';

  @override
  String get search => 'Szukaj';

  @override
  String get events => 'Wydarzenia';

  @override
  String get past => 'W przeszłości';

  @override
  String get decentralized => 'Zdecentralizowany';

  @override
  String get decentralizedDescription =>
      'Interfejs zdecentralizowany umożliwia dostęp do danych z dowolnego zdecentralizowanego serwera. Możesz go użyć do synchronizacji swoich danych z innymi urządzeniami lub usługami.';

  @override
  String get importFile => 'Importuj plik';

  @override
  String get importFileDescription =>
      'Importuj plik z urządzenia. Możesz zaimportować plik bazy danych z innej instancji Linwood Flow lub zwykłego pliku kalendarza.';

  @override
  String get icalDescription =>
      'Interfejs iCal umożliwia dostęp do Twoich danych z dowolnego serwera iCal. Może tylko odczytywać dane i nie obsługuje zapisu. Możesz go użyć do synchronizacji swoich danych z innymi urządzeniami lub usługami, które nie obsługują CalDAV.';

  @override
  String get resource => 'Zasoby';

  @override
  String get editResource => 'Edytuj zasób';

  @override
  String deleteResource(String name) {
    return 'Usuń zasób $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Czy na pewno chcesz usunąć zasób $name?';
  }

  @override
  String get priority => 'Priorytet';

  @override
  String get assignEvent => 'Przypisz wydarzenie';

  @override
  String get noEvent => 'Brak wydarzenia';

  @override
  String get parentGroup => 'Grupa nadrzędna';

  @override
  String deleteUser(String name) {
    return 'Usuń użytkownika $name';
  }

  @override
  String get createUser => 'Utwórz użytkownika';

  @override
  String get editUser => 'Edytuj użytkownika';

  @override
  String deleteUserDescription(String name) {
    return 'Czy na pewno chcesz usunąć użytkownika $name?';
  }

  @override
  String get pending => 'Oczekujące';

  @override
  String get removeEvent => 'Usuń wydarzenie';

  @override
  String get event => 'Wydarzenie';

  @override
  String get nativeTitleBar => 'Natywny pasek tytułu';

  @override
  String get blocked => 'Zablokowane';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count wydarzenia',
      one: '1 wydarzenie',
      zero: 'Brak wydarzeń',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importuj';

  @override
  String get confirmImport => 'Czy na pewno chcesz go zaimportować?';

  @override
  String get welcome => 'Witaj';

  @override
  String get url => 'Adres URL';

  @override
  String get username => 'Nazwa użytkownika';

  @override
  String get password => 'Hasło';

  @override
  String get connect => 'Połącz';

  @override
  String get data => 'Dane';

  @override
  String get syncing => 'Synchronizowanie';

  @override
  String get synced => 'Zsynchronizowano';

  @override
  String get error => 'Błąd';

  @override
  String get always => 'Zawsze';

  @override
  String get noMobile => 'Brak mobilnych';

  @override
  String get manual => 'Ręcznie';

  @override
  String get syncMode => 'Tryb synchronizacji';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Mianowanie';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Czas';

  @override
  String deleteEvent(String name) {
    return 'Usuń wydarzenie $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Czy na pewno chcesz usunąć wydarzenie $name?';
  }

  @override
  String get createAppointment => 'Utwórz wizytę';

  @override
  String get editAppointment => 'Edytuj wizytę';

  @override
  String get createMoment => 'Utwórz moment';

  @override
  String get editMoment => 'Edytuj moment';

  @override
  String get convertToNote => 'Konwertuj na notatkę';

  @override
  String get convertToTodo => 'Konwertuj na zadanie';

  @override
  String get open => 'Otwórz';

  @override
  String get limited => 'Ograniczone';

  @override
  String get notSet => 'Nie ustawiono';

  @override
  String get createPending => 'Utwórz oczekujące';

  @override
  String get editPending => 'Edytuj oczekujące';

  @override
  String get convertTo => 'Konwertuj na';

  @override
  String get comingSoon => 'Już wkrótce';

  @override
  String get notSupported => 'Nie obsługiwane';

  @override
  String get databaseVersion => 'Wersja bazy danych';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Przywróć';

  @override
  String get markdownIsSupported => 'Markdown jest obsługiwany';

  @override
  String get createLabel => 'Utwórz etykietę';

  @override
  String get editLabel => 'Edytuj etykietę';

  @override
  String deleteLabel(String name) {
    return 'Usuń etykietę $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Czy na pewno chcesz usunąć etykietę $name?';
  }

  @override
  String get label => 'Etykieta';

  @override
  String get startOfWeek => 'Początek tygodnia';

  @override
  String headlineNumber(int number) {
    return 'Nagłówek $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Przekreślenie';

  @override
  String get code => 'Kod';

  @override
  String get link => 'Link';

  @override
  String get codeBlock => 'Blok kodu';

  @override
  String get quote => 'Oferta';

  @override
  String get numberedList => 'Lista numerowana';

  @override
  String get density => 'Gęstość';

  @override
  String get compact => 'Kompaktowy';

  @override
  String get comfortable => 'Komfortowalne';

  @override
  String get standard => 'Standardowy';

  @override
  String get highContrast => 'Wysoki kontrast';

  @override
  String get labels => 'Etykiety';

  @override
  String get systemLocale => 'Ustawienia regionalne systemu';

  @override
  String get notebooks => 'Notatniki';

  @override
  String get createNotebook => 'Utwórz notatnik';

  @override
  String get editNotebook => 'Edytuj notatnik';

  @override
  String get update => 'Aktualizuj';

  @override
  String get currentVersion => 'Aktualna wersja';

  @override
  String get checkForUpdates => 'Sprawdź aktualizacje';

  @override
  String get checkForUpdatesWarning =>
      'Sprawdzanie aktualizacji połączy się ze stroną Flow aby uzyskać informacje.';

  @override
  String get usingLatestStable => 'Używasz najnowszej stabilnej wersji';

  @override
  String get usingLatestNightly => 'Używasz najnowszej wersji nocnej';

  @override
  String get updateNow => 'Aktualizuj teraz';

  @override
  String get stable => 'Stabilność';

  @override
  String get nightly => 'Nocny';

  @override
  String get updateAvailable => 'Dostępna aktualizacja';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count przedmioty',
      one: '1 przedmiot',
      zero: 'Brak przedmiotów',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Szablon systemowy';

  @override
  String get desktop => 'Pulpit';

  @override
  String get restoreSettingsFromFile => 'Przywróć ustawienia z pliku';

  @override
  String get exportSettingsToFile => 'Eksportuj ustawienia do pliku';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Włączone';

  @override
  String get countdown => 'Odliczanie';

  @override
  String get unlink => 'Odłącz';

  @override
  String get noAlarms => 'Brak alarmów do wyświetlenia.';

  @override
  String get allDay => 'Cały dzień';
}
