// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Japanese (`ja`).
class AppLocalizationsJa extends AppLocalizations {
  AppLocalizationsJa([String locale = 'ja']) : super(locale);

  @override
  String get dashboard => 'ダッシュボード';

  @override
  String get translate => '翻訳する';

  @override
  String get calendar => 'カレンダー';

  @override
  String get resources => 'リソース';

  @override
  String get users => 'ユーザー';

  @override
  String get user => 'ユーザー';

  @override
  String get sources => 'ソース';

  @override
  String get settings => '設定';

  @override
  String get create => '作成';

  @override
  String get information => '情報';

  @override
  String get source => 'ソース';

  @override
  String get license => 'ライセンス';

  @override
  String get thirdPartyLicenses => 'サードパーティライセンス';

  @override
  String get documentation => 'ドキュメント';

  @override
  String get privacyPolicy => 'プライバシーポリシー';

  @override
  String get imprint => 'インプリント';

  @override
  String get releaseNotes => 'リリースノート';

  @override
  String get changelog => '更新履歴';

  @override
  String get legal => 'Legal';

  @override
  String get personalization => '個人設定';

  @override
  String get design => 'デザイン';

  @override
  String get language => '言語';

  @override
  String get theme => 'テーマ';

  @override
  String get classic => 'クラシック';

  @override
  String get systemDefault => 'システムのデフォルト';

  @override
  String get light => 'ライト';

  @override
  String get dark => 'ダーク';

  @override
  String get createResource => 'リソースを作成';

  @override
  String get cancel => 'キャンセル';

  @override
  String get name => '名前';

  @override
  String get description => '説明';

  @override
  String get start => '開始';

  @override
  String get next => '次へ';

  @override
  String get skip => 'スキップ';

  @override
  String get back => '戻る';

  @override
  String get today => '今日';

  @override
  String get groups => 'グループ';

  @override
  String get createGroup => 'グループを作成';

  @override
  String get editGroup => 'グループを編集';

  @override
  String get list => 'リスト';

  @override
  String get day => '日';

  @override
  String get week => '週';

  @override
  String get month => '月';

  @override
  String get version => 'バージョン';

  @override
  String get intro => 'はじめに';

  @override
  String get caldavDescription =>
      'CalDAV インターフェイスを使用すると、任意の CalDAV サーバーからデータにアクセスできます。 サポートは限られており、基本的な機能のみがサポートされています。データを他のデバイスやサービスと同期させるために使用できます。';

  @override
  String get webdavDescription =>
      'WebDAV インターフェイスを使用すると、任意の WebDAV サーバーからデータにアクセスできます。 データを保存するためのファイルとディレクトリです。データを他のデバイスやサービスと同期させるために使用できます。';

  @override
  String get server => 'サーバー';

  @override
  String get serverDescription =>
      'データをネイティブの Linwood Flow サーバーと同期します。自身のデータを自己ホストしたい場合には推奨します。';

  @override
  String get googleDescription =>
      'Googleとデータを同期します。Googleアカウントを使用してデータにアクセスする場合に推奨されます。 すべての機能がこのオプションで利用できるわけではありません。';

  @override
  String get microsoftDescription =>
      'データをMicrosoftと同期させます。Microsoftアカウントを使用してデータにアクセスする場合に推奨されます。 すべての機能がこのオプションで利用できるわけではありません。';

  @override
  String get addSource => 'ソースを追加';

  @override
  String get local => 'ローカル';

  @override
  String get close => '閉じる';

  @override
  String get unknown => '不明';

  @override
  String get loading => '読み込み中';

  @override
  String get export => 'エクスポート';

  @override
  String get createEvent => '予定を作成';

  @override
  String get save => '保存';

  @override
  String get allSources => 'すべてのソース';

  @override
  String get editEvent => '予定を編集';

  @override
  String get end => '終了';

  @override
  String get location => '場所';

  @override
  String get status => 'ステータス';

  @override
  String get confirmed => '確認済み';

  @override
  String get draft => 'ドラフト（下書き）';

  @override
  String get cancelled => 'キャンセルしました';

  @override
  String get general => '全般';

  @override
  String get notes => 'メモ';

  @override
  String get createNote => 'ノートを作成';

  @override
  String get editNote => 'ノートを編集';

  @override
  String get indicatorEmpty => 'アイテムが見つかりません';

  @override
  String get indicatorEmptyDescription => 'リストは現在空です。';

  @override
  String get indicatorLoading => '読み込み中';

  @override
  String get indicatorError => 'エラーが発生';

  @override
  String get indicatorErrorDescription => 'データの読み込み中にエラーが発生しました。';

  @override
  String get tryAgain => 'もう一度やり直してください';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event の $date に $time で $location ($status)';
  }

  @override
  String get filter => 'フィルター';

  @override
  String get done => '完了';

  @override
  String get inProgress => '進行中';

  @override
  String get note => 'メモ';

  @override
  String get delete => '削除';

  @override
  String get edit => '編集';

  @override
  String deleteGroup(String name) {
    return 'グループ $name を削除';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'グループ $name を削除してもよろしいですか？';
  }

  @override
  String groupName(String name) {
    return 'グループ $name';
  }

  @override
  String get noData => '表示するデータがありません。';

  @override
  String get noEvents => '表示するイベントはありません。';

  @override
  String get group => 'グループ';

  @override
  String get search => '検索';

  @override
  String get events => 'イベント';

  @override
  String get past => '過去';

  @override
  String get decentralized => '地方分権化';

  @override
  String get decentralizedDescription =>
      '分散型インターフェイスを使用すると、任意の分散型サーバーからデータにアクセスできます。 データを他のデバイスやサービスと同期させるために使用できます。';

  @override
  String get importFile => 'ファイルをインポート';

  @override
  String get importFileDescription =>
      'お使いのデバイスからファイルをインポートします。別のLinwood Flowインスタンスまたは通常のカレンダーファイルからデータベースファイルをインポートできます。';

  @override
  String get icalDescription =>
      'iCalインターフェイスを使用すると、任意のiCalサーバーからデータにアクセスできます。データの読み取りのみが可能で、書き込みはサポートされません。 CalDAV をサポートしていない他のデバイスやサービスとデータを同期するために使用できます。';

  @override
  String get resource => 'リソース';

  @override
  String get editResource => 'リソースを編集';

  @override
  String deleteResource(String name) {
    return 'リソース $nameを削除';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'リソース $nameを削除してもよろしいですか？';
  }

  @override
  String get priority => '優先度';

  @override
  String get assignEvent => 'イベントを割り当てる';

  @override
  String get noEvent => 'イベントはありません';

  @override
  String get parentGroup => '親グループ';

  @override
  String deleteUser(String name) {
    return 'ユーザー $name を削除';
  }

  @override
  String get createUser => 'ユーザーを作成';

  @override
  String get editUser => 'ユーザーを編集';

  @override
  String deleteUserDescription(String name) {
    return 'ユーザー $name を削除してもよろしいですか？';
  }

  @override
  String get pending => '保留中';

  @override
  String get removeEvent => 'イベントを削除';

  @override
  String get event => 'イベント';

  @override
  String get nativeTitleBar => 'ネイティブのタイトルバー';

  @override
  String get blocked => 'ブロック';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count イベント',
      one: '1 イベント',
      zero: 'イベント',
    );
    return '$_temp0';
  }

  @override
  String get import => 'インポート';

  @override
  String get confirmImport => 'インポートしてもよろしいですか？';

  @override
  String get welcome => 'ようこそ';

  @override
  String get url => 'URL';

  @override
  String get username => 'ユーザー名';

  @override
  String get password => 'パスワード';

  @override
  String get connect => '接続する';

  @override
  String get data => 'データ';

  @override
  String get syncing => '同期中';

  @override
  String get synced => '同期済み';

  @override
  String get error => 'エラー';

  @override
  String get always => '常に表示';

  @override
  String get noMobile => '携帯電話がありません';

  @override
  String get manual => 'マニュアル';

  @override
  String get syncMode => '同期モード';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => '予約';

  @override
  String get moment => 'Moment';

  @override
  String get time => '時刻';

  @override
  String deleteEvent(String name) {
    return 'イベント $name を削除';
  }

  @override
  String deleteEventDescription(String name) {
    return 'イベント $name を削除してもよろしいですか？';
  }

  @override
  String get createAppointment => '予約を作成';

  @override
  String get editAppointment => '予定を編集';

  @override
  String get createMoment => 'モーメントを作成';

  @override
  String get editMoment => '瞬間を編集';

  @override
  String get convertToNote => 'メモに変換';

  @override
  String get convertToTodo => 'Todoに変換';

  @override
  String get open => '開く';

  @override
  String get limited => '制限';

  @override
  String get notSet => '未設定';

  @override
  String get createPending => '保留中の作成';

  @override
  String get editPending => '保留中の編集';

  @override
  String get convertTo => '変換先';

  @override
  String get comingSoon => '近日公開';

  @override
  String get notSupported => '対応していません';

  @override
  String get databaseVersion => 'データベースのバージョン';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => '復元';

  @override
  String get markdownIsSupported => 'Markdown はサポートされています';

  @override
  String get createLabel => 'ラベルを作成';

  @override
  String get editLabel => 'ラベルを編集';

  @override
  String deleteLabel(String name) {
    return 'ラベル $name を削除';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'ラベル $name を削除してもよろしいですか？';
  }

  @override
  String get label => 'ラベル';

  @override
  String get startOfWeek => '週の始まり';

  @override
  String headlineNumber(int number) {
    return '見出し $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => '取り消し線';

  @override
  String get code => 'コード';

  @override
  String get link => 'リンク';

  @override
  String get codeBlock => 'コードブロック';

  @override
  String get quote => '引用';

  @override
  String get numberedList => '番号付きリスト';

  @override
  String get density => '解像度:';

  @override
  String get compact => 'コンパクト化';

  @override
  String get comfortable => '快適さ';

  @override
  String get standard => '標準';

  @override
  String get highContrast => '高コントラストformat@@0';

  @override
  String get labels => 'ラベル';

  @override
  String get systemLocale => 'システムロケール：';

  @override
  String get notebooks => 'ノート';

  @override
  String get createNotebook => 'ノートブックを作成';

  @override
  String get editNotebook => 'ノートブックを編集';

  @override
  String get update => '更新';

  @override
  String get currentVersion => '現在のバージョン';

  @override
  String get checkForUpdates => 'アップデートを確認';

  @override
  String get checkForUpdatesWarning =>
      'アップデートの確認を行うと、Flow ウェブサイトに接続して情報を取得します。';

  @override
  String get usingLatestStable => '最新の安定版を使用しています';

  @override
  String get usingLatestNightly => '最新のナイトリーバージョンを使用しています';

  @override
  String get updateNow => '今すぐ更新';

  @override
  String get stable => '安定版';

  @override
  String get nightly => 'ナイトリー';

  @override
  String get updateAvailable => 'アップデートがあります';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '1 item',
      zero: 'No items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'システムテーマ';

  @override
  String get desktop => 'デスクトップ';

  @override
  String get restoreSettingsFromFile => '設定をファイルから復元';

  @override
  String get exportSettingsToFile => '設定をファイルにエクスポート';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => '有効';

  @override
  String get countdown => 'Countdown';

  @override
  String get unlink => 'リンクを解除';

  @override
  String get noAlarms => '表示するアラームがありません。';

  @override
  String get allDay => '終日';
}
