// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hungarian (`hu`).
class AppLocalizationsHu extends AppLocalizations {
  AppLocalizationsHu([String locale = 'hu']) : super(locale);

  @override
  String get dashboard => 'Dashboard';

  @override
  String get translate => 'Fordítás';

  @override
  String get calendar => 'Calendar';

  @override
  String get resources => 'Resources';

  @override
  String get users => 'Felhasználók';

  @override
  String get user => 'User';

  @override
  String get sources => 'Sources';

  @override
  String get settings => 'Beállítások';

  @override
  String get create => 'Létrehozás';

  @override
  String get information => 'Információ';

  @override
  String get source => 'Forráskód';

  @override
  String get license => 'Licensz';

  @override
  String get thirdPartyLicenses => 'Third Party Licenses';

  @override
  String get documentation => 'Dokumentáció';

  @override
  String get privacyPolicy => 'Privacy Policy';

  @override
  String get imprint => 'Impresszum';

  @override
  String get releaseNotes => 'Release Notes';

  @override
  String get changelog => 'Változások listája';

  @override
  String get legal => 'Legal';

  @override
  String get personalization => 'Személyre szabás';

  @override
  String get design => 'Tervezés';

  @override
  String get language => 'Language';

  @override
  String get theme => 'Kinézet';

  @override
  String get classic => 'Classic';

  @override
  String get systemDefault => 'System Default';

  @override
  String get light => 'Világos';

  @override
  String get dark => 'Sötét';

  @override
  String get createResource => 'Create resource';

  @override
  String get cancel => 'Mégsem';

  @override
  String get name => 'Név';

  @override
  String get description => 'Leírás';

  @override
  String get start => 'Indítás';

  @override
  String get next => 'Next';

  @override
  String get skip => 'Skip';

  @override
  String get back => 'Vissza';

  @override
  String get today => 'Today';

  @override
  String get groups => 'Groups';

  @override
  String get createGroup => 'Create group';

  @override
  String get editGroup => 'Edit group';

  @override
  String get list => 'List';

  @override
  String get day => 'Day';

  @override
  String get week => 'Week';

  @override
  String get month => 'Month';

  @override
  String get version => 'Verzió';

  @override
  String get intro => 'Intro';

  @override
  String get caldavDescription =>
      'The CalDAV interface allows you to access your data from any CalDAV server. It has limited support and only basic functions are supported. You can use it to synchronize your data with other devices or services.';

  @override
  String get webdavDescription =>
      'The WebDAV interface allows you to access your data from any WebDAV server. It files and directories to store data. You can use it to synchronize your data with other devices or services.';

  @override
  String get server => 'Szerver';

  @override
  String get serverDescription =>
      'Sync your data with a native Linwood Flow server. This is recommended for users that want to self-host their data.';

  @override
  String get googleDescription =>
      'Sync your data with Google. This is recommended for users that want to use their Google account to access their data. Not all features are available with this option.';

  @override
  String get microsoftDescription =>
      'Sync your data with Microsoft. This is recommended for users that want to use their Microsoft account to access their data. Not all features are available with this option.';

  @override
  String get addSource => 'Add source';

  @override
  String get local => 'Helyi';

  @override
  String get close => 'Bezár';

  @override
  String get unknown => 'Unknown';

  @override
  String get loading => 'Loading';

  @override
  String get export => 'Exportálás';

  @override
  String get createEvent => 'Create event';

  @override
  String get save => 'Mentés';

  @override
  String get allSources => 'All sources';

  @override
  String get editEvent => 'Edit event';

  @override
  String get end => 'End';

  @override
  String get location => 'Hely';

  @override
  String get status => 'Status';

  @override
  String get confirmed => 'Confirmed';

  @override
  String get draft => 'Draft';

  @override
  String get cancelled => 'Cancelled';

  @override
  String get general => 'Általános';

  @override
  String get notes => 'Notes';

  @override
  String get createNote => 'Create note';

  @override
  String get editNote => 'Edit note';

  @override
  String get indicatorEmpty => 'No items found';

  @override
  String get indicatorEmptyDescription => 'The list is currently empty.';

  @override
  String get indicatorLoading => 'Loading';

  @override
  String get indicatorError => 'An error occurred';

  @override
  String get indicatorErrorDescription =>
      'An error occurred while loading the data.';

  @override
  String get tryAgain => 'Try again';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event on $date at $time in $location ($status)';
  }

  @override
  String get filter => 'Filter';

  @override
  String get done => 'Done';

  @override
  String get inProgress => 'In progress';

  @override
  String get note => 'Megjegyzés';

  @override
  String get delete => 'Törlés';

  @override
  String get edit => 'Szerkesztés';

  @override
  String deleteGroup(String name) {
    return 'Delete group $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Are you sure you want to delete the group $name?';
  }

  @override
  String groupName(String name) {
    return 'Group $name';
  }

  @override
  String get noData => 'There is no data to display.';

  @override
  String get noEvents => 'There are no events to display.';

  @override
  String get group => 'Group';

  @override
  String get search => 'Keresés';

  @override
  String get events => 'Events';

  @override
  String get past => 'Past';

  @override
  String get decentralized => 'Decentralized';

  @override
  String get decentralizedDescription =>
      'The decentralized interface allows you to access your data from any decentralized server. You can use it to synchronize your data with other devices or services.';

  @override
  String get importFile => 'Import file';

  @override
  String get importFileDescription =>
      'Import a file from your device. You can import a database file from another Linwood Flow instance or a regular calendar file.';

  @override
  String get icalDescription =>
      'The iCal interface allows you to access your data from any iCal server. It can only read data and does not support writing. You can use it to synchronize your data with other devices or services that do not support CalDAV.';

  @override
  String get resource => 'Resource';

  @override
  String get editResource => 'Edit resource';

  @override
  String deleteResource(String name) {
    return 'Delete resource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Are you sure you want to delete the resource $name?';
  }

  @override
  String get priority => 'Priority';

  @override
  String get assignEvent => 'Assign event';

  @override
  String get noEvent => 'No event';

  @override
  String get parentGroup => 'Parent group';

  @override
  String deleteUser(String name) {
    return 'Delete user $name';
  }

  @override
  String get createUser => 'Create user';

  @override
  String get editUser => 'Edit user';

  @override
  String deleteUserDescription(String name) {
    return 'Are you sure you want to delete the user $name?';
  }

  @override
  String get pending => 'Pending';

  @override
  String get removeEvent => 'Remove event';

  @override
  String get event => 'Event';

  @override
  String get nativeTitleBar => 'Natív címsor';

  @override
  String get blocked => 'Blocked';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count events',
      one: '1 event',
      zero: 'No events',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importálás';

  @override
  String get confirmImport => 'Are you sure you want to import it?';

  @override
  String get welcome => 'Welcome';

  @override
  String get url => 'Webcím';

  @override
  String get username => 'Felhasználónév';

  @override
  String get password => 'Jelszó';

  @override
  String get connect => 'Csatlakozás';

  @override
  String get data => 'Adat';

  @override
  String get syncing => 'Syncing';

  @override
  String get synced => 'Szinkronizálva';

  @override
  String get error => 'Hiba';

  @override
  String get always => 'Mindig';

  @override
  String get noMobile => 'Mobilhálózat letiltva';

  @override
  String get manual => 'Kézi';

  @override
  String get syncMode => 'Szinkronizációs mód';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Appointment';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Time';

  @override
  String deleteEvent(String name) {
    return 'Delete event $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Are you sure you want to delete the event $name?';
  }

  @override
  String get createAppointment => 'Create appointment';

  @override
  String get editAppointment => 'Edit appointment';

  @override
  String get createMoment => 'Create moment';

  @override
  String get editMoment => 'Edit moment';

  @override
  String get convertToNote => 'Convert to note';

  @override
  String get convertToTodo => 'Convert to todo';

  @override
  String get open => 'Megnyit';

  @override
  String get limited => 'Limited';

  @override
  String get notSet => 'Nincs beállítva';

  @override
  String get createPending => 'Create pending';

  @override
  String get editPending => 'Edit pending';

  @override
  String get convertTo => 'Convert to';

  @override
  String get comingSoon => 'Coming soon';

  @override
  String get notSupported => 'Not supported';

  @override
  String get databaseVersion => 'Database version';

  @override
  String get minimize => 'Kis méret';

  @override
  String get maximize => 'Teljes méret';

  @override
  String get restore => 'Visszaállítás';

  @override
  String get markdownIsSupported => 'Markdown is supported';

  @override
  String get createLabel => 'Create label';

  @override
  String get editLabel => 'Edit label';

  @override
  String deleteLabel(String name) {
    return 'Delete label $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Are you sure you want to delete the label $name?';
  }

  @override
  String get label => 'Címke';

  @override
  String get startOfWeek => 'Start of week';

  @override
  String headlineNumber(int number) {
    return 'Főcím $number';
  }

  @override
  String get bold => 'Félkövér';

  @override
  String get italic => 'Dőlt';

  @override
  String get strikethrough => 'Áthúzás';

  @override
  String get code => 'Kód';

  @override
  String get link => 'Hivatkozás';

  @override
  String get codeBlock => 'Code block';

  @override
  String get quote => 'Idézet';

  @override
  String get numberedList => 'Numbered list';

  @override
  String get density => 'Sűrűség';

  @override
  String get compact => 'Tömör';

  @override
  String get comfortable => 'Kényelmes';

  @override
  String get standard => 'Normál';

  @override
  String get highContrast => 'Magas kontraszt';

  @override
  String get labels => 'Labels';

  @override
  String get systemLocale => 'Helyi rendszer';

  @override
  String get notebooks => 'Notebooks';

  @override
  String get createNotebook => 'Create notebook';

  @override
  String get editNotebook => 'Edit notebook';

  @override
  String get update => 'Frissítés';

  @override
  String get currentVersion => 'Jelenlegi verzió';

  @override
  String get checkForUpdates => 'Frissítések keresése';

  @override
  String get checkForUpdatesWarning =>
      'Performing a check for updates will connect to the Flow website to get the information.';

  @override
  String get usingLatestStable => 'A legújabb stabil verziót használja';

  @override
  String get usingLatestNightly => 'A legújabb éjszakai verziót használja';

  @override
  String get updateNow => 'Frissítés most';

  @override
  String get stable => 'Stabil';

  @override
  String get nightly => 'Éjszakai';

  @override
  String get updateAvailable => 'Frissítés elérhető';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '1 item',
      zero: 'No items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'System theme';

  @override
  String get desktop => 'Asztali';

  @override
  String get restoreSettingsFromFile => 'Beállítások visszaállítása fájlból';

  @override
  String get exportSettingsToFile => 'Beállítások exportálása fájlba';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Enabled';

  @override
  String get countdown => 'Countdown';

  @override
  String get unlink => 'Unlink';

  @override
  String get noAlarms => 'There are no alarms to display.';

  @override
  String get allDay => 'All day';
}
