// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class AppLocalizationsFr extends AppLocalizations {
  AppLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get dashboard => 'Tableau de bord';

  @override
  String get translate => 'Traduire';

  @override
  String get calendar => 'Calendrier';

  @override
  String get resources => 'Ressource';

  @override
  String get users => 'Utilisateurs';

  @override
  String get user => 'Utilisateur';

  @override
  String get sources => 'Sources';

  @override
  String get settings => 'Réglages';

  @override
  String get create => 'Créer';

  @override
  String get information => 'Information';

  @override
  String get source => 'Source';

  @override
  String get license => 'Licence';

  @override
  String get thirdPartyLicenses => 'Licences tierces';

  @override
  String get documentation => 'Documentation';

  @override
  String get privacyPolicy => 'Politique de confidentialité';

  @override
  String get imprint => 'Mentions légales';

  @override
  String get releaseNotes => 'Notes de version';

  @override
  String get changelog => 'Historique des modifications';

  @override
  String get legal => 'Mentions légales';

  @override
  String get personalization => 'Personnalisation';

  @override
  String get design => 'Conception';

  @override
  String get language => 'Langue';

  @override
  String get theme => 'Thème';

  @override
  String get classic => 'Classique';

  @override
  String get systemDefault => 'Par défaut du système';

  @override
  String get light => 'Lumière';

  @override
  String get dark => 'Sombre';

  @override
  String get createResource => 'Créer une ressource';

  @override
  String get cancel => 'Abandonner';

  @override
  String get name => 'Nom';

  @override
  String get description => 'Libellé';

  @override
  String get start => 'Début';

  @override
  String get next => 'Suivant';

  @override
  String get skip => 'Ignorer';

  @override
  String get back => 'Précédent';

  @override
  String get today => 'Aujourd\'hui';

  @override
  String get groups => 'Groupes';

  @override
  String get createGroup => 'Créer un groupe';

  @override
  String get editGroup => 'Modifier le groupe';

  @override
  String get list => 'Liste';

  @override
  String get day => 'Jour';

  @override
  String get week => 'Semaine';

  @override
  String get month => 'Mois';

  @override
  String get version => 'Version';

  @override
  String get intro => 'Introduction';

  @override
  String get caldavDescription =>
      'L\'interface CalDAV vous permet d\'accéder à vos données depuis n\'importe quel serveur CalDAV. Il a un support limité et seules les fonctions de base sont prises en charge. Vous pouvez l\'utiliser pour synchroniser vos données avec d\'autres appareils ou services.';

  @override
  String get webdavDescription =>
      'L\'interface WebDAV vous permet d\'accéder à vos données depuis n\'importe quel serveur WebDAV. Il contient des fichiers et des répertoires pour stocker des données. Vous pouvez l\'utiliser pour synchroniser vos données avec d\'autres appareils ou services.';

  @override
  String get server => 'Serveur';

  @override
  String get serverDescription =>
      'Synchronisez vos données avec un serveur Linwood Flow natif. Ceci est recommandé pour les utilisateurs qui souhaitent héberger leurs données.';

  @override
  String get googleDescription =>
      'Synchronisez vos données avec Google. Ceci est recommandé aux utilisateurs qui souhaitent utiliser leur compte Google pour accéder à leurs données. Toutes les fonctionnalités ne sont pas disponibles avec cette option.';

  @override
  String get microsoftDescription =>
      'Synchronisez vos données avec Microsoft. Ceci est recommandé aux utilisateurs qui souhaitent utiliser leur compte Microsoft pour accéder à leurs données. Toutes les fonctionnalités ne sont pas disponibles avec cette option.';

  @override
  String get addSource => 'Ajouter une source';

  @override
  String get local => 'Locale';

  @override
  String get close => 'Fermer';

  @override
  String get unknown => 'Inconnu';

  @override
  String get loading => 'En cours de chargement';

  @override
  String get export => 'Exportation';

  @override
  String get createEvent => 'Créer un événement';

  @override
  String get save => 'Enregistrer';

  @override
  String get allSources => 'Toutes les sources';

  @override
  String get editEvent => 'Modifier l\'événement';

  @override
  String get end => 'Fin';

  @override
  String get location => 'Localisation';

  @override
  String get status => 'Statut';

  @override
  String get confirmed => 'Confirmé';

  @override
  String get draft => 'Brouillon';

  @override
  String get cancelled => 'Annulé';

  @override
  String get general => 'Généraux';

  @override
  String get notes => 'Notes';

  @override
  String get createNote => 'Créer une note';

  @override
  String get editNote => 'Modifier la note';

  @override
  String get indicatorEmpty => 'Aucun élément trouvé';

  @override
  String get indicatorEmptyDescription => 'La liste est actuellement vide.';

  @override
  String get indicatorLoading => 'En cours de chargement';

  @override
  String get indicatorError => 'Une erreur s\'est produite';

  @override
  String get indicatorErrorDescription =>
      'Une erreur s\'est produite lors du chargement des données.';

  @override
  String get tryAgain => 'Réessayez';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event le $date à $time à $location ($status)';
  }

  @override
  String get filter => 'Filtre';

  @override
  String get done => 'Fait';

  @override
  String get inProgress => 'En cours';

  @override
  String get note => 'Note';

  @override
  String get delete => 'Supprimez';

  @override
  String get edit => 'Editer';

  @override
  String deleteGroup(String name) {
    return 'Supprimer le groupe $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Êtes-vous sûr de vouloir supprimer le groupe $name?';
  }

  @override
  String groupName(String name) {
    return 'Groupe $name';
  }

  @override
  String get noData => 'Il n\'y a pas de données à afficher.';

  @override
  String get noEvents => 'Il n\'y a aucun événement à afficher.';

  @override
  String get group => 'Groupes';

  @override
  String get search => 'Chercher';

  @override
  String get events => 'Évènements';

  @override
  String get past => 'Passé';

  @override
  String get decentralized => 'Décentralisé';

  @override
  String get decentralizedDescription =>
      'L\'interface décentralisée vous permet d\'accéder à vos données depuis n\'importe quel serveur décentralisé. Vous pouvez l\'utiliser pour synchroniser vos données avec d\'autres appareils ou services.';

  @override
  String get importFile => 'Importer un fichier';

  @override
  String get importFileDescription =>
      'Importez un fichier depuis votre appareil. Vous pouvez importer un fichier de base de données depuis une autre instance Linwood Flow ou un fichier calendrier normal.';

  @override
  String get icalDescription =>
      'L\'interface iCal vous permet d\'accéder à vos données depuis n\'importe quel serveur iCal. Vous pouvez l\'utiliser pour synchroniser vos données avec d\'autres appareils ou services qui ne prennent pas en charge CalDAV.';

  @override
  String get resource => 'Ressource';

  @override
  String get editResource => 'Modifier la ressource';

  @override
  String deleteResource(String name) {
    return 'Supprimer la ressource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Êtes-vous sûr de vouloir supprimer la ressource $name?';
  }

  @override
  String get priority => 'Priorité';

  @override
  String get assignEvent => 'Assigner un événement';

  @override
  String get noEvent => 'Aucun événement';

  @override
  String get parentGroup => 'Groupe parent';

  @override
  String deleteUser(String name) {
    return 'Supprimer l\'utilisateur $name';
  }

  @override
  String get createUser => 'Créer un utilisateur';

  @override
  String get editUser => 'Modifier l\'utilisateur';

  @override
  String deleteUserDescription(String name) {
    return 'Êtes-vous sûr de vouloir supprimer l\'utilisateur $name?';
  }

  @override
  String get pending => 'En attente';

  @override
  String get removeEvent => 'Supprimer l\'événement';

  @override
  String get event => 'Evénement';

  @override
  String get nativeTitleBar => 'Barre de titre native';

  @override
  String get blocked => 'Bloqué';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count événements',
      one: '1 événement',
      zero: 'Aucun événement',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importation';

  @override
  String get confirmImport => 'Êtes-vous sûr de vouloir l\'importer ?';

  @override
  String get welcome => 'Bienvenue';

  @override
  String get url => 'URL';

  @override
  String get username => 'Nom d\'utilisateur';

  @override
  String get password => 'Mot de passe';

  @override
  String get connect => 'Connecter';

  @override
  String get data => 'Donnée';

  @override
  String get syncing => 'Synchronisation en cours';

  @override
  String get synced => 'Synchronisé';

  @override
  String get error => 'Erreur';

  @override
  String get always => 'Toujours';

  @override
  String get noMobile => 'Aucun mobile';

  @override
  String get manual => 'Manuelle';

  @override
  String get syncMode => 'Mode de synchronisation';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Rendez-vous';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Date et heure';

  @override
  String deleteEvent(String name) {
    return 'Supprimer l\'événement $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Êtes-vous sûr de vouloir supprimer l\'événement $name?';
  }

  @override
  String get createAppointment => 'Créer un rendez-vous';

  @override
  String get editAppointment => 'Modifier le rendez-vous';

  @override
  String get createMoment => 'Créer un moment';

  @override
  String get editMoment => 'Modifier le moment';

  @override
  String get convertToNote => 'Convertir en note';

  @override
  String get convertToTodo => 'Convertir en todo';

  @override
  String get open => 'Ouvert';

  @override
  String get limited => 'Limité';

  @override
  String get notSet => 'Non défini';

  @override
  String get createPending => 'Créer en attente';

  @override
  String get editPending => 'Modifier en attente';

  @override
  String get convertTo => 'Convertir en';

  @override
  String get comingSoon => 'Bientôt disponible';

  @override
  String get notSupported => 'Non pris en charge';

  @override
  String get databaseVersion => 'Version de la base de données';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Restaurer';

  @override
  String get markdownIsSupported => 'Markdown est pris en charge';

  @override
  String get createLabel => 'Créer une étiquette';

  @override
  String get editLabel => 'Modifier l\'étiquette';

  @override
  String deleteLabel(String name) {
    return 'Supprimer l\'étiquette « $name»';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Êtes-vous sûr de vouloir supprimer l\'étiquette $name?';
  }

  @override
  String get label => 'Étiquette';

  @override
  String get startOfWeek => 'Début de la semaine';

  @override
  String headlineNumber(int number) {
    return 'Titre $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Frappe';

  @override
  String get code => 'Code';

  @override
  String get link => 'Lier';

  @override
  String get codeBlock => 'Bloc de code';

  @override
  String get quote => 'Devis';

  @override
  String get numberedList => 'Liste numérotée';

  @override
  String get density => 'Densité';

  @override
  String get compact => 'Compact';

  @override
  String get comfortable => 'Confortable';

  @override
  String get standard => 'Standard';

  @override
  String get highContrast => 'Contraste élevé';

  @override
  String get labels => 'Étiquettes';

  @override
  String get systemLocale => 'Paramètres régionaux du système';

  @override
  String get notebooks => 'Carnets';

  @override
  String get createNotebook => 'Créer un bloc-notes';

  @override
  String get editNotebook => 'Modifier le bloc-notes';

  @override
  String get update => 'Mise à jour';

  @override
  String get currentVersion => 'Version actuelle';

  @override
  String get checkForUpdates => 'Vérifier les mises à jour';

  @override
  String get checkForUpdatesWarning =>
      'Effectuer une vérification des mises à jour se connectera au site Web de Flow pour obtenir les informations.';

  @override
  String get usingLatestStable => 'Vous utilisez la dernière version stable';

  @override
  String get usingLatestNightly =>
      'Vous utilisez la dernière version \"Nightly\" (en cours de développement) de Linwood Butterfly';

  @override
  String get updateNow => 'Mettre à jour maintenant';

  @override
  String get stable => 'Écurie';

  @override
  String get nightly => 'Nuit';

  @override
  String get updateAvailable => 'Mise à jour disponible';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count objets',
      one: '1 objet',
      zero: 'Aucun objet',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Thème système';

  @override
  String get desktop => 'Bureau';

  @override
  String get restoreSettingsFromFile =>
      'Restaurer les paramètres à partir du fichier';

  @override
  String get exportSettingsToFile => 'Exporter les paramètres vers un fichier';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Activé';

  @override
  String get countdown => 'Compte à Rebours';

  @override
  String get unlink => 'Délier';

  @override
  String get noAlarms => 'Il n\'y a aucune alarme à afficher.';

  @override
  String get allDay => 'Toute la journée';
}
