// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Spanish Castilian (`es`).
class AppLocalizationsEs extends AppLocalizations {
  AppLocalizationsEs([String locale = 'es']) : super(locale);

  @override
  String get dashboard => 'Tablero';

  @override
  String get translate => 'Traducir';

  @override
  String get calendar => 'Calendario';

  @override
  String get resources => 'Recursos';

  @override
  String get users => 'Usuarios';

  @override
  String get user => 'Usuario';

  @override
  String get sources => 'Fuentes';

  @override
  String get settings => 'Ajustes';

  @override
  String get create => 'Crear';

  @override
  String get information => 'Información';

  @override
  String get source => 'Fuente';

  @override
  String get license => 'Licencia';

  @override
  String get thirdPartyLicenses => 'Licencias de terceros';

  @override
  String get documentation => 'Documentación';

  @override
  String get privacyPolicy => 'Política de privacidad';

  @override
  String get imprint => 'Aviso';

  @override
  String get releaseNotes => 'Notas de la versión';

  @override
  String get changelog => 'Cambios';

  @override
  String get legal => 'Legal';

  @override
  String get personalization => 'Personalización';

  @override
  String get design => 'Diseño';

  @override
  String get language => 'Idioma';

  @override
  String get theme => 'Tema';

  @override
  String get classic => 'Clásico';

  @override
  String get systemDefault => 'Sistema por defecto';

  @override
  String get light => 'Claro';

  @override
  String get dark => 'Oscuro';

  @override
  String get createResource => 'Crear recurso';

  @override
  String get cancel => 'Cancelar';

  @override
  String get name => 'Nombre';

  @override
  String get description => 'Descripción';

  @override
  String get start => 'Comenzar';

  @override
  String get next => 'Siguiente';

  @override
  String get skip => 'Saltar';

  @override
  String get back => 'Atrás';

  @override
  String get today => 'Hoy';

  @override
  String get groups => 'Grupos';

  @override
  String get createGroup => 'Crear grupo';

  @override
  String get editGroup => 'Editar grupo';

  @override
  String get list => 'Lista';

  @override
  String get day => 'Día';

  @override
  String get week => 'Semana';

  @override
  String get month => 'Mes';

  @override
  String get version => 'Versión';

  @override
  String get intro => 'Introducción';

  @override
  String get caldavDescription =>
      'La interfaz de CalDAV le permite acceder a sus datos desde cualquier servidor de CalDAV. Tiene soporte limitado y sólo se admiten funciones básicas. Puede utilizarlo para sincronizar sus datos con otros dispositivos o servicios.';

  @override
  String get webdavDescription =>
      'La interfaz WebDAV le permite acceder a sus datos desde cualquier servidor WebDAV. Archivos y directorios para almacenar datos. Puede utilizarlos para sincronizar sus datos con otros dispositivos o servicios.';

  @override
  String get server => 'Servidor';

  @override
  String get serverDescription =>
      'Sincronice sus datos con un servidor nativo de Linwood Flow. Esto se recomienda para los usuarios que quieran autoalojar sus datos.';

  @override
  String get googleDescription =>
      'Sincroniza tus datos con Google. Se recomienda a los usuarios que quieran utilizar su cuenta de Google para acceder a sus datos. No todas las características están disponibles con esta opción.';

  @override
  String get microsoftDescription =>
      'Sincronice sus datos con Microsoft. Esto se recomienda para los usuarios que quieran utilizar su cuenta de Microsoft para acceder a sus datos. No todas las características están disponibles con esta opción.';

  @override
  String get addSource => 'Añadir origen';

  @override
  String get local => 'Local';

  @override
  String get close => 'Cerrar';

  @override
  String get unknown => 'Desconocido';

  @override
  String get loading => 'Cargando';

  @override
  String get export => 'Exportar';

  @override
  String get createEvent => 'Crear evento';

  @override
  String get save => 'Guardar';

  @override
  String get allSources => 'Todas las fuentes';

  @override
  String get editEvent => 'Editar evento';

  @override
  String get end => 'Fin';

  @override
  String get location => 'Ubicación';

  @override
  String get status => 'Estado';

  @override
  String get confirmed => 'Confirmada';

  @override
  String get draft => 'Fabricación';

  @override
  String get cancelled => 'Cancelado';

  @override
  String get general => 'General';

  @override
  String get notes => 'Notas';

  @override
  String get createNote => 'Crear nota';

  @override
  String get editNote => 'Editar nota';

  @override
  String get indicatorEmpty => 'No hay elementos';

  @override
  String get indicatorEmptyDescription => 'La lista está vacía.';

  @override
  String get indicatorLoading => 'Cargando';

  @override
  String get indicatorError => 'Se ha producido un error';

  @override
  String get indicatorErrorDescription =>
      'Se ha producido un error al cargar los datos.';

  @override
  String get tryAgain => 'Inténtalo de nuevo';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event el $date a las $time en $location ($status)';
  }

  @override
  String get filter => 'Filtro';

  @override
  String get done => 'Hecho';

  @override
  String get inProgress => 'En progreso';

  @override
  String get note => 'Nota';

  @override
  String get delete => 'Eliminar';

  @override
  String get edit => 'Editar';

  @override
  String deleteGroup(String name) {
    return 'Eliminar grupo $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return '¿Está seguro que desea eliminar el grupo $name?';
  }

  @override
  String groupName(String name) {
    return 'Grupo $name';
  }

  @override
  String get noData => 'No hay datos para mostrar.';

  @override
  String get noEvents => 'No hay eventos para mostrar.';

  @override
  String get group => 'Grupo';

  @override
  String get search => 'Buscar';

  @override
  String get events => 'Eventos';

  @override
  String get past => 'Pasado';

  @override
  String get decentralized => 'Descentralizado';

  @override
  String get decentralizedDescription =>
      'La interfaz descentralizada le permite acceder a sus datos desde cualquier servidor descentralizado. Puede utilizarlo para sincronizar sus datos con otros dispositivos o servicios.';

  @override
  String get importFile => 'Importar archivo';

  @override
  String get importFileDescription =>
      'Importa un archivo desde tu dispositivo. Puedes importar un archivo de base de datos desde otra instancia de Linwood Flow o un archivo de calendario normal.';

  @override
  String get icalDescription =>
      'La interfaz iCal le permite acceder a sus datos desde cualquier servidor iCal. Sólo puede leer datos y no es compatible con la escritura. Puede usarlo para sincronizar sus datos con otros dispositivos o servicios que no soporten CalDAV.';

  @override
  String get resource => 'Recurso';

  @override
  String get editResource => 'Editar recurso';

  @override
  String deleteResource(String name) {
    return 'Eliminar recurso $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return '¿Está seguro que desea eliminar el recurso $name?';
  }

  @override
  String get priority => 'Prioridad';

  @override
  String get assignEvent => 'Asignar evento';

  @override
  String get noEvent => 'Ningún evento';

  @override
  String get parentGroup => 'Grupo padre';

  @override
  String deleteUser(String name) {
    return 'Eliminar usuario $name';
  }

  @override
  String get createUser => 'Crear usuario';

  @override
  String get editUser => 'Editar usuario';

  @override
  String deleteUserDescription(String name) {
    return '¿Está seguro que desea eliminar el usuario $name?';
  }

  @override
  String get pending => 'Pendiente';

  @override
  String get removeEvent => 'Eliminar evento';

  @override
  String get event => 'Evento';

  @override
  String get nativeTitleBar => 'Barra de título nativa';

  @override
  String get blocked => 'Bloqueado';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count eventos',
      one: '1 evento',
      zero: 'No hay eventos',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importar';

  @override
  String get confirmImport => '¿Estás seguro de que quieres importarlo?';

  @override
  String get welcome => 'Bienvenida';

  @override
  String get url => 'URL';

  @override
  String get username => 'Usuario';

  @override
  String get password => 'Contraseña';

  @override
  String get connect => 'Conectar';

  @override
  String get data => 'Datos';

  @override
  String get syncing => 'Sincronizando';

  @override
  String get synced => 'Sincronizado';

  @override
  String get error => 'Error';

  @override
  String get always => 'Siempre';

  @override
  String get noMobile => 'Sin móvil';

  @override
  String get manual => 'Manual';

  @override
  String get syncMode => 'Modo de sincronización';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Cita';

  @override
  String get moment => 'Momento';

  @override
  String get time => 'Hora';

  @override
  String deleteEvent(String name) {
    return 'Eliminar evento $name';
  }

  @override
  String deleteEventDescription(String name) {
    return '¿Está seguro que desea eliminar el evento $name?';
  }

  @override
  String get createAppointment => 'Crear cita';

  @override
  String get editAppointment => 'Editar cita';

  @override
  String get createMoment => 'Crear momento';

  @override
  String get editMoment => 'Editar momento';

  @override
  String get convertToNote => 'Convertir a nota';

  @override
  String get convertToTodo => 'Convertir a tarea';

  @override
  String get open => 'Abrir';

  @override
  String get limited => 'Limitado';

  @override
  String get notSet => 'No establecido';

  @override
  String get createPending => 'Crear pendiente';

  @override
  String get editPending => 'Editar pendiente';

  @override
  String get convertTo => 'Convertir a';

  @override
  String get comingSoon => 'Próximamente';

  @override
  String get notSupported => 'No soportado';

  @override
  String get databaseVersion => 'Versión de base de datos';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Restaurar';

  @override
  String get markdownIsSupported => 'Markdown soportado';

  @override
  String get createLabel => 'Crear etiqueta';

  @override
  String get editLabel => 'Editar etiqueta';

  @override
  String deleteLabel(String name) {
    return 'Eliminar etiqueta $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return '¿Está seguro que desea eliminar la etiqueta $name?';
  }

  @override
  String get label => 'Etiqueta';

  @override
  String get startOfWeek => 'Inicio de la semana';

  @override
  String headlineNumber(int number) {
    return 'Encabezado $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Tachado';

  @override
  String get code => 'Código';

  @override
  String get link => 'Enlace';

  @override
  String get codeBlock => 'Bloque de código';

  @override
  String get quote => 'Cotización';

  @override
  String get numberedList => 'Lista numerada';

  @override
  String get density => 'Densidad';

  @override
  String get compact => 'Compacto';

  @override
  String get comfortable => 'Confortable';

  @override
  String get standard => 'Estándar';

  @override
  String get highContrast => 'Alto contraste';

  @override
  String get labels => 'Etiquetas';

  @override
  String get systemLocale => 'Localización del sistema';

  @override
  String get notebooks => 'Notas';

  @override
  String get createNotebook => 'Crear cuaderno';

  @override
  String get editNotebook => 'Editar cuaderno';

  @override
  String get update => 'Actualizar';

  @override
  String get currentVersion => 'Versión actual';

  @override
  String get checkForUpdates => 'Buscar actualizaciones';

  @override
  String get checkForUpdatesWarning =>
      'Realizar una comprobación de actualizaciones se conectará al sitio web de Flow para obtener la información.';

  @override
  String get usingLatestStable => 'Estás usando la última versión estable';

  @override
  String get usingLatestNightly => 'Estás usando la última versión nocturna';

  @override
  String get updateNow => 'Actualizar ahora';

  @override
  String get stable => 'Estable';

  @override
  String get nightly => 'Noche';

  @override
  String get updateAvailable => 'Actualización disponible';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count objetos',
      one: '1 elemento',
      zero: 'No hay objetos',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Tema del sistema';

  @override
  String get desktop => 'Escritorio';

  @override
  String get restoreSettingsFromFile => 'Restaurar ajustes desde el archivo';

  @override
  String get exportSettingsToFile => 'Exportar ajustes al archivo';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Activado';

  @override
  String get countdown => 'Cuenta atrás';

  @override
  String get unlink => 'Desvincular';

  @override
  String get noAlarms => 'No hay alarmas para mostrar.';

  @override
  String get allDay => 'Todo el día';
}
