// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for English (`en`).
class AppLocalizationsEn extends AppLocalizations {
  AppLocalizationsEn([String locale = 'en']) : super(locale);

  @override
  String get dashboard => 'Dashboard';

  @override
  String get translate => 'Translate';

  @override
  String get calendar => 'Calendar';

  @override
  String get resources => 'Resources';

  @override
  String get users => 'Users';

  @override
  String get user => 'User';

  @override
  String get sources => 'Sources';

  @override
  String get settings => 'Settings';

  @override
  String get create => 'Create';

  @override
  String get information => 'Information';

  @override
  String get source => 'Source';

  @override
  String get license => 'License';

  @override
  String get thirdPartyLicenses => 'Third Party Licenses';

  @override
  String get documentation => 'Documentation';

  @override
  String get privacyPolicy => 'Privacy Policy';

  @override
  String get imprint => 'Imprint';

  @override
  String get releaseNotes => 'Release Notes';

  @override
  String get changelog => 'Changelog';

  @override
  String get legal => 'Legal';

  @override
  String get personalization => 'Personalization';

  @override
  String get design => 'Design';

  @override
  String get language => 'Language';

  @override
  String get theme => 'Theme';

  @override
  String get classic => 'Classic';

  @override
  String get systemDefault => 'System Default';

  @override
  String get light => 'Light';

  @override
  String get dark => 'Dark';

  @override
  String get createResource => 'Create resource';

  @override
  String get cancel => 'Cancel';

  @override
  String get name => 'Name';

  @override
  String get description => 'Description';

  @override
  String get start => 'Start';

  @override
  String get next => 'Next';

  @override
  String get skip => 'Skip';

  @override
  String get back => 'Back';

  @override
  String get today => 'Today';

  @override
  String get groups => 'Groups';

  @override
  String get createGroup => 'Create group';

  @override
  String get editGroup => 'Edit group';

  @override
  String get list => 'List';

  @override
  String get day => 'Day';

  @override
  String get week => 'Week';

  @override
  String get month => 'Month';

  @override
  String get version => 'Version';

  @override
  String get intro => 'Intro';

  @override
  String get caldavDescription =>
      'The CalDAV interface allows you to access your data from any CalDAV server. It has limited support and only basic functions are supported. You can use it to synchronize your data with other devices or services.';

  @override
  String get webdavDescription =>
      'The WebDAV interface allows you to access your data from any WebDAV server. It files and directories to store data. You can use it to synchronize your data with other devices or services.';

  @override
  String get server => 'Server';

  @override
  String get serverDescription =>
      'Sync your data with a native Linwood Flow server. This is recommended for users that want to self-host their data.';

  @override
  String get googleDescription =>
      'Sync your data with Google. This is recommended for users that want to use their Google account to access their data. Not all features are available with this option.';

  @override
  String get microsoftDescription =>
      'Sync your data with Microsoft. This is recommended for users that want to use their Microsoft account to access their data. Not all features are available with this option.';

  @override
  String get addSource => 'Add source';

  @override
  String get local => 'Local';

  @override
  String get close => 'Close';

  @override
  String get unknown => 'Unknown';

  @override
  String get loading => 'Loading';

  @override
  String get export => 'Export';

  @override
  String get createEvent => 'Create event';

  @override
  String get save => 'Save';

  @override
  String get allSources => 'All sources';

  @override
  String get editEvent => 'Edit event';

  @override
  String get end => 'End';

  @override
  String get location => 'Location';

  @override
  String get status => 'Status';

  @override
  String get confirmed => 'Confirmed';

  @override
  String get draft => 'Draft';

  @override
  String get cancelled => 'Cancelled';

  @override
  String get general => 'General';

  @override
  String get notes => 'Notes';

  @override
  String get createNote => 'Create note';

  @override
  String get editNote => 'Edit note';

  @override
  String get indicatorEmpty => 'No items found';

  @override
  String get indicatorEmptyDescription => 'The list is currently empty.';

  @override
  String get indicatorLoading => 'Loading';

  @override
  String get indicatorError => 'An error occurred';

  @override
  String get indicatorErrorDescription =>
      'An error occurred while loading the data.';

  @override
  String get tryAgain => 'Try again';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event on $date at $time in $location ($status)';
  }

  @override
  String get filter => 'Filter';

  @override
  String get done => 'Done';

  @override
  String get inProgress => 'In progress';

  @override
  String get note => 'Note';

  @override
  String get delete => 'Delete';

  @override
  String get edit => 'Edit';

  @override
  String deleteGroup(String name) {
    return 'Delete group $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Are you sure you want to delete the group $name?';
  }

  @override
  String groupName(String name) {
    return 'Group $name';
  }

  @override
  String get noData => 'There is no data to display.';

  @override
  String get noEvents => 'There are no events to display.';

  @override
  String get group => 'Group';

  @override
  String get search => 'Search';

  @override
  String get events => 'Events';

  @override
  String get past => 'Past';

  @override
  String get decentralized => 'Decentralized';

  @override
  String get decentralizedDescription =>
      'The decentralized interface allows you to access your data from any decentralized server. You can use it to synchronize your data with other devices or services.';

  @override
  String get importFile => 'Import file';

  @override
  String get importFileDescription =>
      'Import a file from your device. You can import a database file from another Linwood Flow instance or a regular calendar file.';

  @override
  String get icalDescription =>
      'The iCal interface allows you to access your data from any iCal server. It can only read data and does not support writing. You can use it to synchronize your data with other devices or services that do not support CalDAV.';

  @override
  String get resource => 'Resource';

  @override
  String get editResource => 'Edit resource';

  @override
  String deleteResource(String name) {
    return 'Delete resource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Are you sure you want to delete the resource $name?';
  }

  @override
  String get priority => 'Priority';

  @override
  String get assignEvent => 'Assign event';

  @override
  String get noEvent => 'No event';

  @override
  String get parentGroup => 'Parent group';

  @override
  String deleteUser(String name) {
    return 'Delete user $name';
  }

  @override
  String get createUser => 'Create user';

  @override
  String get editUser => 'Edit user';

  @override
  String deleteUserDescription(String name) {
    return 'Are you sure you want to delete the user $name?';
  }

  @override
  String get pending => 'Pending';

  @override
  String get removeEvent => 'Remove event';

  @override
  String get event => 'Event';

  @override
  String get nativeTitleBar => 'Native title bar';

  @override
  String get blocked => 'Blocked';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count events',
      one: '1 event',
      zero: 'No events',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Import';

  @override
  String get confirmImport => 'Are you sure you want to import it?';

  @override
  String get welcome => 'Welcome';

  @override
  String get url => 'URL';

  @override
  String get username => 'Username';

  @override
  String get password => 'Password';

  @override
  String get connect => 'Connect';

  @override
  String get data => 'Data';

  @override
  String get syncing => 'Syncing';

  @override
  String get synced => 'Synced';

  @override
  String get error => 'Error';

  @override
  String get always => 'Always';

  @override
  String get noMobile => 'No mobile';

  @override
  String get manual => 'Manual';

  @override
  String get syncMode => 'Sync mode';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Appointment';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Time';

  @override
  String deleteEvent(String name) {
    return 'Delete event $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Are you sure you want to delete the event $name?';
  }

  @override
  String get createAppointment => 'Create appointment';

  @override
  String get editAppointment => 'Edit appointment';

  @override
  String get createMoment => 'Create moment';

  @override
  String get editMoment => 'Edit moment';

  @override
  String get convertToNote => 'Convert to note';

  @override
  String get convertToTodo => 'Convert to todo';

  @override
  String get open => 'Open';

  @override
  String get limited => 'Limited';

  @override
  String get notSet => 'Not set';

  @override
  String get createPending => 'Create pending';

  @override
  String get editPending => 'Edit pending';

  @override
  String get convertTo => 'Convert to';

  @override
  String get comingSoon => 'Coming soon';

  @override
  String get notSupported => 'Not supported';

  @override
  String get databaseVersion => 'Database version';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Restore';

  @override
  String get markdownIsSupported => 'Markdown is supported';

  @override
  String get createLabel => 'Create label';

  @override
  String get editLabel => 'Edit label';

  @override
  String deleteLabel(String name) {
    return 'Delete label $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Are you sure you want to delete the label $name?';
  }

  @override
  String get label => 'Label';

  @override
  String get startOfWeek => 'Start of week';

  @override
  String headlineNumber(int number) {
    return 'Headline $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Strikethrough';

  @override
  String get code => 'Code';

  @override
  String get link => 'Link';

  @override
  String get codeBlock => 'Code block';

  @override
  String get quote => 'Quote';

  @override
  String get numberedList => 'Numbered list';

  @override
  String get density => 'Density';

  @override
  String get compact => 'Compact';

  @override
  String get comfortable => 'Comfortable';

  @override
  String get standard => 'Standard';

  @override
  String get highContrast => 'High contrast';

  @override
  String get labels => 'Labels';

  @override
  String get systemLocale => 'System locale';

  @override
  String get notebooks => 'Notebooks';

  @override
  String get createNotebook => 'Create notebook';

  @override
  String get editNotebook => 'Edit notebook';

  @override
  String get update => 'Update';

  @override
  String get currentVersion => 'Current version';

  @override
  String get checkForUpdates => 'Check for updates';

  @override
  String get checkForUpdatesWarning =>
      'Performing a check for updates will connect to the Flow website to get the information.';

  @override
  String get usingLatestStable => 'You are using the latest stable version';

  @override
  String get usingLatestNightly => 'You are using the latest nightly version';

  @override
  String get updateNow => 'Update now';

  @override
  String get stable => 'Stable';

  @override
  String get nightly => 'Nightly';

  @override
  String get updateAvailable => 'Update available';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '1 item',
      zero: 'No items',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'System theme';

  @override
  String get desktop => 'Desktop';

  @override
  String get restoreSettingsFromFile => 'Restore settings from file';

  @override
  String get exportSettingsToFile => 'Export settings to file';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Enabled';

  @override
  String get countdown => 'Countdown';

  @override
  String get unlink => 'Unlink';

  @override
  String get noAlarms => 'There are no alarms to display.';

  @override
  String get allDay => 'All day';
}
