// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Modern Greek (`el`).
class AppLocalizationsEl extends AppLocalizations {
  AppLocalizationsEl([String locale = 'el']) : super(locale);

  @override
  String get dashboard => 'Ταμπλό';

  @override
  String get translate => 'Μετάφραση';

  @override
  String get calendar => 'Ημερολόγιο';

  @override
  String get resources => 'Πόροι';

  @override
  String get users => 'Χρήστες';

  @override
  String get user => 'Χρήστης';

  @override
  String get sources => 'Πηγές';

  @override
  String get settings => 'Ρυθμίσεις';

  @override
  String get create => 'Δημιουργία';

  @override
  String get information => 'Πληροφορίες';

  @override
  String get source => 'Πηγή';

  @override
  String get license => 'Άδεια';

  @override
  String get thirdPartyLicenses => 'Άδειες Τρίτων Μερών';

  @override
  String get documentation => 'Τεκμηρίωση';

  @override
  String get privacyPolicy => 'Πολιτική Απορρήτου';

  @override
  String get imprint => 'Αποτύπωμα';

  @override
  String get releaseNotes => 'Σημειώσεις Έκδοσης';

  @override
  String get changelog => 'Αρχείο Αλλαγών';

  @override
  String get legal => 'Νομικά';

  @override
  String get personalization => 'Εξατομικοποίηση';

  @override
  String get design => 'Σχεδιασμός';

  @override
  String get language => 'Γλώσσα';

  @override
  String get theme => 'Θέμα';

  @override
  String get classic => 'Κλασικό';

  @override
  String get systemDefault => 'Προεπιλογή Συστήματος';

  @override
  String get light => 'Φωτεινό';

  @override
  String get dark => 'Σκοτεινό';

  @override
  String get createResource => 'Δημιουργία πόρου';

  @override
  String get cancel => 'Ακύρωση';

  @override
  String get name => 'Όνομα';

  @override
  String get description => 'Περιγραφή';

  @override
  String get start => 'Έναρξη';

  @override
  String get next => 'Επόμενο';

  @override
  String get skip => 'Παράλειψη';

  @override
  String get back => 'Πίσω';

  @override
  String get today => 'Σήμερα';

  @override
  String get groups => 'Ομάδες';

  @override
  String get createGroup => 'Δημιουργία ομάδας';

  @override
  String get editGroup => 'Επεξεργασία ομάδας';

  @override
  String get list => 'Λίστα';

  @override
  String get day => 'Ημέρα';

  @override
  String get week => 'Εβδομάδα';

  @override
  String get month => 'Μήνας';

  @override
  String get version => 'Έκδοση';

  @override
  String get intro => 'Εισαγωγή';

  @override
  String get caldavDescription =>
      'Η διεπαφή CalDAV σας επιτρέπει να έχετε πρόσβαση στα δεδομένα σας από οποιονδήποτε διακομιστή CalDAV. Έχει περιορισμένη υποστήριξη και υποστηρίζονται μόνο βασικές λειτουργίες. Μπορείτε να τη χρησιμοποιήσετε για να συγχρονίσετε τα δεδομένα σας με άλλες συσκευές ή υπηρεσίες.';

  @override
  String get webdavDescription =>
      'Η διεπαφή WebDAV σας επιτρέπει να έχετε πρόσβαση στα δεδομένα σας από οποιονδήποτε διακομιστή WebDAV. Είναι αρχεία και καταλόγους για την αποθήκευση δεδομένων. Μπορείτε να το χρησιμοποιήσετε για να συγχρονίσετε τα δεδομένα σας με άλλες συσκευές ή υπηρεσίες.';

  @override
  String get server => 'Διακομιστής';

  @override
  String get serverDescription =>
      'Συγχρονίστε τα δεδομένα σας με έναν native διακομιστή Linwood Flow. Αυτό συνιστάται για χρήστες που θέλουν να φιλοξενήσουν τα δεδομένα τους.';

  @override
  String get googleDescription =>
      'Συγχρονίστε τα δεδομένα σας με την Google. Αυτό συνιστάται για χρήστες που θέλουν να χρησιμοποιήσουν τον λογαριασμό Google τους για να έχουν πρόσβαση στα δεδομένα τους. Δεν είναι διαθέσιμες όλες οι δυνατότητες με αυτήν την επιλογή.';

  @override
  String get microsoftDescription =>
      'Συγχρονίστε τα δεδομένα σας με τη Microsoft. Αυτό συνιστάται για χρήστες που θέλουν να χρησιμοποιήσουν τον λογαριασμό Microsoft για να έχουν πρόσβαση στα δεδομένα τους. Δεν είναι διαθέσιμες όλες οι δυνατότητες με αυτήν την επιλογή.';

  @override
  String get addSource => 'Προσθήκη πηγής';

  @override
  String get local => 'Τοπικό';

  @override
  String get close => 'Κλείσιμο';

  @override
  String get unknown => 'Άγνωστο';

  @override
  String get loading => 'Φόρτωση';

  @override
  String get export => 'Εξαγωγή';

  @override
  String get createEvent => 'Δημιουργία συμβάντος';

  @override
  String get save => 'Αποθήκευση';

  @override
  String get allSources => 'Όλες οι πηγές';

  @override
  String get editEvent => 'Επεξεργασία συμβάντος';

  @override
  String get end => 'Τέλος';

  @override
  String get location => 'Τοποθεσία';

  @override
  String get status => 'Κατάσταση';

  @override
  String get confirmed => 'Επιβεβαιωμένο';

  @override
  String get draft => 'Πρόχειρο';

  @override
  String get cancelled => 'Ακυρώθηκε';

  @override
  String get general => 'Γενικά';

  @override
  String get notes => 'Σημειώσεις';

  @override
  String get createNote => 'Δημιουργία σημείωσης';

  @override
  String get editNote => 'Επεξεργασία σημείωσης';

  @override
  String get indicatorEmpty => 'Δεν βρέθηκαν στοιχεία';

  @override
  String get indicatorEmptyDescription => 'Η λίστα είναι κενή.';

  @override
  String get indicatorLoading => 'Φόρτωση';

  @override
  String get indicatorError => 'Παρουσιάστηκε ένα σφάλμα';

  @override
  String get indicatorErrorDescription =>
      'Παρουσιάστηκε σφάλμα κατά τη φόρτωση των δεδομένων.';

  @override
  String get tryAgain => 'Προσπαθήστε ξανά';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event στο $date στο $time στο $location ($status)';
  }

  @override
  String get filter => 'Φίλτρο';

  @override
  String get done => 'Ολοκληρώθηκε';

  @override
  String get inProgress => 'Σε εξέλιξη';

  @override
  String get note => 'Σημείωση';

  @override
  String get delete => 'Διαγραφή';

  @override
  String get edit => 'Επεξεργασία';

  @override
  String deleteGroup(String name) {
    return 'Διαγραφή ομάδας $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την ομάδα $name?';
  }

  @override
  String groupName(String name) {
    return 'Ομάδα $name';
  }

  @override
  String get noData => 'Δεν υπάρχουν δεδομένα για εμφάνιση.';

  @override
  String get noEvents => 'Δεν υπάρχουν γεγονότα για εμφάνιση.';

  @override
  String get group => 'Ομάδα';

  @override
  String get search => 'Αναζήτηση';

  @override
  String get events => 'Συμβάντα';

  @override
  String get past => 'Παρελθόν';

  @override
  String get decentralized => 'Αποκεντρωμένη';

  @override
  String get decentralizedDescription =>
      'Η αποκεντρωμένη διεπαφή σας επιτρέπει να έχετε πρόσβαση στα δεδομένα σας από οποιονδήποτε αποκεντρωμένο διακομιστή. Μπορείτε να το χρησιμοποιήσετε για να συγχρονίσετε τα δεδομένα σας με άλλες συσκευές ή υπηρεσίες.';

  @override
  String get importFile => 'Εισαγωγή αρχείου';

  @override
  String get importFileDescription =>
      'Εισαγωγή ενός αρχείου από τη συσκευή σας. Μπορείτε να εισαγάγετε ένα αρχείο βάσης δεδομένων από άλλο παράδειγμα Linwood Flow ή ένα κανονικό αρχείο ημερολογίου.';

  @override
  String get icalDescription =>
      'Η διεπαφή iCal σας επιτρέπει να έχετε πρόσβαση στα δεδομένα σας από οποιονδήποτε διακομιστή iCal. Μπορεί να διαβάσει μόνο δεδομένα και δεν υποστηρίζει εγγραφή. Μπορείτε να το χρησιμοποιήσετε για να συγχρονίσετε τα δεδομένα σας με άλλες συσκευές ή υπηρεσίες που δεν υποστηρίζουν CalDAV.';

  @override
  String get resource => 'Πόρος';

  @override
  String get editResource => 'Επεξεργασία πόρου';

  @override
  String deleteResource(String name) {
    return 'Διαγραφή πόρου $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Are you sure you want to delete the resource $name ? (Automatic Copy)';
  }

  @override
  String get priority => 'Προτεραιότητα';

  @override
  String get assignEvent => 'Ανάθεση συμβάντος';

  @override
  String get noEvent => 'Δεν υπάρχει συμβάν';

  @override
  String get parentGroup => 'Γονική ομάδα';

  @override
  String deleteUser(String name) {
    return 'Διαγραφή χρήστη $name';
  }

  @override
  String get createUser => 'Δημιουργία χρήστη';

  @override
  String get editUser => 'Επεξεργασία χρήστη';

  @override
  String deleteUserDescription(String name) {
    return 'Είστε βέβαιοι ότι θέλετε να διαγράψετε το χρήστη $name?';
  }

  @override
  String get pending => 'Εκκρεμεί';

  @override
  String get removeEvent => 'Αφαίρεση συμβάντος';

  @override
  String get event => 'Γεγονός';

  @override
  String get nativeTitleBar => 'Εγγενής γραμμή τίτλου';

  @override
  String get blocked => 'Αποκλεισμένος';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count γεγονότα',
      one: '1 εκδήλωση',
      zero: 'Δεν υπάρχουν γεγονότα',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Εισαγωγή';

  @override
  String get confirmImport => 'Είστε σίγουροι ότι θέλετε να το εισαγάγετε?';

  @override
  String get welcome => 'Καλωσόρισμα';

  @override
  String get url => 'URL';

  @override
  String get username => 'Όνομα Χρήστη';

  @override
  String get password => 'Κωδικός';

  @override
  String get connect => 'Σύνδεση';

  @override
  String get data => 'Δεδομένα';

  @override
  String get syncing => 'Συγχρονισμός';

  @override
  String get synced => 'Συγχρονισμένα';

  @override
  String get error => 'Σφάλμα';

  @override
  String get always => 'Πάντα';

  @override
  String get noMobile => 'Χωρίς κινητό';

  @override
  String get manual => 'Χειροκίνητα';

  @override
  String get syncMode => 'Λειτουργία συγχρονισμού';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Διορισμός';

  @override
  String get moment => 'Στιγμή';

  @override
  String get time => 'Ώρα';

  @override
  String deleteEvent(String name) {
    return 'Διαγραφή εκδήλωσης $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την εκδήλωση $name?';
  }

  @override
  String get createAppointment => 'Δημιουργία ραντεβού';

  @override
  String get editAppointment => 'Επεξεργασία ραντεβού';

  @override
  String get createMoment => 'Δημιουργία στιγμής';

  @override
  String get editMoment => 'Επεξεργασία στιγμής';

  @override
  String get convertToNote => 'Μετατροπή σε σημείωση';

  @override
  String get convertToTodo => 'Μετατροπή σε todo';

  @override
  String get open => 'Άνοιγμα';

  @override
  String get limited => 'Περιορισμένη';

  @override
  String get notSet => 'Δεν έχει οριστεί';

  @override
  String get createPending => 'Δημιουργία σε αναμονή';

  @override
  String get editPending => 'Επεξεργασία σε αναμονή';

  @override
  String get convertTo => 'Μετατροπή σε';

  @override
  String get comingSoon => 'Έρχεται σύντομα';

  @override
  String get notSupported => 'Δεν υποστηρίζεται';

  @override
  String get databaseVersion => 'Έκδοση βάσης δεδομένων';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Επαναφορά';

  @override
  String get markdownIsSupported => 'Το Markdown υποστηρίζεται';

  @override
  String get createLabel => 'Δημιουργία ετικέτας';

  @override
  String get editLabel => 'Επεξεργασία ετικέτας';

  @override
  String deleteLabel(String name) {
    return 'Διαγραφή ετικέτας $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την ετικέτα $name?';
  }

  @override
  String get label => 'Ετικέτα';

  @override
  String get startOfWeek => 'Έναρξη της εβδομάδας';

  @override
  String headlineNumber(int number) {
    return 'Επικεφαλίδα $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Επιγράμμιση';

  @override
  String get code => 'Κωδικός';

  @override
  String get link => 'Σύνδεσμος';

  @override
  String get codeBlock => 'Ταμπλό κώδικα';

  @override
  String get quote => 'Παράθεση';

  @override
  String get numberedList => 'Αριθμημένη λίστα';

  @override
  String get density => 'Πυκνότητα';

  @override
  String get compact => 'Συμπαγής';

  @override
  String get comfortable => 'Άνετο';

  @override
  String get standard => 'Τυπικό';

  @override
  String get highContrast => 'Υψηλή αντίθεση';

  @override
  String get labels => 'Ετικέτες';

  @override
  String get systemLocale => 'Τοπική ρύθμιση συστήματος';

  @override
  String get notebooks => 'Σημειωματάριο';

  @override
  String get createNotebook => 'Δημιουργία σημειωματάριο';

  @override
  String get editNotebook => 'Επεξεργασία σημειωματικού';

  @override
  String get update => 'Ενημέρωση';

  @override
  String get currentVersion => 'Τρέχουσα έκδοση';

  @override
  String get checkForUpdates => 'Έλεγχος ενημερώσεων';

  @override
  String get checkForUpdatesWarning =>
      'Η εκτέλεση ελέγχου για ενημερώσεις θα συνδεθεί με την ιστοσελίδα Flow για να πάρει τις πληροφορίες.';

  @override
  String get usingLatestStable => 'Χρησιμοποιείτε την τελευταία σταθερή έκδοση';

  @override
  String get usingLatestNightly =>
      'Χρησιμοποιείτε την τελευταία νυχτερινή έκδοση';

  @override
  String get updateNow => 'Ενημέρωση τώρα';

  @override
  String get stable => 'Σταθερό';

  @override
  String get nightly => 'Νυχτερινή';

  @override
  String get updateAvailable => 'Διαθέσιμη ενημέρωση';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count αντικείμενα',
      one: '1 στοιχείο',
      zero: 'Δεν υπάρχουν αντικείμενα',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'Θέμα συστήματος';

  @override
  String get desktop => 'Επιφάνεια Εργασίας';

  @override
  String get restoreSettingsFromFile => 'Επαναφορά ρυθμίσεων από αρχείο';

  @override
  String get exportSettingsToFile => 'Εξαγωγή ρυθμίσεων σε αρχείο';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Ενεργοποιημένο';

  @override
  String get countdown => 'Αντίστροφη μέτρηση';

  @override
  String get unlink => 'Αποσύνδεση';

  @override
  String get noAlarms =>
      'Δεν υπάρχουν ειδοποιήσεις για εμφάνιση. @ info: whatsthis';

  @override
  String get allDay => 'Όλη την ημέρα';
}
