// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Danish (`da`).
class AppLocalizationsDa extends AppLocalizations {
  AppLocalizationsDa([String locale = 'da']) : super(locale);

  @override
  String get dashboard => 'Instrumentbræt';

  @override
  String get translate => 'Oversæt';

  @override
  String get calendar => 'Kalender';

  @override
  String get resources => 'Ressourcer';

  @override
  String get users => 'Brugere';

  @override
  String get user => 'Bruger';

  @override
  String get sources => 'Kilder';

  @override
  String get settings => 'Indstillinger';

  @override
  String get create => 'Opret';

  @override
  String get information => 'Information';

  @override
  String get source => 'Kilde';

  @override
  String get license => 'Licens';

  @override
  String get thirdPartyLicenses => 'Tredjeparts Licenser';

  @override
  String get documentation => 'Dokumentation';

  @override
  String get privacyPolicy => 'Privat Politik';

  @override
  String get imprint => 'Imprint';

  @override
  String get releaseNotes => 'Udgivelsesnoter';

  @override
  String get changelog => 'Ændringslog';

  @override
  String get legal => 'Lovlig';

  @override
  String get personalization => 'Personliggørelse';

  @override
  String get design => 'Design';

  @override
  String get language => 'Sprog';

  @override
  String get theme => 'Tema';

  @override
  String get classic => 'Klassisk';

  @override
  String get systemDefault => 'System Standard';

  @override
  String get light => 'Lys';

  @override
  String get dark => 'Mørk';

  @override
  String get createResource => 'Opret ressource';

  @override
  String get cancel => 'Annuller';

  @override
  String get name => 'Navn';

  @override
  String get description => 'Varebeskrivelse';

  @override
  String get start => 'Start';

  @override
  String get next => 'Næste';

  @override
  String get skip => 'Overspring';

  @override
  String get back => 'Tilbage';

  @override
  String get today => 'Idag';

  @override
  String get groups => 'Grupper';

  @override
  String get createGroup => 'Opret gruppe';

  @override
  String get editGroup => 'Rediger gruppe';

  @override
  String get list => 'Liste';

  @override
  String get day => 'Dag';

  @override
  String get week => 'Uge';

  @override
  String get month => 'Måned';

  @override
  String get version => 'Version';

  @override
  String get intro => 'Introduktion';

  @override
  String get caldavDescription =>
      'CalDAV interface giver dig mulighed for at få adgang til dine data fra enhver CalDAV server. Det har begrænset understøttelse, og kun grundlæggende funktioner understøttes. Du kan bruge det til at synkronisere dine data med andre enheder eller tjenester.';

  @override
  String get webdavDescription =>
      'WebDAV interface giver dig mulighed for at få adgang til dine data fra enhver WebDAV server. Det filer og mapper til at gemme data. Du kan bruge det til at synkronisere dine data med andre enheder eller tjenester.';

  @override
  String get server => 'Server';

  @override
  String get serverDescription =>
      'Synkroniser dine data med en indfødt Linwood Flow server. Dette anbefales til brugere, der ønsker at selv-vært deres data.';

  @override
  String get googleDescription =>
      'Synkroniser dine data med Google. Dette anbefales til brugere, der ønsker at bruge deres Google-konto til at få adgang til deres data. Ikke alle funktioner er tilgængelige med denne indstilling.';

  @override
  String get microsoftDescription =>
      'Synkroniser dine data med Microsoft. Dette anbefales til brugere, der ønsker at bruge deres Microsoft-konto til at få adgang til deres data. Ikke alle funktioner er tilgængelige med denne indstilling.';

  @override
  String get addSource => 'Tilføj kilde';

  @override
  String get local => 'Lokal';

  @override
  String get close => 'Luk';

  @override
  String get unknown => 'Ukendt';

  @override
  String get loading => 'Indlæser';

  @override
  String get export => 'Eksporter';

  @override
  String get createEvent => 'Opret begivenhed';

  @override
  String get save => 'Gem';

  @override
  String get allSources => 'Alle kilder';

  @override
  String get editEvent => 'Rediger begivenhed';

  @override
  String get end => 'Slut';

  @override
  String get location => 'Placering';

  @override
  String get status => 'Status';

  @override
  String get confirmed => 'Bekræftet';

  @override
  String get draft => 'Kladde';

  @override
  String get cancelled => 'Annulleret';

  @override
  String get general => 'Generelt';

  @override
  String get notes => 'Noter';

  @override
  String get createNote => 'Opret note';

  @override
  String get editNote => 'Rediger note';

  @override
  String get indicatorEmpty => 'Ingen elementer fundet';

  @override
  String get indicatorEmptyDescription => 'Listen er i øjeblikket tom.';

  @override
  String get indicatorLoading => 'Indlæser';

  @override
  String get indicatorError => 'Der opstod en fejl';

  @override
  String get indicatorErrorDescription =>
      'Der opstod en fejl under indlæsning af data.';

  @override
  String get tryAgain => 'Prøv igen';

  @override
  String eventInfo(
    String event,
    String date,
    String time,
    String location,
    String status,
  ) {
    return '$event $date kl. $time i $location ($status)';
  }

  @override
  String get filter => 'Filtrer';

  @override
  String get done => 'Udført';

  @override
  String get inProgress => 'I gang';

  @override
  String get note => 'Bemærkning';

  @override
  String get delete => 'Slet';

  @override
  String get edit => 'Rediger';

  @override
  String deleteGroup(String name) {
    return 'Slet gruppe $name';
  }

  @override
  String deleteGroupDescription(String name) {
    return 'Er du sikker på, at du vil slette gruppen $name?';
  }

  @override
  String groupName(String name) {
    return 'Gruppe $name';
  }

  @override
  String get noData => 'Der er ingen data at vise.';

  @override
  String get noEvents => 'Der er ingen begivenheder at vise.';

  @override
  String get group => 'Gruppe';

  @override
  String get search => 'Søg';

  @override
  String get events => 'Begivenheder';

  @override
  String get past => 'Tidligere';

  @override
  String get decentralized => 'Decentraliseret';

  @override
  String get decentralizedDescription =>
      'Den decentraliserede grænseflade giver dig adgang til dine data fra enhver decentraliseret server. Du kan bruge den til at synkronisere dine data med andre enheder eller tjenester.';

  @override
  String get importFile => 'Importér fil';

  @override
  String get importFileDescription =>
      'Importer en fil fra din enhed. Du kan importere en databasefil fra en anden Linwood Flow instans eller en almindelig kalenderfil.';

  @override
  String get icalDescription =>
      'ICal interface giver dig adgang til dine data fra enhver iCal server. Det kan kun læse data og understøtter ikke skrivning. Du kan bruge den til at synkronisere dine data med andre enheder eller tjenester, der ikke understøtter CalDAV.';

  @override
  String get resource => 'Ressource';

  @override
  String get editResource => 'Rediger ressource';

  @override
  String deleteResource(String name) {
    return 'Slet ressource $name';
  }

  @override
  String deleteResourceDescription(String name) {
    return 'Er du sikker på du vil slette ressourcen $name?';
  }

  @override
  String get priority => 'Prioritet';

  @override
  String get assignEvent => 'Tildel begivenhed';

  @override
  String get noEvent => 'Ingen begivenhed';

  @override
  String get parentGroup => 'Overordnet gruppe';

  @override
  String deleteUser(String name) {
    return 'Slet bruger $name';
  }

  @override
  String get createUser => 'Opret bruger';

  @override
  String get editUser => 'Rediger bruger';

  @override
  String deleteUserDescription(String name) {
    return 'Er du sikker på, at du vil slette brugeren $name?';
  }

  @override
  String get pending => 'Afventer';

  @override
  String get removeEvent => 'Fjern begivenhed';

  @override
  String get event => 'Begivenhed';

  @override
  String get nativeTitleBar => 'Lokal titellinje';

  @override
  String get blocked => 'Blokeret';

  @override
  String countEvents(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count begivenheder',
      one: '1 begivenhed',
      zero: 'Ingen begivenheder',
    );
    return '$_temp0';
  }

  @override
  String get import => 'Importér';

  @override
  String get confirmImport => 'Er du sikker på, at du vil importere den?';

  @override
  String get welcome => 'Velkommen';

  @override
  String get url => 'URL';

  @override
  String get username => 'Brugernavn';

  @override
  String get password => 'Adgangskode';

  @override
  String get connect => 'Forbind';

  @override
  String get data => 'Data';

  @override
  String get syncing => 'Synkroniserer';

  @override
  String get synced => 'Synkroniseret';

  @override
  String get error => 'Fejl';

  @override
  String get always => 'Altid';

  @override
  String get noMobile => 'Ingen mobil';

  @override
  String get manual => 'Manuelt';

  @override
  String get syncMode => 'Synkroniser tilstand';

  @override
  String get todo => 'Todo';

  @override
  String get appointment => 'Aftale';

  @override
  String get moment => 'Moment';

  @override
  String get time => 'Tid';

  @override
  String deleteEvent(String name) {
    return 'Slet begivenhed $name';
  }

  @override
  String deleteEventDescription(String name) {
    return 'Er du sikker på du vil slette begivenheden $name?';
  }

  @override
  String get createAppointment => 'Opret aftale';

  @override
  String get editAppointment => 'Rediger aftale';

  @override
  String get createMoment => 'Opret øjeblik';

  @override
  String get editMoment => 'Rediger øjeblik';

  @override
  String get convertToNote => 'Konvertér til note';

  @override
  String get convertToTodo => 'Konverter til todo';

  @override
  String get open => 'Åbn';

  @override
  String get limited => 'Begrænset';

  @override
  String get notSet => 'Ikke angivet';

  @override
  String get createPending => 'Opret afventende';

  @override
  String get editPending => 'Rediger afventende';

  @override
  String get convertTo => 'Konvertér til';

  @override
  String get comingSoon => 'Kommer snart';

  @override
  String get notSupported => 'Ikke understøttet';

  @override
  String get databaseVersion => 'Database version';

  @override
  String get minimize => 'Minimize';

  @override
  String get maximize => 'Maximize';

  @override
  String get restore => 'Gendan';

  @override
  String get markdownIsSupported => 'Markdown understøttes';

  @override
  String get createLabel => 'Opret etiket';

  @override
  String get editLabel => 'Rediger etiket';

  @override
  String deleteLabel(String name) {
    return 'Slet etiket $name';
  }

  @override
  String deleteLabelDescription(Object name) {
    return 'Er du sikker på, at du vil slette etiketten $name?';
  }

  @override
  String get label => 'Etiket';

  @override
  String get startOfWeek => 'Start af uge';

  @override
  String headlineNumber(int number) {
    return 'Overskrift $number';
  }

  @override
  String get bold => 'Bold';

  @override
  String get italic => 'Italic';

  @override
  String get strikethrough => 'Gennemstreget';

  @override
  String get code => 'Kode';

  @override
  String get link => 'Link';

  @override
  String get codeBlock => 'Kode blok';

  @override
  String get quote => 'Tilbud';

  @override
  String get numberedList => 'Nummereret liste';

  @override
  String get density => 'Tæthed';

  @override
  String get compact => 'Kompakt';

  @override
  String get comfortable => 'Behageligt';

  @override
  String get standard => 'Standard';

  @override
  String get highContrast => 'Høj kontrast';

  @override
  String get labels => 'Etiketter';

  @override
  String get systemLocale => 'System landestandard';

  @override
  String get notebooks => 'Notesbøger';

  @override
  String get createNotebook => 'Opret notesbog';

  @override
  String get editNotebook => 'Rediger notesbog';

  @override
  String get update => 'Opdater';

  @override
  String get currentVersion => 'Nuværende version';

  @override
  String get checkForUpdates => 'Søg efter opdateringer';

  @override
  String get checkForUpdatesWarning =>
      'Udførelse af en check for opdateringer vil forbinde til Flow hjemmeside for at få oplysningerne.';

  @override
  String get usingLatestStable => 'Du bruger den seneste stabile version';

  @override
  String get usingLatestNightly => 'Du bruger den seneste natlige version';

  @override
  String get updateNow => 'Opdater nu';

  @override
  String get stable => 'Stabil';

  @override
  String get nightly => 'Natligt';

  @override
  String get updateAvailable => 'Opdatering tilgængelig';

  @override
  String countItems(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count genstande',
      one: '1 genstand',
      zero: 'Ingen genstande',
    );
    return '$_temp0';
  }

  @override
  String get systemTheme => 'System tema';

  @override
  String get desktop => 'Skrivebord';

  @override
  String get restoreSettingsFromFile => 'Gendan indstillinger fra fil';

  @override
  String get exportSettingsToFile => 'Eksporter indstillinger til fil';

  @override
  String get alarm => 'Alarm';

  @override
  String get enabled => 'Aktiveret';

  @override
  String get countdown => 'Nedtælling';

  @override
  String get unlink => 'Afbryd';

  @override
  String get noAlarms => 'Der er ingen alarmer at vise.';

  @override
  String get allDay => 'Hele dagen';
}
