// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Turkish (`tr`).
class AppLocalizationsTr extends AppLocalizations {
  AppLocalizationsTr([String locale = 'tr']) : super(locale);

  @override
  String get open => 'Aç';

  @override
  String get settings => 'Ayarlar';

  @override
  String get personalization => 'Kişiselleştirme';

  @override
  String get theme => 'Tema';

  @override
  String get darkTheme => 'Koyu Tema';

  @override
  String get lightTheme => 'Aydınlık Tema';

  @override
  String get systemTheme => 'Varsayılan sistem temasını kullan';

  @override
  String get view => 'Görüntüle';

  @override
  String get edit => 'Düzenle';

  @override
  String get export => 'Dışa Aktar';

  @override
  String get save => 'Kaydet';

  @override
  String get zoom => 'Yakınlaştırma';

  @override
  String get zoomIn => 'Yakınlaştır';

  @override
  String get zoomOut => 'Uzaklaştır';

  @override
  String get resetZoom => 'Yakınlaştırmayı sıfırla';

  @override
  String get strokeWidth => 'Kontur genişliği';

  @override
  String get includeEraser => 'Dahili silgi?';

  @override
  String get thinning => 'Kalinlik';

  @override
  String get pen => 'Kalem';

  @override
  String get invertedPen => 'Ters Kalem';

  @override
  String get eraser => 'Silgi';

  @override
  String get pathEraser => 'Yol silici';

  @override
  String get label => 'Etiket';

  @override
  String get delete => 'Sil';

  @override
  String get areYouSure => 'Emin misiniz?';

  @override
  String get reallyDelete => 'Bu ögeyi gerçekten silmek isteyor musunuz?';

  @override
  String get no => 'Hayır';

  @override
  String get yes => 'Evet';

  @override
  String get undo => 'Geri al';

  @override
  String get redo => 'Yinele';

  @override
  String get general => 'Genel';

  @override
  String get copyTitle => 'Panoya kopyalandı';

  @override
  String get loading => 'Yükleniyor...';

  @override
  String get enterText => 'Metin girin';

  @override
  String get size => 'Boyut';

  @override
  String get width => 'Genişlik';

  @override
  String get height => 'Yükseklik';

  @override
  String get count => 'Miktar';

  @override
  String get space => 'Boşluk';

  @override
  String get background => 'Arkaplan';

  @override
  String get box => 'Kutu';

  @override
  String get locale => 'Dil';

  @override
  String get systemLocale => 'Sistem varsayılanı';

  @override
  String get information => 'Bilgilendirme';

  @override
  String get license => 'Lisans';

  @override
  String get imprint => 'Künye';

  @override
  String get privacypolicy => 'Gizlilik politikası';

  @override
  String get sourceCode => 'Kaynak kodu';

  @override
  String get documentation => 'Belgeler';

  @override
  String get changelog => 'Değişiklik günlüğü';

  @override
  String get source => 'Kaynak';

  @override
  String get existOverride => 'Dosya zaten var. Üzerine yazılsın mı?';

  @override
  String get description => 'Tanım';

  @override
  String get fill => 'Dolgu';

  @override
  String get defaultPalette => 'Varsayılan palet';

  @override
  String get highlighter => 'Fosforlu kalem';

  @override
  String get add => 'Ekle';

  @override
  String get remove => 'Kaldır';

  @override
  String get removeConfirm => 'Bunu gerçekten kaldırmak istiyor musunuz?';

  @override
  String get resetPalette => 'Paleti sıfırla';

  @override
  String get custom => 'Özel';

  @override
  String get decoration => 'Dekorasyon';

  @override
  String get underline => 'Alt Çizgi';

  @override
  String get overline => 'Üst çizgi';

  @override
  String get strikethrough => 'Üstü çizili';

  @override
  String get thickness => 'Kalınlık';

  @override
  String get style => 'Biçim';

  @override
  String get solid => 'Katı';

  @override
  String get double => 'Çift';

  @override
  String get dotted => 'Noktalı';

  @override
  String get dashed => 'Kesik çizgili';

  @override
  String get wavy => 'Dalgalı';

  @override
  String get fontWeight => 'Yazı tipi kalınlığı';

  @override
  String get normal => 'Normal';

  @override
  String get bold => 'Kalın';

  @override
  String get italic => 'Eğik';

  @override
  String get clipboard => 'Pano';

  @override
  String get file => 'Dosya';

  @override
  String get data => 'Veri';

  @override
  String get share => 'Paylaş';

  @override
  String get spacing => 'Aralık';

  @override
  String get image => 'Görsel';

  @override
  String get enterUrl => 'Bağlantı adresini girin';

  @override
  String get scale => 'Ölçek';

  @override
  String get help => 'Yardım';

  @override
  String get reallyReset => 'Bunu gerçekten sıfırlamak istiyor musunuz?';

  @override
  String get whatToDo => 'Ne yapmak istiyorsun?';

  @override
  String get ignore => 'Yoksay';

  @override
  String get backup => 'Yedekle';

  @override
  String createdInNewerVersion(String fileName, int fileVersion) {
    return '$fileName adındaki dosya daha yeni bir sürümde ($fileVersion) adıyla yeniden oluşturuldu. Bu dosyazı ne yapmak istersiniz?';
  }

  @override
  String get waypoints => 'Yer İşaretleri';

  @override
  String get origin => 'Kaynak';

  @override
  String get import => 'İçe aktar';

  @override
  String get newContent => 'Yeni';

  @override
  String get selectElement => 'Ögeyi seç';

  @override
  String get ctrlKey => 'Ctrl';

  @override
  String get shiftKey => 'Shift';

  @override
  String get altKey => 'Alt';

  @override
  String get copyVersion => 'Kopya sürümü';

  @override
  String get input => 'Girdi';

  @override
  String get behaviors => 'Davranışlar';

  @override
  String get dataDirectory => 'Veri dizini';

  @override
  String get defaultPath => 'Varsayılan yol';

  @override
  String get dateFormat => 'Tarih biçimi';

  @override
  String updatedAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Güncellenme tarihi: $dateTimeString';
  }

  @override
  String createdAt(DateTime dateTime) {
    final intl.DateFormat dateTimeDateFormat = intl.DateFormat(
      'yy-MM-dd H:mm',
      localeName,
    );
    final String dateTimeString = dateTimeDateFormat.format(dateTime);

    return 'Oluşturulma tarihi: $dateTimeString';
  }

  @override
  String get rename => 'Yeniden adlandır';

  @override
  String get duplicate => 'Çoğalt';

  @override
  String get hand => 'El';

  @override
  String get folder => 'Klasör';

  @override
  String get move => 'Taşı';

  @override
  String get copy => 'Kopyala';

  @override
  String get back => 'Geri';

  @override
  String get zoomDependent => 'Bağımlı yakınlaştırma';

  @override
  String get shapeDetection => 'Şekil Algılama';

  @override
  String get delay => 'Gecikme';

  @override
  String get defaultLayer => 'Varsayılan Katman';

  @override
  String get layer => 'Katman';

  @override
  String get layers => 'Katmanlar';

  @override
  String get notSet => 'Ayarlanmamış';

  @override
  String get enterLayer => 'Katman adı gir';

  @override
  String get selectElements => 'Ögeleri seçin';

  @override
  String get deleteElements => 'Ögeleri sil';

  @override
  String get deleteElementsConfirm =>
      'Seçili ögeleri gerçekten silmek istiyor musunuz?';

  @override
  String get selectCustomCollection => 'Özel koleksiyon seç';

  @override
  String get svg => 'SVG';

  @override
  String get sensitivity => 'Hassasiyet';

  @override
  String get sensitivityHint => 'Değer arttıkça hassasiyet artar';

  @override
  String get horizontal => 'Yatay';

  @override
  String get vertical => 'Dikey';

  @override
  String get plain => 'Sade';

  @override
  String get light => 'Açık';

  @override
  String get ruled => 'Çizgili';

  @override
  String get quad => 'Kareli';

  @override
  String get music => 'Müzik';

  @override
  String get dark => 'Koyu';

  @override
  String get plainDark => 'Koyu';

  @override
  String get ruledDark => 'Çizgili koyu';

  @override
  String get quadDark => 'Kareli koyu';

  @override
  String get musicDark => 'Müzik koyu';

  @override
  String get templates => 'Şablonlar';

  @override
  String get untitled => 'Başlıksız';

  @override
  String get createTemplate => 'Şablon oluştur';

  @override
  String get createTemplateContent =>
      'Bu belgeyi şablon haline getirmek istediğinizden emin misiniz? Orijinal belge silinecektir.';

  @override
  String get replace => 'Değiştir';

  @override
  String get reallyReplace =>
      'Bu şablonu gerçekten silmek istiyor musunuz? Bu işlem geri alınamaz!';

  @override
  String get defaultTemplate => 'Varsayılan şablon';

  @override
  String get insert => 'Ekle';

  @override
  String get document => 'Belge';

  @override
  String get camera => 'Kamera';

  @override
  String get printout => 'Çıktı';

  @override
  String get selectCamera => 'Kamera Seç';

  @override
  String get changeDocumentPath => 'Belge yolunu değiştir';

  @override
  String get deleteWholeStroke => 'Tüm konturu sil';

  @override
  String get alpha => 'Şefaflık';

  @override
  String get area => 'Alan';

  @override
  String get selectArea => 'Bir alan seçin';

  @override
  String get aspectRatio => 'En boy oranı';

  @override
  String get presets => 'Hazır Ayarlar';

  @override
  String get pagePortrait => 'Dikey sayfa';

  @override
  String get pageLandscape => 'Yatay sayfa';

  @override
  String get square => 'Kare';

  @override
  String get areas => 'Alanlar';

  @override
  String get enterArea => 'Alana gir';

  @override
  String get exitArea => 'Alandan çık';

  @override
  String get currentArea => 'Mevcut alan';

  @override
  String get design => 'Tasarım';

  @override
  String get text => 'Metin';

  @override
  String welcome(String codeName) {
    return 'Hey, this is Linwood Butterfly $codeName';
  }

  @override
  String get welcomeContent => 'Ücretsiz ve açık kaynaklı bir çizim alanı!';

  @override
  String updated(String version) {
    return 'Uygulama $version sürümüne güncellendi';
  }

  @override
  String get releaseNotes => 'Sürüm bilgileri';

  @override
  String get constraints => 'Kısıtlamalar';

  @override
  String get scaled => 'Ölçeklendirilmiş';

  @override
  String get fixed => 'Sabit';

  @override
  String get dynamicContent => 'Dinamik';

  @override
  String get none => 'Yok';

  @override
  String get includeArea => 'Dahili alan';

  @override
  String get verticalAlignment => 'Dikey hizalama';

  @override
  String get horizontalAlignment => 'Yatay hizalama';

  @override
  String get top => 'Üst';

  @override
  String get center => 'Orta';

  @override
  String get bottom => 'Alt';

  @override
  String get left => 'Sol';

  @override
  String get right => 'Sağ';

  @override
  String get justify => 'Yasla';

  @override
  String get constraint => 'Kısıtlama';

  @override
  String get length => 'Uzunluk';

  @override
  String get exportSvg => 'SVG olarak dışa aktar';

  @override
  String get pdf => 'PDF';

  @override
  String get selectPages => 'Sayfaları seçin';

  @override
  String get recentFiles => 'Son kullanılanlar';

  @override
  String get start => 'Başlat';

  @override
  String get noRecentFiles => 'Son kullanılan dosya yok';

  @override
  String countPages(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pages',
      one: '1 page',
      zero: 'No pages',
    );
    return '$_temp0';
  }

  @override
  String pageIndex(int index) {
    return 'Sayfa $index';
  }

  @override
  String get exit => 'Çıkış';

  @override
  String get noElements => 'Öge yok';

  @override
  String get invertSelection => 'Seçimi tersine çevir';

  @override
  String get errorWhileImporting => 'İçeri aktarılırken hata oluştu';

  @override
  String get errorWhileImportingContent =>
      'Dosya içeri aktarırken bir hata oluştu';

  @override
  String get showDetails => 'Ayrıntıları göster';

  @override
  String get hideDetails => 'Detayları gizle';

  @override
  String get error => 'Hata';

  @override
  String get stackTrace => 'Yığın izleme';

  @override
  String get laser => 'Lazer';

  @override
  String get duration => 'Süre';

  @override
  String get quality => 'Kalite';

  @override
  String get exportPdf => 'PDF dışa aktar';

  @override
  String get local => 'Dil';

  @override
  String get addConnection => 'Bağlantı ekle';

  @override
  String get connections => 'Bağlantılar';

  @override
  String get noConnections => 'Bağlantı yok';

  @override
  String get url => 'URL';

  @override
  String get connect => 'Bağlan';

  @override
  String get username => 'Kullanıcı Adı';

  @override
  String get password => 'Şifre';

  @override
  String get webNotSupported => 'Web desteklenmiyor';

  @override
  String get advanced => 'Gelişmiş';

  @override
  String get directory => 'Dizin';

  @override
  String get documentsDirectory => 'Belge dizini';

  @override
  String get templatesDirectory => 'Şablon dizini';

  @override
  String get errorWhileCreatingConnection => 'Bağlantı oluşturulurken hata';

  @override
  String get cannotConnect => 'Bağlanamıyor';

  @override
  String get urlNotValid => 'URL geçerli değil';

  @override
  String get icon => 'Simge';

  @override
  String get update => 'Güncelleme';

  @override
  String get updateAvailable => 'Güncelleme mevcut';

  @override
  String get stable => 'Kararlı';

  @override
  String get nightly => 'Nightly';

  @override
  String get checkForUpdates => 'Güncellemeleri denetle';

  @override
  String get checkForUpdatesWarning =>
      'Performing a check for updates will connect to the Butterfly website to get the information.';

  @override
  String get usingLatestStable => 'En son sürümü kullanıyorsunuz';

  @override
  String get usingLatestNightly =>
      'En son nightly (kod tabanından gelen) sürümü kullanıyorsunuz';

  @override
  String get currentVersion => 'Şu anki sürüm';

  @override
  String get updateNow => 'Şimdi güncelle';

  @override
  String get shape => 'Şekil';

  @override
  String get circle => 'Daire';

  @override
  String get rectangle => 'Dikdörtgen';

  @override
  String get triangle => 'Üçgen';

  @override
  String get line => 'Çizgi';

  @override
  String get cornerRadius => 'Köşe yuvarlaklığı';

  @override
  String get topLeft => 'Sol üst';

  @override
  String get topRight => 'Sağ üst';

  @override
  String get bottomLeft => 'Sol alt';

  @override
  String get bottomRight => 'Sağ alt';

  @override
  String get caches => 'Önbellek';

  @override
  String get manage => 'Yönet';

  @override
  String get clearCaches => 'Önbelleği Temizle';

  @override
  String get createCache => 'Önbellek oluştur';

  @override
  String get thirdPartyLicenses => 'Üçüncü parti lisansları';

  @override
  String get syncing => 'Eşitleniyor...';

  @override
  String get synced => 'Eşitlendi';

  @override
  String get notSynced => 'Eşitlenmedi';

  @override
  String get conflict => 'Çakışma';

  @override
  String get keepLocal => 'Yerel olarak sakla';

  @override
  String get keepConnection => 'Bağlantıyı sürdür';

  @override
  String get keepBoth => 'Her ikisini de sakla';

  @override
  String get forAll => 'Tümü için';

  @override
  String fileConflict(String file, String connection) {
    return '$connection içinde $file çakışması var';
  }

  @override
  String get offline => 'Çevrimdışı';

  @override
  String get localLatest => 'En son dizin';

  @override
  String get connectionLatest => 'En son bağlantı';

  @override
  String get path => 'Yol';

  @override
  String get folderSynced => 'Klasör eşitlendi';

  @override
  String get syncRootDirectory => 'Kök dizini eşitle';

  @override
  String get penOnlyInput => 'Sadece kalem girişi';

  @override
  String get inputGestures => 'Giriş hareketleri';

  @override
  String get nativeTitleBar => 'Yerel başlık çubuğu';

  @override
  String get syncMode => 'Eşitleme kipi';

  @override
  String get connection => 'Bağlantı';

  @override
  String get always => 'Her zaman';

  @override
  String get noMobile => 'Mobil olmayan';

  @override
  String get manual => 'Kullanım kılavuzu';

  @override
  String get search => 'Ara';

  @override
  String get properties => 'Özellikler';

  @override
  String get pin => 'Sabitle';

  @override
  String get unpin => 'Sabitlemeyi kaldır';

  @override
  String get element => 'Öge';

  @override
  String get painter => 'Araç';

  @override
  String get position => 'Konum';

  @override
  String get note => 'Not';

  @override
  String get packs => 'Paketler';

  @override
  String get pack => 'Paket';

  @override
  String get more => 'Daha fazla';

  @override
  String get askForName => 'Isim sor';

  @override
  String areaIndex(int index) {
    return 'Alan $index';
  }

  @override
  String get startInFullScreen => 'Tam ekran göster';

  @override
  String get inputs => 'Girdiler';

  @override
  String get mouse => 'Fare';

  @override
  String get touch => 'Dokunma';

  @override
  String get keyboard => 'Klavye';

  @override
  String get shortcuts => 'Kısayollar';

  @override
  String get middle => 'Orta';

  @override
  String get first => 'İlk';

  @override
  String get second => 'İkinci';

  @override
  String get activeTool => 'Aktif Araç';

  @override
  String get activeToolDescription =>
      'Araç çubuğunda şu anda seçili aracı kullan';

  @override
  String get handTool => 'El Aracı';

  @override
  String get handToolDescription => 'Tuvali taşımak için sürükle';

  @override
  String get toolOnToolbar => 'Araç Çubuğunda Belirli Araç';

  @override
  String get toolOnToolbarDescription =>
      'Sol taraftan itibaren araç çubuğunda belirtilen konumdaki aracı kullan';

  @override
  String toolOnToolbarShort(int display_position) {
    return 'Araç Çubuğu Konumu: $display_position';
  }

  @override
  String get tools => 'Aletler';

  @override
  String get showGrid => 'Izgarayı göster';

  @override
  String get grid => 'Izgara';

  @override
  String get ruler => 'Cetvel';

  @override
  String get angle => 'Açı';

  @override
  String get report => 'Rapor Et';

  @override
  String get newFolder => 'Yeni klasör';

  @override
  String get createPack => 'Paket oluştur';

  @override
  String get editPack => 'Paketi düzenle';

  @override
  String get packsDirectory => 'Paket dizini';

  @override
  String get stamp => 'Damga';

  @override
  String get addToPack => 'Paket ekle';

  @override
  String get sureImportPack =>
      'Paketi içe aktarmak istediğinizden emin misiniz?';

  @override
  String byAuthor(String author) {
    return '$author tarafından';
  }

  @override
  String get author => 'Yazar';

  @override
  String get addAsset => 'Varlık ekle';

  @override
  String get editAsset => 'Varlığı düzenle';

  @override
  String get scope => 'Kapsam';

  @override
  String get noPacks => 'Şu anda kullanılabilir paket yok';

  @override
  String get components => 'Bileşenler';

  @override
  String get waypoint => 'Yer İşareti';

  @override
  String get actions => 'Eylemler';

  @override
  String get painters => 'Araçlar';

  @override
  String get breakingChangesTitle => 'Son dakika değişiklikleri';

  @override
  String breakingChangesMessage(int version, int newVersion) {
    return 'Bu sürümde çok önemli değişiklikler var. Güncellemeden önce lütfen değişiklik günlüğünü okuyun. Geçerli dosya sürümü $version, yeni sürüm ise $newVersion.';
  }

  @override
  String get styles => 'Stiller';

  @override
  String get paragraph => 'Paragraf';

  @override
  String get fontFamily => 'Yazı tipi ailesi';

  @override
  String get smoothing => 'Yumuşatma';

  @override
  String get streamline => 'Kolaylaştırmak';

  @override
  String get presentation => 'Sunum';

  @override
  String get selectAsset => 'Varlık seçin';

  @override
  String get clearStyle => 'Stili Temizle';

  @override
  String get unknownImportType => 'Bilinmeyen içe aktarım biçimi';

  @override
  String get sureImportTemplate =>
      'Şablonu içe aktarmak istediğinizden emin misiniz?';

  @override
  String get frame => 'Çerçeve';

  @override
  String get play => 'Yürüt';

  @override
  String get video => 'Video';

  @override
  String get fps => 'FPS';

  @override
  String get breakpoint => 'Kesme noktası';

  @override
  String get presentationControls => 'Sunum kontrolleri';

  @override
  String get nextSlide => 'Sonraki slayt';

  @override
  String get nextSlideDescription =>
      'Bir sonraki slayda gitmek için sağa kaydırın veya sağ ok tuşuna basın';

  @override
  String get previousSlide => 'Önceki slayt';

  @override
  String get previousSlideDescription =>
      'Bir önceki slayda gitmek için sola kaydırın veya sol ok tuşuna basın';

  @override
  String get exitPresentation => 'Sunum modundan çık';

  @override
  String get exitPresentationDescription =>
      'Sunundan çıkmak için escape tuşuna basın veya aşağı kaydırın';

  @override
  String get pausePresentation => 'Sunum modunu duraklat';

  @override
  String get pausePresentationDescription =>
      'Sunumu duraklatmak veya sürdürmek için ekrana dokunun veya boşluk çubuğuna basın';

  @override
  String get keyframe => 'Keyframe';

  @override
  String get endOfPresentation => 'Sunumun sonuna geldiniz';

  @override
  String get startOfPresentation => 'Sunumun başlangıcına ulaştınız';

  @override
  String get palettes => 'Paletler';

  @override
  String headline(int index) {
    return 'Başlık $index';
  }

  @override
  String get code => 'Kod';

  @override
  String get quote => 'Alıntı';

  @override
  String get link => 'Bağlantı';

  @override
  String get checkbox => 'Onay kutusu';

  @override
  String get deleted => 'Silinmiş';

  @override
  String get emphasis => 'Vurgu';

  @override
  String get listBullet => 'Liste madde işareti';

  @override
  String get strong => 'Kalın';

  @override
  String get markdown => 'Markdown';

  @override
  String get home => 'Ana sayfa';

  @override
  String get files => 'Dosyalar';

  @override
  String get sortBy => 'Şuna göre sırala';

  @override
  String get location => 'Konum';

  @override
  String get whatsNew => 'Yenilikler';

  @override
  String get unstar => 'Yıldızı kaldır';

  @override
  String get star => 'Yıldız';

  @override
  String get goUp => 'Yukarı git';

  @override
  String get created => 'Oluşturuldu';

  @override
  String get modified => 'Değiştirildi';

  @override
  String get quickstart => 'Hızlı Başlangıç';

  @override
  String get noTemplates => 'Şu anda kullanılabilir şablon yok';

  @override
  String get importCorePack => 'Çekirdek paketi içe aktar';

  @override
  String get importCorePackDescription =>
      'Başlamak için tüm temel varlıkları içeren temel paketi içe aktarın. Bu, mevcut çekirdek paketi geçersiz kılacaktır.';

  @override
  String get never => 'Asla';

  @override
  String get onlyOnUpdates => 'Yalnızca güncellemelerde';

  @override
  String get visibility => 'Görünürlük';

  @override
  String get captureThumbnail => 'Önizleme görseli yakala';

  @override
  String get capturedThumbnail => 'Önizleme görseli başarıyla yakalandı';

  @override
  String get chooseLabelMode => 'Etiket modunu seç';

  @override
  String get foreground => 'Ön plan';

  @override
  String get version => 'Sürüm';

  @override
  String get repository => 'Depo';

  @override
  String get pages => 'Sayfalar';

  @override
  String get navigator => 'Gezgin';

  @override
  String get arrange => 'Yerleştir';

  @override
  String get bringToFront => 'Öne getir';

  @override
  String get sendToBack => 'Arkaya gönder';

  @override
  String get bringForward => 'Bir adım öne getir';

  @override
  String get sendBackward => 'Bir adım geriye gönder';

  @override
  String get rotation => 'Döndürme';

  @override
  String get onlyAvailableLargerScreen =>
      'Sadece daha büyük ekranlarda kullanılabilir';

  @override
  String get toolbarPosition => 'Araç çubuğu konumu';

  @override
  String get rotate => 'Döndür';

  @override
  String get spacer => 'Boşluk';

  @override
  String get navigationRail => 'Gezinme rayı';

  @override
  String get cut => 'Kes';

  @override
  String get insertBefore => 'Öncesine ekle';

  @override
  String get insertAfter => 'Sonrasına ekle';

  @override
  String get insertFirst => 'Başa ekle';

  @override
  String get insertLast => 'Sona ekle';

  @override
  String get paste => 'Yapıştır';

  @override
  String get ascending => 'Artan';

  @override
  String get descending => 'Azalan';

  @override
  String get imageScale => 'Görsel ölçeği';

  @override
  String get select => 'Seç';

  @override
  String get tool => 'Araç';

  @override
  String get texture => 'Doku';

  @override
  String get platformTheme => 'Platform teması';

  @override
  String get desktop => 'Masaüstü';

  @override
  String get mobile => 'Mobil';

  @override
  String get pdfQuality => 'PDF kalitesi';

  @override
  String get surface => 'Yüzey';

  @override
  String get pattern => 'Desen';

  @override
  String get sureClose => 'Belgeyi kapatmak istediğinizden emin misiniz?';

  @override
  String get thereAreUnsavedChanges => 'Kaydedilmemiş değişiklikler var';

  @override
  String get page => 'Sayfa';

  @override
  String get iceServers => 'ICE Sunucuları';

  @override
  String get collaboration => 'İş birliği';

  @override
  String get webRtc => 'Web RTC';

  @override
  String get webSocket => 'Web Soket';

  @override
  String get iceServer => 'ICE Sunucusu';

  @override
  String get port => 'Port';

  @override
  String get type => 'Tür';

  @override
  String get side => 'Taraf';

  @override
  String get client => 'İstemci';

  @override
  String get server => 'Sunucu';

  @override
  String get switchView => 'Görünümü Değiştir';

  @override
  String get lasso => 'Kement';

  @override
  String get hideUI => 'Arayüzü Gizle';

  @override
  String get density => 'Yoğunluk';

  @override
  String get compact => 'Kompakt';

  @override
  String get comfortable => 'Rahat';

  @override
  String get standard => 'Standart';

  @override
  String get lock => 'Kilitle';

  @override
  String get addElement => 'Öğe ekle';

  @override
  String get notDefaultConnection => 'Varsayılan bağlantı değil';

  @override
  String get defaultConnection => 'Varsayılan bağlantı';

  @override
  String get hide => 'Gizle';

  @override
  String get show => 'Göster';

  @override
  String get pause => 'Duraklat';

  @override
  String get stop => 'Durdur';

  @override
  String get refresh => 'Yenile';

  @override
  String get print => 'Yazdır';

  @override
  String get dav => 'DAV';

  @override
  String get eyeDropper => 'Damlalık';

  @override
  String get users => 'Kullanıcılar';

  @override
  String get experiments => 'Deneyler';

  @override
  String get experimentsWarning =>
      'Bu özellikler deneysel olup herhangi bir zamanda değişebilir, bozulabilir veya kaybolabilir. Etkinleştirmek kararsızlığa veya veri kaybına neden olabilir. Dikkatli ilerleyin. Lütfen herhangi bir hatayı bildirin.';

  @override
  String get address => 'Adres';

  @override
  String get spreadToPages => 'Sayfalara yay';

  @override
  String get rootDirectorySpecifiedDescription =>
      'Kök dizin belirtildi. Tüm gelişmiş dizin yolları bu dizine göre relatif olacaktır. Bu dizin türünü devre dışı bırakmak için boş bırakın.';

  @override
  String get rootDirectoryNotSpecifiedDescription =>
      'Kök dizin belirtilmedi. Bir ad gereklidir. Tüm gelişmiş dizin yolları mutlak olacaktır. Bu dizin türünü devre dışı bırakmak için boş bırakın.';

  @override
  String get unsecureConnectionTitle => 'Güvensiz bağlantı';

  @override
  String unsecureConnectionMessage(String fingerprint) {
    return 'Bağlantı güvenli değil. Bu bir güvenlik riski oluşturabilir. Lütfen sadece bağlantıya güveniyorsanız devam edin. SHA1 parmak izi: $fingerprint.';
  }

  @override
  String get continueAnyway => 'Yine de devam et';

  @override
  String get zoomControl => 'Yakınlaştırma kontrolü';

  @override
  String get highContrast => 'Yüksek kontrast';

  @override
  String get shouldANumber => 'Bu değer geçerli bir sayı olmalıdır';

  @override
  String get createAreas => 'Alanlar oluştur';

  @override
  String get autosave => 'Otomatik kaydetme';

  @override
  String get invert => 'Ters çevir';

  @override
  String get operations => 'İşlemler';

  @override
  String get medium => 'Orta';

  @override
  String get large => 'Büyük';

  @override
  String get toolbarSize => 'Araç çubuğu boyutu';

  @override
  String get addAll => 'Tümünü ekle';

  @override
  String get onlyCurrentPage => 'Sadece geçerli sayfa';

  @override
  String get smoothNavigation => 'Akıcı gezinme';

  @override
  String get exact => 'Tam';

  @override
  String get inline => 'Satır içi';

  @override
  String get toolbarRows => 'Araç çubuğu satırları';

  @override
  String get pointerTest => 'İşaretçi testi';

  @override
  String get pressure => 'Basınç';

  @override
  String get small => 'Küçük';

  @override
  String get tiny => 'Minik';

  @override
  String get selectAll => 'Tümünü seç';

  @override
  String get overrideTools => 'Araçları geçersiz kıl';

  @override
  String get hideCursorWhileDrawing => 'Çizim yaparken imleci gizle';

  @override
  String get installed => 'Yüklü';

  @override
  String get install => 'Yükle';

  @override
  String get deselect => 'Seçimi kaldır';

  @override
  String get changeCollection => 'Koleksiyonu değiştir';

  @override
  String get collections => 'Koleksiyonlar';

  @override
  String get fullSelection => 'Tam seçim';

  @override
  String get fullSelectionDescription =>
      'Seçim için ögelerin seçim kutusunun içinde tamamen olmasını gerektirir.';

  @override
  String get collection => 'Koleksiyon';

  @override
  String get defaultCollection => 'Varsayılan koleksiyon';

  @override
  String get scroll => 'Kaydır';

  @override
  String get onStartup => 'Başlangıçta';

  @override
  String get homeScreen => 'Ana ekran';

  @override
  String get lastNote => 'Son not';

  @override
  String get newNote => 'Yeni not';

  @override
  String get convertToLayer => 'Katmana dönüştür';

  @override
  String get merge => 'Birleştir';

  @override
  String get up => 'Yukarı';

  @override
  String get down => 'Aşağı';

  @override
  String get other => 'Diğer';

  @override
  String countElements(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elements',
      one: '1 element',
      zero: 'No elements',
    );
    return '$_temp0';
  }

  @override
  String get colorToolbar => 'Renk araç çubuğu';

  @override
  String get yesButShowButtons => 'Evet, ama düğmeleri göster';

  @override
  String get optionsPanelPosition => 'Seçenekler paneli konumu';

  @override
  String get hideDuration => 'Gizleme süresi';

  @override
  String get animation => 'Animasyon';

  @override
  String get performance => 'Performans';

  @override
  String get performanceDescription =>
      'Hız ve bellek kullanımı için optimize edildi. Notun yalnızca görünen kısmı görüntüye işlenir.';

  @override
  String get normalDescription =>
      'Kalite ve performans arasında denge sağlar. Görünen alanın 1.5 katını kapsayan bir görüntü oluşturur, kaydırırken daha pürüzsüz geçişler sağlar.';

  @override
  String get high => 'Yüksek';

  @override
  String get highDescription =>
      'Maximizes quality at the cost of performance. Bakes an image covering 2 times the visible area, ensuring seamless rendering even during rapid scrolling or zooming.';

  @override
  String get renderResolution => 'Render çözünürlüğü';

  @override
  String get translate => 'Çevir';

  @override
  String get unencrypted => 'Şifrelenmemiş';

  @override
  String get encrypted => 'Şifrelenmiş';

  @override
  String get encryptDocumentMessage => 'Belgeyi şifrelemek için tıklayın';

  @override
  String get unencryptDocumentMessage =>
      'Belge şifrelemesini kaldırmak için tıklayın';

  @override
  String get unencrypt => 'Şifrelemesini Kaldır';

  @override
  String get encrypt => 'Şifrele';

  @override
  String get encryptWarning =>
      'Bu, belgeyi şifreleyecektir. Belgeyi çözmek için parolayı hatırlamanız gerekecektir.';

  @override
  String get unencryptWarning =>
      'Bu, belgenin şifrelemesini kaldıracaktır. Parola kaldırılacak ve erişimi olan herkes belgeyi açabilecek.';

  @override
  String get confirmPassword => 'Parolayı Onayla';

  @override
  String get passwordMismatch => 'Parolalar eşleşmiyor';

  @override
  String get action => 'Eylem';

  @override
  String get svgText => 'SVG Metni';

  @override
  String get offset => 'Ofset';

  @override
  String get positionDependent => 'Konuma bağlı';

  @override
  String get flipHorizontal => 'Yatay çevir';

  @override
  String get flipVertical => 'Dikey çevir';

  @override
  String get grayscale => 'Gri tonlama';

  @override
  String get moveOnGesture => 'Eylemle taşı';

  @override
  String get exportAllFiles => 'Tüm dosyaları dışa aktar';

  @override
  String get restoreSettingsFromFile => 'Ayarları dosyadan geri yükle';

  @override
  String get exportSettingsToFile => 'Ayarları dosyaya dışa aktar';

  @override
  String get barcode => 'Barkod';

  @override
  String get barcodeType => 'Barkod türü';

  @override
  String get qrCode => 'QR Kodu';

  @override
  String get dataMatrix => 'Data Matrix';

  @override
  String get code128 => 'Code 128';

  @override
  String defaultUserName(int index) {
    return 'Kullanıcı $index';
  }

  @override
  String get moveLeft => 'Sola taşı';

  @override
  String get moveRight => 'Sağa taşı';

  @override
  String get bundledPacks => 'Paketlenmiş Paketler';

  @override
  String get component => 'Component';

  @override
  String get selectComponent => 'Bileşen seç';

  @override
  String get bundlePackInDocument => 'Paketi belgeye dahil et';

  @override
  String get bundledPacksDescription =>
      'Birlikte paketlenmiş paketler belgeye dahil edilir ve yalnızca belge ile paylaşmak için kullanılabilir. Paket yüklendiğinde varlıklar yalnızca belgede kullanılabilir. Paketler üzerine tıklanarak yüklenebilir.';

  @override
  String get fillAlpha => 'Doldurma alfa';

  @override
  String get packagedFile => 'Paketlenmiş dosya';

  @override
  String get rawFile => 'Ham dosya';

  @override
  String get webSocketDescription =>
      'Cihazınız sunucu olarak hizmet veriyor, bu nedenle işbirlikçiler yalnızca aynı ağ üzerinden veya yönlendiricinizdeki portu yönlendirirseniz her yerden bağlanabilir.';

  @override
  String get swampDescription =>
      'Mesajlarınız uçtan uca şifrelemeli güvenli bir röle sunucusu üzerinden yönlendirilir. Bir swamp sunucu adresi oturum oluşturmak için gereklidir.';

  @override
  String get createRawNote => 'Ham not oluştur';

  @override
  String get polygon => 'Çokgen';

  @override
  String get finishShape => 'Şekli tamamla';

  @override
  String get submit => 'Gönder';

  @override
  String get math => 'Math';

  @override
  String get ignorePressure => 'Ignore pressure';

  @override
  String get ignoreFirstPressureDescription =>
      'On some devices, the first pressure value is not accurate. This setting will ignore the first pressure value and use the pressure of the second event instead.';

  @override
  String get temporary => 'Temporary';

  @override
  String get simpleToolbarVisibility => 'Simple toolbar visibility';

  @override
  String get autosaveDelay => 'Autosave delay';

  @override
  String get saved => 'Saved';

  @override
  String get saving => 'Saving...';

  @override
  String get readOnly => 'Read only';

  @override
  String get saveDelayed => 'Save delayed';

  @override
  String get unsaved => 'Unsaved';

  @override
  String get pdfEmptyDescription =>
      'There are currently no areas to export. Please select at least one area using the plus button in the top right corner or add all areas from the current page or from the whole document below.';

  @override
  String get densityMaximize => 'Büyüt';
}
